/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.util;

import com.biz.eisp.annotation.DataName;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    private static final Logger log = LoggerFactory.getLogger(ReflectionUtils.class);
    private static final String SETTER_PREFIX = "set";
    private static final String GETTER_PREFIX = "get";
    private static final String CGLIB_CLASS_SEPARATOR = "$$";

    public static Object getFieldValue(Object obj, String fieldName) {
        Field field = ReflectionUtils.getAccessibleField(obj, fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + fieldName + "] on target [" + obj + "]");
        }
        Object result = null;
        try {
            result = field.get(obj);
        }
        catch (IllegalAccessException e) {
            log.error("\u4e0d\u53ef\u80fd\u629b\u51fa\u7684\u5f02\u5e38{}", (Object)e.getMessage());
        }
        return result;
    }

    public static Field getAccessibleField(Object obj, String fieldName) {
        for (Class<?> superClass = obj.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                Field field = superClass.getDeclaredField(fieldName);
                ReflectionUtils.makeAccessible(field);
                return field;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return null;
    }

    public static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    public static List<Map<String, Object>> compareTwoClass(Object class1, Object class2) throws ClassNotFoundException, IllegalAccessException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Class<?> clazz1 = class1.getClass();
        Class<?> clazz2 = class2.getClass();
        Field[] field1 = clazz1.getDeclaredFields();
        Field[] field2 = clazz2.getDeclaredFields();
        block0: for (int i = 0; i < field1.length; ++i) {
            for (int j = 0; j < field2.length; ++j) {
                if (!field1[i].getName().equals(field2[j].getName())) continue;
                field1[i].setAccessible(true);
                field2[j].setAccessible(true);
                if (ReflectionUtils.compareTwo(field1[i].get(class1), field2[j].get(class2))) continue block0;
                HashMap<String, Object> map2 = new HashMap<String, Object>();
                DataName name = field1[i].getAnnotation(DataName.class);
                String fieldName = "";
                fieldName = name != null ? name.name() : field1[i].getName();
                map2.put("name", fieldName);
                map2.put("old", field1[i].get(class1));
                map2.put("new", field2[j].get(class2));
                list.add(map2);
                continue block0;
            }
        }
        return list;
    }

    public static boolean compareTwo(Object object1, Object object2) {
        if (object1 == null && object2 == null) {
            return true;
        }
        if (object1 == null && object2 != null) {
            return false;
        }
        return object1.equals(object2);
    }
}

