/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.annotation;

import com.biz.eisp.annotation.QueryField;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.util.StringUtils;

public enum QueryType {
    EQUALS{

        @Override
        public Criteria buildCriteria(QueryField queryFieldAnnotation, Field field, Object value) {
            if (QueryType.check(queryFieldAnnotation, field, value)) {
                String queryField = QueryType.getQueryFieldName(queryFieldAnnotation, field);
                return Criteria.where((String)queryField).is((Object)value.toString());
            }
            return new Criteria();
        }
    }
    ,
    LIKE{

        @Override
        public Criteria buildCriteria(QueryField queryFieldAnnotation, Field field, Object value) {
            if (QueryType.check(queryFieldAnnotation, field, value)) {
                String queryField = QueryType.getQueryFieldName(queryFieldAnnotation, field);
                return Criteria.where((String)queryField).regex(value.toString());
            }
            return new Criteria();
        }
    }
    ,
    IN{

        @Override
        public Criteria buildCriteria(QueryField queryFieldAnnotation, Field field, Object value) {
            if (QueryType.check(queryFieldAnnotation, field, value) && value instanceof List) {
                String queryField = QueryType.getQueryFieldName(queryFieldAnnotation, field);
                return Criteria.where((String)queryField).in((Collection)((List)value));
            }
            return new Criteria();
        }
    };


    private static boolean check(QueryField queryField, Field field, Object value) {
        return queryField != null && field != null && value != null;
    }

    public abstract Criteria buildCriteria(QueryField var1, Field var2, Object var3);

    private static String getQueryFieldName(QueryField queryField, Field field) {
        String queryFieldValue = queryField.attribute();
        if (!StringUtils.hasText((String)queryFieldValue)) {
            queryFieldValue = field.getName();
        }
        return queryFieldValue;
    }
}

