/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.controller.track;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.service.track.KnlMongoTrackService;
import com.biz.eisp.worktrack.entity.TrackPointMongoEntity;
import com.biz.eisp.worktrack.track.trackterminal.TrackTerminalLastVo;
import com.biz.eisp.worktrack.vo.CountUserVo;
import com.biz.eisp.worktrack.vo.GetTrackPramsVo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/knlMongoTrackApiController"})
public class KnlMongoTrackApiController {
    private static final Logger log = LoggerFactory.getLogger(KnlMongoTrackApiController.class);
    @Autowired
    private KnlMongoTrackService knlMongoTrackService;

    @PostMapping(value={"savePoints"})
    public AjaxJson savePoints(@RequestBody TrackPointMongoEntity entity) {
        AjaxJson json = new AjaxJson();
        try {
            this.knlMongoTrackService.saveTrackPoint(entity);
        }
        catch (Exception e) {
            log.error("\u63d0\u4ea4\u5931\u8d25", (Throwable)e);
            json.setErrMsg("\u63d0\u4ea4\u5931\u8d25:");
        }
        return json;
    }

    @PostMapping(value={"queryUserList"})
    public AjaxJson<TrackTerminalLastVo> queryUserList(@RequestParam(value="userIds") String userIds) {
        AjaxJson json = new AjaxJson();
        try {
            List<TrackTerminalLastVo> list = this.knlMongoTrackService.queryUserList(userIds);
            json.setObjList(list);
        }
        catch (Exception e) {
            log.error("\u63d0\u4ea4\u5931\u8d25", (Throwable)e);
            json.setErrMsg("\u63d0\u4ea4\u5931\u8d25:");
        }
        return json;
    }

    @PostMapping(value={"queryDistance"})
    public AjaxJson queryDistance(@RequestParam(value="userId") String userId, @RequestParam(value="dateStr") String dateStr) {
        AjaxJson json = new AjaxJson();
        try {
            Double distance = this.knlMongoTrackService.queryDistance(userId, dateStr);
            json.setObj((Object)distance);
        }
        catch (Exception e) {
            log.error("\u63d0\u4ea4\u5931\u8d25", (Throwable)e);
            json.setErrMsg("\u63d0\u4ea4\u5931\u8d25:");
        }
        return json;
    }

    @PostMapping(value={"queryTracksByMongo"})
    public AjaxJson<TrackPointMongoEntity> queryTracksByMongo(@RequestBody GetTrackPramsVo vo) {
        AjaxJson json = new AjaxJson();
        try {
            List<TrackPointMongoEntity> list = this.knlMongoTrackService.queryTracksByMongo(vo);
            json.setObjList(list);
        }
        catch (Exception e) {
            log.error("\u63d0\u4ea4\u5931\u8d25", (Throwable)e);
            json.setErrMsg("\u63d0\u4ea4\u5931\u8d25:");
        }
        return json;
    }

    @PostMapping(value={"queryPointGroupByUserAndDateStr"})
    public AjaxJson<CountUserVo> queryPointGroupByUserAndDateStr(@RequestParam(value="dateStr") String dateStr) {
        AjaxJson json = new AjaxJson();
        try {
            List<CountUserVo> list = this.knlMongoTrackService.queryPointGroupByUserAndDateStr(dateStr);
            json.setObjList(list);
        }
        catch (Exception e) {
            log.error("\u63d0\u4ea4\u5931\u8d25", (Throwable)e);
            json.setErrMsg("\u63d0\u4ea4\u5931\u8d25:");
        }
        return json;
    }
}

