/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.utils;

import com.biz.eisp.utils.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ReflectionUtils {
    private static final Logger log = LoggerFactory.getLogger(ReflectionUtils.class);

    public static Object invokeGetterMethod(Object obj, String propertyName) {
        String getterMethodName = "get" + StringUtils.capitalize((String)propertyName);
        return ReflectionUtils.invokeMethod(obj, getterMethodName, new Class[0], new Object[0]);
    }

    public static void invokeSetterMethod(Object obj, String propertyName, Object value) {
        ReflectionUtils.invokeSetterMethod(obj, propertyName, value, null);
    }

    public static void invokeSetterMethod(Object obj, String propertyName, Object value, Class<?> propertyType) {
        Class<?> type = propertyType != null ? propertyType : value.getClass();
        String setterMethodName = "set" + StringUtils.capitalize((String)propertyName);
        ReflectionUtils.invokeMethod(obj, setterMethodName, new Class[]{type}, new Object[]{value});
    }

    public static Object getFieldValue(Object obj, String fieldName) {
        Field field = ReflectionUtils.getAccessibleField(obj, fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + fieldName + "] on target [" + obj + "]");
        }
        Object result = null;
        try {
            result = field.get(obj);
        }
        catch (IllegalAccessException e) {
            log.error("\u4e0d\u53ef\u80fd\u629b\u51fa\u7684\u5f02\u5e38{}", (Object)e.getMessage());
        }
        return result;
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) {
        Field field = ReflectionUtils.getAccessibleField(obj, fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + fieldName + "] on target [" + obj + "]");
        }
        try {
            field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            log.error("\u4e0d\u53ef\u80fd\u629b\u51fa\u7684\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }

    public static Field getAccessibleField(Object obj, String fieldName) {
        Assert.notNull((Object)obj, (String)"object\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)fieldName, (String)"fieldName");
        for (Class<?> superClass = obj.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                Field field = superClass.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    public static Object invokeMethod(Object obj, String methodName, Class<?>[] parameterTypes, Object[] args) {
        Method method = ReflectionUtils.getAccessibleMethod(obj, methodName, parameterTypes);
        if (method == null) {
            throw new IllegalArgumentException("Could not find method [" + methodName + "] on target [" + obj + "]");
        }
        try {
            return method.invoke(obj, args);
        }
        catch (Exception e) {
            throw ReflectionUtils.convertReflectionExceptionToUnchecked(e);
        }
    }

    public static Method getAccessibleMethod(Object obj, String methodName, Class<?> ... parameterTypes) {
        Assert.notNull((Object)obj, (String)"object\u4e0d\u80fd\u4e3a\u7a7a");
        for (Class<?> superClass = obj.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                Method method = superClass.getDeclaredMethod(methodName, parameterTypes);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        return null;
    }

    public static <T> Class<T> getSuperClassGenricType(Class clazz) {
        return ReflectionUtils.getSuperClassGenricType(clazz, 0);
    }

    public static Class getSuperClassGenricType(Class clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            log.warn(clazz.getSimpleName() + "'s superclass not ParameterizedType");
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            log.warn("Index: " + index + ", Size of " + clazz.getSimpleName() + "'s Parameterized Type: " + params.length);
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            log.warn(clazz.getSimpleName() + " not set the actual class on superclass generic parameter");
            return Object.class;
        }
        return (Class)params[index];
    }

    public static RuntimeException convertReflectionExceptionToUnchecked(Exception e) {
        if (e instanceof IllegalAccessException || e instanceof IllegalArgumentException || e instanceof NoSuchMethodException) {
            return new IllegalArgumentException("Reflection Exception.", e);
        }
        if (e instanceof InvocationTargetException) {
            return new RuntimeException("Reflection Exception.", ((InvocationTargetException)e).getTargetException());
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException("Unexpected Checked Exception.", e);
    }

    public static Update getUpdateObj(Object obj) {
        if (obj == null) {
            return null;
        }
        Field[] fields = obj.getClass().getDeclaredFields();
        Update update = null;
        boolean isFirst = true;
        for (Field field : fields) {
            field.setAccessible(true);
            try {
                Object value = field.get(obj);
                if (value == null || "id".equals(field.getName().toLowerCase()) || "serialversionuid".equals(field.getName().toLowerCase())) continue;
                if (isFirst) {
                    update = Update.update((String)field.getName(), (Object)value);
                    isFirst = false;
                    continue;
                }
                update = update.set(field.getName(), value);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return update;
    }

    public static Query getQueryObj(Object obj) {
        if (obj == null) {
            return null;
        }
        Field[] fields = obj.getClass().getDeclaredFields();
        Query query = new Query();
        HashMap<String, Criteria> dateMap = new HashMap<String, Criteria>();
        String sortStr = null;
        for (Field field : fields) {
            field.setAccessible(true);
            try {
                Object value = field.get(obj);
                if (value == null || "serialversionuid".equals(field.getName().toLowerCase())) continue;
                if ("orderby".equals(field.getName().toLowerCase())) {
                    sortStr = String.valueOf(value);
                    continue;
                }
                if (field.getType().getSimpleName().equals("Date")) {
                    Criteria criteria;
                    if (field.getName().toLowerCase().startsWith("begin")) {
                        String beginName = field.getName().substring(5);
                        if (beginName.isEmpty()) {
                            dateMap.put("begin", Criteria.where((String)"begin").is(value));
                            continue;
                        }
                        criteria = dateMap.get(beginName = StringUtil.toLowerCaseFirstOne(beginName)) == null ? Criteria.where((String)beginName).gte(value) : ((Criteria)dateMap.get(beginName)).gte(value);
                        dateMap.put(beginName, criteria);
                        continue;
                    }
                    if (field.getName().toLowerCase().startsWith("end")) {
                        String endName = field.getName().substring(3);
                        if (endName.isEmpty()) {
                            dateMap.put("end", Criteria.where((String)"end").is(value));
                            continue;
                        }
                        criteria = dateMap.get(endName = StringUtil.toLowerCaseFirstOne(endName)) == null ? Criteria.where((String)endName).lt(value) : ((Criteria)dateMap.get(endName)).lt(value);
                        dateMap.put(endName, criteria);
                        continue;
                    }
                    dateMap.put(field.getName(), Criteria.where((String)field.getName()).is(value));
                    continue;
                }
                query.addCriteria((CriteriaDefinition)Criteria.where((String)field.getName()).is(value));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        for (String key : dateMap.keySet()) {
            if (dateMap.get(key) == null) continue;
            query.addCriteria((CriteriaDefinition)dateMap.get(key));
        }
        if (sortStr != null && !sortStr.trim().isEmpty()) {
            String[] strs;
            Sort sort = null;
            for (String str : strs = sortStr.split(",")) {
                if ((str = str.trim()).isEmpty()) continue;
                int i = str.indexOf(" ");
                if (i < 0) {
                    if (sort == null) {
                        sort = new Sort(Sort.Direction.ASC, new String[]{str});
                        continue;
                    }
                    sort = sort.and(new Sort(Sort.Direction.ASC, new String[]{str}));
                    continue;
                }
                String name = str.substring(0, i);
                String dire = str.substring(i + 1).trim();
                Sort sn = null;
                sn = "desc".equals(dire.toLowerCase()) ? new Sort(Sort.Direction.DESC, new String[]{name}) : new Sort(Sort.Direction.ASC, new String[]{name});
                sort = sort == null ? sn : sort.and(sn);
            }
            if (sort != null) {
                query.with(sort);
            }
        }
        return query;
    }

    public static HashMap<String, Object> Reflect(Object obj) throws IllegalAccessException, IllegalArgumentException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (obj == null) {
            return null;
        }
        Field[] fields = obj.getClass().getDeclaredFields();
        for (int j = 0; j < fields.length; ++j) {
            fields[j].setAccessible(true);
            Object _Object = fields[j].get(obj);
            map.put(fields[j].getName(), _Object);
        }
        return map;
    }

    public static void main(String[] a) {
    }
}

