/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.operation;

import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.config.SpringApplicationContextUtil;
import com.biz.eisp.mdm.feign.OperationFeign;
import com.biz.eisp.mdm.privilege.vo.PrivilegeSearchVo;
import com.biz.eisp.mdm.vo.OperationAuthobj;
import com.biz.eisp.operation.util.OperationSql;
import com.biz.eisp.operation.util.OperationSqlFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OperationConfig {
    private static OperationFeign operationFeign;

    public static String createOperationSql(PrivilegeSearchVo privilegeSearchVo, String funId) {
        UserRedis userRedis;
        StringBuffer stringBuffer = new StringBuffer();
        if (privilegeSearchVo == null) {
            stringBuffer.append("1=2");
            return stringBuffer.toString();
        }
        if (operationFeign == null) {
            operationFeign = (OperationFeign)SpringApplicationContextUtil.getApplicationContext().getBean("operationFeign");
        }
        if ((userRedis = UserUtils.getUser()) == null) {
            stringBuffer.append("1=2");
            return stringBuffer.toString();
        }
        if ("admin".equalsIgnoreCase(userRedis.getUsername())) {
            return stringBuffer.toString();
        }
        if (!StringUtil.isBlank((CharSequence)funId)) {
            Boolean boo = (Boolean)operationFeign.checkFunOperation(funId).getObj();
            if (boo.booleanValue()) {
                return OperationConfig.createSqlgetData(privilegeSearchVo, funId, userRedis);
            }
            return stringBuffer.toString();
        }
        if (!StringUtil.isBlank((CharSequence)privilegeSearchVo.getOperationcode())) {
            return stringBuffer.toString();
        }
        return stringBuffer.toString();
    }

    private static String createSqlgetData(PrivilegeSearchVo privilegeSearchVo, String funId, UserRedis userRedis) {
        List authobjs = operationFeign.findAuthobjUserAndFunId(userRedis.getId(), funId, "").getObjList();
        if (CollectionUtil.listEmpty((List)authobjs)) {
            return "1=2";
        }
        HashMap orgListMap = new HashMap();
        authobjs.stream().collect(Collectors.groupingBy(OperationAuthobj::getAuthobj, Collectors.toList())).forEach((authobj, list) -> orgListMap.put(authobj, list));
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry tempMap : orgListMap.entrySet()) {
            String sql = OperationConfig.createSqlBytype((String)tempMap.getKey(), (List)tempMap.getValue(), userRedis, privilegeSearchVo);
            if (!StringUtil.isNotEmpty((CharSequence)sql)) continue;
            if (stringBuffer.length() == 0) {
                stringBuffer.append(sql);
                continue;
            }
            stringBuffer.append(" and ").append(sql);
        }
        return stringBuffer.toString();
    }

    private static String createSqlBytype(String type, List<OperationAuthobj> authobjValues, UserRedis userRedis, PrivilegeSearchVo privilegeSearchVo) {
        OperationSql budgetOperation = OperationSqlFactory.getOperation(type).orElseThrow(() -> new IllegalArgumentException("\u6ca1\u6709\u5b9a\u4e49\u5904\u7406\u903b\u8f91"));
        return budgetOperation.createSql(authobjValues, userRedis, privilegeSearchVo);
    }
}

