var matnrMap = new Map();

/**
 * 物料选择扩展
 * @param a
 * @param b
 * @param c
 */
function baseMatnrCalculate(a,b,c) {
    if(b==null){
        return;
    }
    var productInfoCode = b.productInfoCode;
    var costPrice = b.costPrice;
    if(isEmpty(productInfoCode)){
        costPrice = 0;
    }
    matnrMap.set(productInfoCode,costPrice);
    if($(a).parents("tr").find("input[field=productNum]").length>0){
        var productNum = $(a).parents("tr").find("input[field=productNum]").val();
        if(!isEmpty(productNum)&&productNum!='null'){
            var amount  = (Number(productNum)*Number(costPrice)).toFixed(2);
            $(a).parents("tr").find("input[field=amount]").val(amount);
        }else{
            $(a).parents("tr").find("input[field=amount]").val(0);
        }
    }
}

/**
 * 基础数量监听
 * @param a
 * @param b
 * @param c
 */
function baseProductNumCalculate(a,b,c) {
    if(a==null){
        return;
    }
    var productNum = $(a).val();
    if(!isEmpty(productNum)){
        var productInfoCode = $(a).parents("tr").find("input[field=productCode]").val();
        if(!isEmpty(productNum)&&productNum!='null'&&matnrMap.has(productInfoCode)){
            var amount  = (Number(productNum)*Number(matnrMap.get(productInfoCode))).toFixed(2);
            $(a).parents("tr").find("input[field=amount]").val(amount);
        }else{
            $(a).parents("tr").find("input[field=amount]").val(0);
        }
    }else{
        $(a).parents("tr").find("input[field=amount]").val(0);
    }
}

/**
 * 基础选择政策
 * @param a
 * @param b
 * @param c
 */
function basePolicyCodeCalculate(a,b,c) {
    if(b==null){
        return;
    }
    var feeRate = b.feeRate;
    var amount = 0;
    if(!isEmpty(feeRate)){
        if($(a).parents("tr").find("input[field=fsalesAmountCustomer]").length>0){
            var fsalesAmountCustomer = $(a).parents("tr").find("input[field=fsalesAmountCustomer]").val();
            if(!isEmpty(fsalesAmountCustomer)&&fsalesAmountCustomer!="null"){
                amount =  (Number(fsalesAmountCustomer)*Number(feeRate)/100).toFixed(2);
            }
        }
    }
    $(a).parents("tr").find("input[field=amount]").val(amount);

}

/**
 * 基础客户预估销售额
 * @param a
 * @param b
 * @param c
 */
function baseFsalesAmountCustomer(a,b,c) {
    if(a==null){
        return;
    }
    var fsalesAmountCustomer = $(a).val();
    var amount = 0;
    if(!isEmpty(fsalesAmountCustomer)&&fsalesAmountCustomer!='null'){
        if($(a).parents("tr").find("input[field=feeRate]").length>0){
           var feeRate = $(a).parents("tr").find("input[field=feeRate]").val();
           if(!isEmpty(feeRate)&&feeRate!='null'){
               amount =  (Number(fsalesAmountCustomer)*Number(feeRate)/100).toFixed(2);
               $(a).parents("tr").find("input[field=amount]").val(amount);
           }
        }
    }
}