<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@include file="/context/mytags.jsp"%>
<t:base type="jquery,easyui,tools"></t:base>
<link rel="stylesheet" href="/resources/form/form.css"></link>
<script type="text/javascript" src="/resources/util/htmlLoading.js"></script>
<script type="text/javascript" src="/resources/util/loading.js"></script>
<style type="text/css">
    html, body {
        line-height: 1.5;
        font-size: 14px;
        background:#f5f5f5;
    }
    * {
        margin: 0;
        padding: 0;
    }
    /* .attachment a {
        color: Black;
        text-decoration: none;
    }
	
    .attachment a:hover {
        color: #555555;
        text-decoration: none;
    } */
    .check_btn{
	    width:150px; 
	    height:50px; 
	    display:inline-block; 
	    text-decoration:none; 
	    line-height:50px; 
	    text-align:center; 
	    font-size:20px; 
	    background-color:#1479B3; 
	    color:#ffffff; 
	    border-radius:50px;
	}
	 .td_btn a:hover{
	  	color:#ffffff; 
		background-color:#4FACD8; 
	}
	.td_ck_detail{
		border: 1px solid #B5B5B5; 
		height: 420px; 
		vertical-align: top;
	}
	.check_table{width: 100%; padding: 5px;}
	.check_time{width: 150px; vertical-align: top; text-align: center;color: #B5B5B5; border-bottom: 0px solid #B5B5B5;}
	.check_node{width: 150px; vertical-align: top; text-align: left; border-bottom: 0px solid #B5B5B5;}
	.check_result{width: auto; vertical-align: top; text-align: left; word-break:break-all; border-bottom: 0px solid #B5B5B5;}
	.check_state{width: 30px; vertical-align: top; text-align: center; border-bottom: 0px solid #B5B5B5;}
</style>
<table style="width: 100%;padding: 10px; background: #f5f5f5;">
  <tr>
  	<td>
  		<div class="f-form-title" style="padding: 10px;">
            <h1>历史检测报告</h1>
            <div class="attachment" id="attachment">
                <div style="float: left;height:18px;"><span id="fileCount">0</span>条历史记录：</div>
                <div id="enc" style="float: left;height:18px;"></div>
                <div style="float: right;height:18px;">
                	<a onclick="clickEnc()" id="more" style="cursor: hand;" state="close">∨ 更多</a>
                </div>
            </div>
	    </div>
  	</td>
  </tr>
  <tr>
    <td style="padding-top: 5px;">
    	<div class="f-form-title change_height" style="height:530px;padding: 10px;">
    		<table style="width: 100%;">
    			<tr>
	    			<td width="100" valign="middle" align="center" height="80">
	    				<img id="img_ts" src="/resources/procheck/img/icon_ts.png" width="80" height="80"/>
	    				<img id="img_load" src="/resources/procheck/img/icon_load.gif" width="70" height="70" style="display: none;"/>
	    			</td>
	    			<td width="auto" valign="middle" align="left">
	    				<p style="font-size: 26px;" id="ck_big_remark">等待检测...</p>
	    				<p style="font-size: 12px; color: #555555;" id="ck_smal_remark"></p>
	    			</td>
	    			<td width="100" valign="middle" align="center">
	    				<p style="font-size: 26px;">&nbsp;</p>
	    				<p style="font-size: 12px; color: #555555;">
	    					<a onclick="querySet()" id="querySet" style="cursor: hand;">[参数设置]</a>
	    				</p>
	    			</td>
	    			<td width="170" class="td_btn" valign="middle" align="center">
	    				<a href="#" id="startCheck" class="check_btn" onClick="startCheck();">开始检测</a>
	    				<a href="#" id="stopCheck" class="check_btn" style="display: none;" onClick="stopCheck();">停止检测</a>
	    				<a href="#" id="saveCheck" class="check_btn" style="display: none;" onClick="saveCheck();">生成报告</a>
	    			</td>
    			</tr>
    			<tr>
    				<td colspan="4" align="left">
    					<div id="ckProgressbar" class="easyui-progressbar" data-options="value:0"  style="width:1000px;"></div> 
    				</td>
    			</tr>
    			<tr>
    				<td colspan="4" class="td_ck_detail change_height">
	    				<div style="width: 100%; height: 416px; overflow: auto;" class="change_height">
	    					<div id="check_pass">
		    					<p style="font-size: 14px;padding: 3px; font-weight: bolder;">
		    						【流程通过】检测 - 共 <span style="color: #1479B3;" id="pass_num">0</span> 项
		    					</p>
		    					<table id="pass_table" class="check_table"></table>
	    					</div>
	    				</div>
    				</td>
    			</tr>
    		</table>
    	</div>
    </td>
  </tr>
</table>
<script type="text/javascript">
	
	function hideOtherRel() {
	    var allrel = $("#enc").children();
	    for (var i = 0; i < allrel.length; i++) {
	        if (i == 0) {
	            $(allrel[i]).show();
	        } else {
	            $(allrel[i]).hide();
	        }
	    }
	}
	
	function showOtherRel() {
	    var allrel = $("#enc").children();
	    for (var i = 0; i < allrel.length; i++) {
	        $(allrel[i]).show();
	    }
	}
	
	function clickEnc() {
	    var state = $('#more').attr("state");
	    var fileCount = $("#fileCount").html();
	    var addHeight = 0;
	    if (fileCount > 0) {
	        addHeight = (fileCount - 1) * 18;
	    }
	    if (state == 'close') {
	        $('#more').html('∧ 收起');
	        $('#more').attr("state", "open");
	        $('#attachment').height(function (index, oldheight) {
	            return oldheight + addHeight;
	        });
	        $('#enc').height(function (index, oldheight) {
	            return oldheight + addHeight;
	        });
	        showOtherRel();
	    } else {
	        $('#more').html('∨ 更多');
	        $('#more').attr("state", "close");
	        $('#attachment').height(function (index, oldheight) {
	            return oldheight - addHeight;
	        });
	        $('#enc').height(function (index, oldheight) {
	            return oldheight - addHeight;
	        });
	        hideOtherRel();
	    }
	}
	
	var countCkNum = 0;// 总共检测数
	var doneCkNum = 0;// 做过的检测项统计
	var allCkState = "0";// 检测状态
	var processCkRecord = eval(${processCkRecord});
	var ckRecordId = "";
	var ckStartTime = "";
	var ckEndTime = "";
	var	ckRecordHtml = '<tr class="check_record">'+
							'<td class="check_time">[0000-00-00 00:00:00]</td>'+
							'<td class="check_node"></td>'+
							'<td class="check_result"></td>'+
							'<td class="check_state" checkState="0">'+
								'<span style="color: #B5B5B5;">待测</span>'+
							'</td>'+
						'</tr>';
						
    $(function(){
		parent.proCkQuerySet = {};
		parent.proCkQuerySetAddIndex = 1;
		parent.proCkQueryTable = "";
		parent.paramIsCanNull = false;
		
		//通过检测项
		var passNum = processCkRecord.ckPassDetails.length;
		$("#pass_num").html(passNum);
		for(var i = 0; i < passNum; i ++){
			var ckPassDetail = processCkRecord.ckPassDetails[i];
			var passTrHtml = $(ckRecordHtml).clone();
			passTrHtml.find(".check_node").html(ckPassDetail.nodeName);
			passTrHtml.attr("id", "pass_" + ckPassDetail.nodeKey);
			$("#pass_table").append(passTrHtml);
		}
		countCkNum = countCkNum + passNum;
		
		loadHisRecord();
	});
    
  	//加载历史记录
    function loadHisRecord() {
        $.ajax({
            url: '${webRoot}taProcessCheckController/loadHisRecord',
            type: "post",
            async: false,
            data: {processId: processCkRecord.processId},
            success: function (data) {
                var d = $.parseJSON(data);
                var insertText = "";
                for (var i = 0; i < d.length; i++) {
                    var dataId = d[i].id;
                    var deleHtml = '<a href="javascript:deleteHis(\'' + dataId + '\');">' +
                        '&nbsp;<i><img src="/resources/easyui/themes/icons/no.png" width="11" height="11"></i></a>';
                    var imgHtml = '<i><img src="/resources/easyui/themes/icons/dataOut.png" width="11" height="11"></i>';
                    var stateHtml = '[<span style="color:green;">成功</span>]';
                    if(d[i].state == '2')  stateHtml = '[<span style="color:red;">失败</span>]';
                    insertText = insertText + '<p id="' + dataId + '">' +
                        '[' + d[i].checkTime + ']&nbsp;&nbsp;<a href="javascript:openHis(\'' + dataId + '\');">'
                        + imgHtml + '&nbsp;' + d[i].title + '</a>' + stateHtml + '&nbsp;' + deleHtml + '</p>';
                }
                $("#enc").append(insertText);
                $("#fileCount").html(d.length);
                hideOtherRel();
            }
        });
    }
  	
    //历史记录删除
    function deleteHis(id) {
        $.ajax({
            url: '${webRoot}taProcessCheckController/deleteHis',
            type: "post",
            async: false,
            data: {id: id},
            success: function (data) {
                var fileCount = $("#fileCount").html();
                $("#fileCount").html(parseInt(fileCount) - 1);
                $("#" + id).remove();
                var state = $('#more').attr("state");
                if (state == 'open') {
                    if (fileCount > 1) {
                        $('#attachment').height(function (index, oldheight) {
                            return oldheight - 18;
                        });
                        $('#enc').height(function (index, oldheight) {
                            return oldheight - 18;
                        });
                        showOtherRel();
                    }
                } else {
                    hideOtherRel();
                }
            }
        });
    }
    
    //历史记录打开
    function openHis(id) {
        var targetUrl = '${webRoot}taProcessCheckController/openHis?recordId=' + id;
        window.open(targetUrl, "WINDOW_" + id);
    }
  	
    var batchId = "";
    var isDisable = false;
	// 生成报告
	function saveCheck(){
		if(isDisable) return;
		isDisable = true;
		var resultRemark = $("#ck_smal_remark").html();
		if(parent.proCkQuerySet.isBatchUser == 1){
			loadingTips.add("批量检测报告生成所需时间较长，请耐心等候...");
			//保存检测记录(批量)
	    	$.ajax({
	            url: "${webRoot}taProcessCheckController/saveBatchCk",
	            type: "post",
	            async: false,
	            data: {
	            	batchId : batchId,
	            	resultRemark : resultRemark
	            },
	            success: function (data) {
	            	var d = $.parseJSON(data);
	            	top.tip(d.msg);
	                if(d.success){
	                	self.location.reload();
	                }else{
	                	isDisable = false;
	                	loadingTips.remove();
	                }
	                
	            }
			});
		}else{
			//保存检测记录
	    	$.ajax({
	            url: "${webRoot}taProcessCheckController/updateCkRecord",
	            type: "post",
	            async: false,
	            data: {
	            	id : ckRecordId,
	            	title : parent.proCkQuerySet.title,
	            	resultRemark : resultRemark,
	            	state : allCkState,
	            	ckParams : JSON.stringify(parent.proCkQuerySet)
	            },
	            success: function (data) {
	            	var d = $.parseJSON(data);
	            	top.tip(d.msg);
	                if(d.success){
	                	self.location.reload();
	                }else{
	                	isDisable = false;
	                }
	                
	            }
			});
		}
		
	}
	
	// 参数校验
	function validateParams(){
		if(parent.proCkQueryTable == ""){
			top.tip("请先设置检测参数！");
			return false;
		}
		if(parent.proCkQuerySet.title == null || parent.proCkQuerySet.title == ""){
			top.tip("检测报告名不能为空！");
			return false;
		}
		if(parent.proCkQuerySet.isBatchUser == null || parent.proCkQuerySet.isBatchUser == ""){
			top.tip("是否批量用户检测为必选项！");
			return false;
		}
		if(parent.proCkQuerySet.proStartUserName == null || parent.proCkQuerySet.proStartUserName == ""){
			top.tip("发起人账号不能为空！");
			return false;
		}
		if(parent.proCkQuerySet.isBatchUser == 1){
			var users = parent.proCkQuerySet.proStartUserName.split(",");
			if(users.length < 2){
				top.tip("发起人批量账号格式不正确！");
				return false;
			}
			if(users.length > 1000){
				top.tip("发起人批量检测账号不能超过1000个！");
				return false;
			}
		}
		if(!parent.paramIsCanNull){
			if(parent.proCkQuerySet.paramName == null || parent.proCkQuerySet.paramName == ""){
				top.tip("参数变量名不能为空！");
				return false;
			}
			if(parent.proCkQuerySet.paramValue == null || parent.proCkQuerySet.paramValue == ""){
				top.tip("参数变量值不能为空！");
				return false;
			}
		}
		return true;
	}
	
	// 开始检测
	function startCheck(){
		if(!validateParams()){
			return;
		}
		ckStartTime = (new Date()).valueOf();
    	$("#startCheck").hide();
    	$("#img_ts").hide();
    	$("#stopCheck").show();
    	$("#img_load").show();
    	$("#ck_big_remark").html("正在检测...");
    	if(parent.proCkQuerySet.isBatchUser == 1){
    		$("#ck_big_remark").html("已交后台批量检测，请耐心等待...");
    		$("#check_pass").hide();
    		toBatchCheck();
    	}else{
    		//保存检测记录
        	$.ajax({
                url: "${webRoot}taProcessCheckController/saveCkRecord",
                type: "post",
                async: false,
                data: {
                	processId : processCkRecord.processId,
                	proCkQuerySet : JSON.stringify(parent.proCkQuerySet)
                },
                success: function (data) {
                	var d = $.parseJSON(data);
                    if(d.success){
                    	ckRecordId = d.obj;
                    	var firstNodeKey = "TO_START";
                    	setSmalLoad(firstNodeKey);
                    	setTimeout(function() {
                    		passCkReq(firstNodeKey, ckRecordId);
                    	}, 100);
                    }else{
                    	top.tip(d.msg);
                    }
                }
    		});
    	}
	}
	
	// 批量检测执行
	function toBatchCheck(){
		$.ajax({
            url: "${webRoot}taProcessCheckController/toBatchCheck",
            type: "post",
            async: false,
            data: {
            	processId : processCkRecord.processId,
            	proCkQuerySet : JSON.stringify(parent.proCkQuerySet)
            },
            success: function (data) {
            	var d = $.parseJSON(data);
                if(d.success){
                	batchId = d.obj;
                	setTimeout(function() {
                		batchProgress(d.obj);
                	}, 1000);
                }else{
                	top.tip(d.msg);
                }
            }
		});
	}
	
	var oldProgressValue = 0;
	var contrastsNum = 0;
	// 批量进度设置
	function batchProgress(batchId){
		$.ajax({
            url: "${webRoot}taProcessCheckController/batchProgress",
            type: "post",
            async: false,
            data: { batchId : batchId },
            success: function (data) {
            	var d = $.parseJSON(data);
                if(d.success){
                	var progressValue = parseInt(d.obj.pg);
                	if(oldProgressValue == progressValue){
                		contrastsNum ++;
                	}else{
                		oldProgressValue = progressValue;
                		contrastsNum = 0;
                	}
                	if(contrastsNum == 5){//调用5次进度未变则结束
                		progressValue = 100;
                		oldProgressValue = 100;
                		contrastsNum = 0;
                	}
                	$("#ckProgressbar").progressbar("setValue", progressValue);
                	if(progressValue == 100){
                		batchEndCheck(d.obj);
                	}else{
                		setTimeout(function() {
                    		batchProgress(batchId);
                    	}, 2000);
                	}
                }else{
                	top.tip(d.msg);
                }
            }
		});
	}
	
	var smalLoading = '<img src="/resources/procheck/img/smal_loading.gif" width="16" height="16"/>';
	function setSmalLoad(nodeKey){
		$("#pass_" + nodeKey).find(".check_state").html(smalLoading);
	}
	
	var isStopCheck = false;
	
	// 停止检测
	function stopCheck(){
		isStopCheck = true;
		if(parent.proCkQuerySet.isBatchUser == 1){
			top.tip("批量检测中，已交后台处理，停止无效！");
		}
	}
	
	//流程通过检测请求发起
	function passCkReq(nodeKey, recordId){
		$.ajax({
            url: "${webRoot}taProcessCheckController/passCkReq",
            type: "post",
            async: false,
            data: {nodeCode : nodeKey, recordId : recordId},
            success: function (data) {
            	var d = $.parseJSON(data);
            	var nextNodeKey = d.obj.nextNode;// 下一个检测节点
            	allCkState = d.obj.state;// 检测结果
            	if(nodeKey != nextNodeKey){
            		setProgress();
            	}
            	passCkResultTodo(d.obj);
                if(d.success){
                	// 最后一个检测节点
                	if(doneCkNum == countCkNum || 
                			nextNodeKey == null || 
                			nextNodeKey == "" || isStopCheck) {
                		endCheck();
                		return;
                	}
               		setSmalLoad(nextNodeKey);
                   	setTimeout(function() {
                   		passCkReq(nextNodeKey, recordId); 
                   	}, 100);
                }else{
                	endCheck();
                }
            }
		});
	}
	
	//保存中断记录详情
	function saveStopedNode(nodeKey, allCkState){
    	$.ajax({
            url: "${webRoot}taProcessCheckController/saveStopedNode",
            type: "post",
            async: false,
            data: {
            	nodeCode : nodeKey, 
            	recordId : ckRecordId, 
            	allCkState : allCkState,
            	isStopCheck : isStopCheck
            },
            success: function (data) {
            	var d = $.parseJSON(data);
                if(d.success){
                	$("#pass_" + nodeKey).find(".check_time").html("[" + d.obj.checkTime + "]");
            		$("#pass_" + nodeKey).find(".check_result").html(d.obj.checkResult);
            		var ckStateHtml = $("#pass_" + nodeKey).find(".check_state");
            		ckStateHtml.attr("checkState","3");
            		ckStateHtml.html('<span style="color: blue;">中断</span>');
                }else{
                	top.tip(d.msg);
                }
            }
		});
	}
	
	// 结束检测
	function endCheck(){
		var successNum = 0;
		var failNum = 0;
		var stopNum = 0;
    	// 未检测节点设置
    	var ckState = $("#pass_table").find(".check_state");
    	for(var i = 0; i < ckState.length; i ++){
    		var domHtml = $(ckState[i]);
    		if(domHtml.attr("checkState") == "0"){
    			var domId = domHtml.parent().attr("id");
    			saveStopedNode(domId.substring(5), allCkState);
    			stopNum ++;
    		}else if(domHtml.attr("checkState") == "1"){
    			successNum ++;
    		}else if(domHtml.attr("checkState") == "2"){
    			failNum ++;
    		}
    	}
    	
    	$("#stopCheck").hide();
    	$("#img_load").hide();
    	$("#img_ts").show();
    	$("#saveCheck").show();
    	$("#ck_big_remark").html("已完成检测");
    	
    	ckEndTime = (new Date()).valueOf();
    	var mill = (ckEndTime - ckStartTime)/1000;
    	var resultHtml = '检测结果：<span style="color:green;font-weight: bolder;"> 成功 </span>！';
    	if(failNum > 0){
    		resultHtml = '检测结果：<span style="color:red;font-weight: bolder;"> 失败 </span>！';
    	}
    	var compNum = $("#ckProgressbar").progressbar("getValue");
    	$("#ck_smal_remark").html(
    		'本次检测共耗时<span style="color:green;font-weight: bolder;"> ' + mill + ' </span>秒，' +
    		'完成度<span style="color:green;font-weight: bolder;"> ' + compNum + '% </span>，' +
    		'成功<span style="color:green;font-weight: bolder;"> ' + successNum + ' </span>项，' +
    		'失败<span style="color:red;font-weight: bolder;"> ' + failNum + ' </span>项，' +
    		'中断<span style="color:blue;font-weight: bolder;"> ' + stopNum + ' </span>项，' + resultHtml
    	);
	}
	
	/// 批量检测完成
	function batchEndCheck(result){
		$("#stopCheck").hide();
    	$("#img_load").hide();
    	$("#img_ts").show();
    	$("#saveCheck").show();
    	$("#ck_big_remark").html("批量检测已完成");
    	
    	ckEndTime = (new Date()).valueOf();
    	var mill = (ckEndTime - ckStartTime)/1000;
    	
    	var resultHtml = '检测结果：<span style="color:green;font-weight: bolder;"> 成功 </span>！';
    	if(result.fail > 0){
    		resultHtml = '检测结果：<span style="color:red;font-weight: bolder;"> 失败 </span>！';
    	}
    	var compNum = $("#ckProgressbar").progressbar("getValue");
    	$("#ck_smal_remark").html(
    		'本次检测共耗时<span style="color:green;font-weight: bolder;"> ' + mill + ' </span>秒，' +
    		'完成度<span style="color:green;font-weight: bolder;"> ' + compNum + '% </span>，' +
    		'成功<span style="color:green;font-weight: bolder;"> ' + result.succ + ' </span>项，' +
    		'失败<span style="color:red;font-weight: bolder;"> ' + result.fail + ' </span>项，' +
    		'中断<span style="color:blue;font-weight: bolder;"> ' + result.stop + ' </span>项，' + resultHtml
    	);
	}
	
	//设置进度条
	function setProgress(){
		doneCkNum ++;
		var progressValue = parseInt((doneCkNum*100)/countCkNum);
		$("#ckProgressbar").progressbar("setValue", progressValue);
	}
	
	// 检测该项后执行
	function passCkResultTodo(detail){
		$("#pass_" + detail.nodeKey).find(".check_time").html("[" + detail.checkTime + "]");
		$("#pass_" + detail.nodeKey).find(".check_result").html(detail.checkResult);
		var ckStateHtml = $("#pass_" + detail.nodeKey).find(".check_state");
		if(detail.state == "1"){
			ckStateHtml.attr("checkState", "1");
			ckStateHtml.html('<span style="color: green;">成功</span>');
		}else{
			ckStateHtml.attr("checkState", "2");
			ckStateHtml.html('<span style="color: red;">失败</span>');
		}
	}
	
	// 检测参数设置
	function querySet(){
		var url = '${webRoot}taProcessCheckController/checkQuerySet'
			 + '?title='+processCkRecord.title + '&processId=' + processCkRecord.processId;
		createwindowExt('检测参数设置', url, "", "", {
            lock: true,
            zIndex: 5500,
            width: 1000,
            height: 600,
            button: [{
                name: '确定',
                callback: function () {
                    //回调事件
                    iframe = this.iframe.contentWindow;
            		parent.proCkQueryTable = iframe.$("#proCkQuerySetForm").clone();
            		parent.proCkQuerySet = serializeJson(iframe.$("#proCkQuerySetForm"));
                    parent.close();
                }
            }, {
                name: '取消',
                callback: function () {
                	parent.close();
                }
            }]
        });
	}
	
	function serializeJson(form) {
        var serializeObj = {};
        var formArr = form.serializeArray();
        $(formArr).each(function () {
            serializeObj[this.name] = this.value;
        });
        return serializeObj;
    }
    
	window.onload=function(){ 
		var bodyHeight = $("body").height() - 650;
		$('#ckProgressbar').progressbar('resize', $(".td_ck_detail").width());
		$('.change_height').height(function (index, oldheight) {
            return oldheight + bodyHeight;
        });
	}
</script>
