<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker,autocomplete"></t:base>
<div id="customer_List" class="easyui-layout" fit="true">
    <div region="center" style="padding: 1px;">
        <t:datagrid name="customerList" tagConf="${customerFindVo.clickFunctionId}_TmActCustomerListMain"
                    idField="id" queryMode="group" fit="true" fitColumns="true" checkbox="${customerFindVo.check}"
                    actionUrl="/kernel/mdmCustomerController/getTmActCustomerList?budgetCode=${customerFindVo.budgetCode}&categoriesCode=${customerFindVo.categoriesCode}&clickFunctionId=${customerFindVo.clickFunctionId}"
                    pagination="true" singleSelect="${customerFindVo.singleSelect}">
            <t:dgCol title="主键" field="id" hidden="true"></t:dgCol>
            <t:dgCol title="客户编码" field="customerCode" query="true"></t:dgCol>
            <t:dgCol title="客户名称" field="customerName" query="true"></t:dgCol>
            <t:dgCol title="所属组织" field="orgName" query="true" hidden="false"></t:dgCol>
            <t:dgCol title="客户组织" field="customerOrgName" query="true" hidden="false"></t:dgCol>
            <t:dgCol title="价格组" field="priceGroup" dictionary="price_group" query="true" hidden="false"></t:dgCol>
            <t:dgCol title="客户类型" field="customerType" dictionary="cust_type" query="true" hidden="false"></t:dgCol>
            <t:dgCol title="省" field="province" query="true" hidden="false"></t:dgCol>
            <t:dgCol title="市" field="city" query="true" hidden="false"></t:dgCol>
            <t:dgCol title="区" field="area" query="true" hidden="false"></t:dgCol>
            <t:dgCol title="渠道" field="channelType" dictionary="channel" query="true" hidden="false"></t:dgCol>
            <t:dgCol title="描述" field="customerDesc"></t:dgCol>
        </t:datagrid>
    </div>
</div>
<script>
    $(document).ready(function () {
        $("input[name='orgName']").attr("name", 'orgId');
        $("input[name='orgId']").combotree({
            url: '/kernel/tmApiOrganController/findOrgSelectTree'
        });

        $("input[name='customerOrgName']").attr("name", 'customerOrgId');
        $("input[name='customerOrgId']").combotree({
            url: '/kernel/mdmCustOrgController/findCustOrgTree'
        });
    });
</script>