<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8"%>
<%@ include file="/context/mytags.jsp"%>
<!DOCTYPE html>
<html>
<head>
    <title>费用预提新增</title>
    <t:base type="jquery,easyui,tools"></t:base>
</head>
<body style="overflow-y: hidden" scroll="no">
<t:formvalid action="/pay/ttEstimateExtractController/saveOrUpdate" layout="div"  dialog="true" formid="fiscalForm">
    <t:dgFormList expandParam="${clickFunctionId}" tagConf="${clickFunctionId}">
        <t:dgFormColumn field="id" hidden="true" formClass="form" labelName="id" optionType="input" required="false"
                        defaultVal="${vo.id }"/>
        <t:dgFormColumn field="estimateCode" hidden="true" formClass="form"
                        defaultVal="${vo.estimateCode}"
                        labelName="预提编码" optionType="input" required="false" />
        <t:dgFormColumn field="year" hidden="false" formClass="form" labelName="预提年月" optionType="date" required="true"
                        defaultVal="${vo.year}" style="width:150px" dateFormat="yyyy-MM" />

        <t:dgFormColumn field="actYear" hidden="false" formClass="form" labelName="活动年月" optionType="date" required="true"
                        defaultVal="${vo.actYear}" style="width:150px" dateFormat="yyyy-MM"/>

        <t:dgFormColumn field="actName" hidden="false"  formClass="form"
                        defaultVal="${vo.actName}" labelName="活动名称" optionType="input"  required="true" />
        <t:dgFormColumn field="orgName" hidden="false" formClass="form" labelName="组织" optionType="choseDialog" required="true"
                        onclick="goOrg();"
                        defaultVal="${vo.orgName }"  />
        <t:dgFormColumn field="orgCode" hidden="true"  formClass="form"
                        defaultVal="${vo.orgCode}" labelName="组织编码" optionType="input"  required="true" />
        <t:dgFormColumn field="custName" hidden="false" formClass="form" labelName="客户" optionType="choseDialog" required="true"
                        onclick="goCustomer();"
                        defaultVal="${vo.custName }"  />
        <t:dgFormColumn field="custCode" hidden="true"  formClass="form"
                        defaultVal="${vo.custCode}" labelName="客户编码" optionType="input"  required="true" />
        <t:dgFormColumn field="productName" hidden="true" formClass="form"  labelName="物料" optionType="choseDialog" required="false"
                        defaultVal="${vo.productName }"  onclick="selectProduct();"/>
        <t:dgFormColumn field="productCode" hidden="true"  formClass="form"
                        defaultVal="${vo.productCode}" labelName="物料编码" optionType="input"  required="true" />

        <t:dgFormColumn field="productLevelName" hidden="false" formClass="form"  labelName="产品层级" optionType="choseDialog" required="false"
                        defaultVal="${vo.productLevelName }"  onclick="selectProductLevel();"
                        onClean="cleanProductLevel();"/>
        <t:dgFormColumn field="productLevelCode" hidden="true"  formClass="form"
                        defaultVal="${vo.productLevelCode}" labelName="产品层级编码" optionType="input"  required="false" />
        <t:dgFormColumn field="costRate" hidden="true"  formClass="form"
                         labelName="产品层级成本率" optionType="input"  required="false" />

        <t:dgFormColumn field="fineName" hidden="false" formClass="form" labelName="活动细类" optionType="choseDialog" required="true"
                        onclick="selectActSubClass()" defaultVal="${vo.fineName}" dataType="*"/>
        <t:dgFormColumn field="fineCode" hidden="true" formClass="form" labelName="活动细类" optionType="input" required="true"
                        defaultVal="${vo.fineCode}" dataType="*"/>
        <t:dgFormColumn field="categoriesName" hidden="false" formClass="form" labelName="活动大类" optionType="input" required="true"
                        defaultVal="${vo.categoriesName}" dataType="*" readOnly="true"/>
        <t:dgFormColumn field="categoriesCode" hidden="true" formClass="form" labelName="活动大类" optionType="input" required="true"
                        defaultVal="${vo.categoriesCode}" dataType="*" />
        <t:dgFormColumn field="budgetSubjectsName" hidden="false" formClass="form" labelName="预算科目" optionType="input" required="true"
                        defaultVal="${vo.budgetSubjectsName}" dataType="*" readOnly="true"/>
        <t:dgFormColumn field="budgetSubjectsCode" hidden="true" formClass="form" labelName="预算科目" optionType="input" required="true"
                        defaultVal="${vo.budgetSubjectsCode}" dataType="*" />
        <t:dgFormColumn field="payType" hidden="false" formClass="form" labelName="支付方式" optionType="select" required="true"
                        defaultVal="${vo.payType}" typeGroupCode="pay_type"/>
        <t:dgFormColumn field="beginTime" hidden="false" formClass="form" labelName="活动开始时间" optionType="date" required="true"
                        defaultVal="${vo.beginTime}" style="width:150px" maxDate="endTime"/>
        <t:dgFormColumn field="endTime" hidden="false" formClass="form" labelName="活动结束时间" optionType="date" required="true"
                        defaultVal="${vo.endTime}" style="width:150px" minDate="beginTime"/>
        <t:dgFormColumn field="actAmount" hidden="false" formClass="form" labelName="活动申请金额" optionType="input" required="true"
                        defaultVal="${vo.actAmount}" />
        <t:dgFormColumn field="estimateAmount" hidden="false" formClass="form" labelName="预提金额" optionType="input" required="true"
                        defaultVal="${vo.estimateAmount}" readOnly="true"/>

    </t:dgFormList>
</t:formvalid>
</body>
<script type="text/javascript">

    $(function () {
        $("#productLevelName").parent().parent().parent().hide();

        $("#payType").change(function () {
            paytypeChage();
            calEstimateAmount();
        })

        $("#actAmount").blur(function () {
            calEstimateAmount();
        })

        $("#productLevelName").blur(function () {
            calEstimateAmount();
        })
    })

    //计算预提金额
    function calEstimateAmount() {
        var value = $("#payType").val();
        if(value != "30"){
            $("#estimateAmount").val($("#actAmount").val());
        }else {
            //计算
            var costRate = $("#costRate").val();
            var actAmount = $("#actAmount").val();
            var reg = /^\s*$/
            //返回值为true表示不是空字符串
            if ((costRate != null && costRate != undefined && !reg.test(costRate))
            &&
                (actAmount != null && actAmount != undefined && !reg.test(actAmount))
            ){
                $("#estimateAmount").val(Number(costRate * actAmount).toFixed(2));
            }
        }
    }



    //支付方式改变的时候联动产品层级展示跟不展示
    function paytypeChage() {
        var value = $("#payType").val();
        if(value == "30"){
            $("#productLevelName").parent().parent().parent().show();
        }else {
            $("#productLevelName").parent().parent().parent().hide();
        }
    }

    /**
     * 清除产品层级
     */
    function cleanProductLevel() {
        $("#productLevelCode").val("");
        $("#productLevelName").val("");
    }

    //选择产品层级
    function selectProductLevel(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        triggerId = "productLevelCode";
        triggerName = "productLevelName";
        // valueField = "standPrice";
        url = "/page/tmApiProductLevelController/goProductListMain";
        width = 1000;
        height = 450;
        id = "productLevelList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            left: '85%',
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                $("#productLevelName").focus();
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj = eval(rowsData);
                    $("#" + triggerId).val(myobj[0].text);
                    $("#" + triggerName).val(myobj[0].src);
                    $("#costRate").val(myobj[0].costRate);
                    $("#productCode").val("");
                    $("#productName").val("");
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }


    function goOrg(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        triggerId = "orgCode";
        triggerName = "orgName";
        url = "/page/tmApiOrgController/goOrgListMain";
        width = 1000;
        height = 450;
        id = "orgList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            left: '85%',
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                $("#orgName").focus();
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj=eval(rowsData);
                    $("#" + triggerId).val(myobj[0].text);
                    $("#" + triggerName).val(myobj[0].src);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    function goCustomer(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId){
        triggerId = "custCode";
        triggerName = "custName";
        url = "/page/tmApiCustomerController/goCustomerListMain";
        width = 1000;
        height = 450;
        id = "customerList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            left: '85%',
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                $("#customerName").focus();
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj=eval(rowsData);
                    $("#" + triggerId).val(myobj[0].customerCode);
                    $("#" + triggerName).val(myobj[0].customerName);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }
    function selectProduct(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId){
        triggerId = "productCode";
        triggerName = "productName";
        url = "/page/tmApiProductInfoController/goProductInfoListMain";
        width = 1000;
        height = 450;
        id = "productinfoList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            left: '85%',
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                $("#productName").focus();
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj=eval(rowsData);
                    $("#" + triggerId).val(myobj[0].productInfoCode);
                    $("#" + triggerName).val(myobj[0].productInfoName);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    function selectActSubClass(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId){
        triggerId = "fineCode";
        triggerName = "fineName";
        url = "/page/ttApiFineController/goApiPriceFineMain";
        width = 1000;
        height = 450;
        id = "actSubclassList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj=eval(rowsData);
                    $("#" + triggerId).val(myobj[0].fineCode);
                    $("#" + triggerName).val(myobj[0].fineName);
                    $("#categoriesCode").val(myobj[0].categoriesCode);
                    $("#categoriesName").val(myobj[0].categoriesName);
                    $("#budgetSubjectsCode").val(myobj[0].budgetSubjectsCode);
                    $("#budgetSubjectsName").val(myobj[0].budgetSubjectsName);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }
</script>

</html>
