<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<t:base type="jquery"></t:base>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>
    <link rel="stylesheet" href="/resources/sfa/css/normalize.css">
    <link rel="stylesheet" href="/resources/sfa/css/flex.css">
    <link rel="stylesheet" href="/resources/sfa/css/spacing.css">
    <style>
        body{
            width: 100%;
            height: 100%;
            padding: 0;
            margin: 0;
        }
        [v-cloak]{
            display: none;
        }
        .container {
            width: 100%;
            height: 100%;
            padding: 10px;
            box-sizing: border-box;
            overflow-y: auto;
        }

        .use-info {
            border: 1px solid #f6f6f6;
            text-align: center;
            border-radius: 5px;
        }
        .table td{
            text-align:left;
            width: 50%;
        }
        .table{
            width: 50%;
            table-layout: fixed;
            margin-bottom: 20px;
        }
        .table thead{
            display: none;
        }
        .table caption{
            font-size: 16px;
            font-weight: bold;
        }
    </style>
</head>

<body>
<div id="app" v-cloak>
    <div class="container">
        <div class="flex">
            <div class="flex-1 use-info mr10">
                <p>Used Memory</p>
                <h1>{{exception.memory.used_memory_human}}</h1>
            </div>
            <div class="flex-1 use-info mr10">
                <p>Total Keys</p>
                <h1>{{exception.keyspace.totalKeys}}</h1>
            </div>
            <div class="flex-1 use-info mr10">
                <p>Clients</p>
                <h1>{{exception.clients.connected_clients}}</h1>
            </div>
            <div class="flex-1 use-info mr10">
                <p>Used CPU Sys</p>
                <h1>{{exception.cpu.used_cpu_sys}}</h1>
            </div>
        </div>
        <div ref="exceptionMemory" style="width: 100%;height: 500px;"></div>
        <div ref="exceptionCpu" style="width: 100%;height: 500px;"></div>
        <div class="flex flex-wrap">
            <table class="table" >
                <caption>Memory</caption>
                <thead>
                <tr>
                    <th width="200px">键名</th>
                    <th width="200px">值</th>
                </tr>
                </thead>
                <tbody>
                <tr v-for="(item,index) in getKeys(exception.memory)">
                    <td>{{item}}</td>
                    <td>{{exception.memory[item]}}</td>
                </tr>
                </tbody>
            </table>
            <table class="table">
                <caption>clients</caption>
                <thead>
                <tr>
                    <th width="200px">键名</th>
                    <th width="200px">值</th>
                </tr>
                </thead>
                <tbody>
                <tr v-for="(item,index) in getKeys(exception.clients)">
                    <td>{{item}}</td>
                    <td>{{exception.clients[item]}}</td>
                </tr>
                </tbody>
            </table>
            </table>
            <table class="table">
                <caption>cluster</caption>
                <thead>
                <tr>
                    <th width="200px">键名</th>
                    <th width="200px">值</th>
                </tr>
                </thead>
                <tbody>
                <tr v-for="(item,index) in getKeys(exception.cluster)">
                    <td>{{item}}</td>
                    <td>{{exception.cluster[item]}}</td>
                </tr>
                </tbody>
            </table>
            <table class="table">
                <caption>keyspace</caption>
                <thead>
                <tr>
                    <th width="200px">键名</th>
                    <th width="200px">值</th>
                </tr>
                </thead>
                <tbody>
                <tr v-for="(item,index) in getKeys(exception.keyspace.dbs)">
                    <td>{{item}}</td>
                    <td>{{exception.keyspace.dbs[item]}}</td>
                </tr>
                </tbody>
            </table>
            <table class="table">
                <caption>persistence</caption>
                <thead>
                <tr>
                    <th width="200px">键名</th>
                    <th width="200px">值</th>
                </tr>
                </thead>
                <tbody>
                <tr v-for="(item,index) in getKeys(exception.persistence)">
                    <td>{{item}}</td>
                    <td>{{exception.persistence[item]}}</td>
                </tr>
                </tbody>
            </table>
            <table class="table">
                <caption>replication</caption>
                <thead>
                <tr>
                    <th width="200px">键名</th>
                    <th width="200px">值</th>
                </tr>
                </thead>
                <tbody>
                <tr v-for="(item,index) in getKeys(exception.replication)">
                    <td>{{item}}</td>
                    <td>{{exception.replication[item]}}</td>
                </tr>
                </tbody>
            </table>
            <table class="table">
                <caption>server</caption>
                <thead>
                <tr>
                    <th width="200px">键名</th>
                    <th width="200px">值</th>
                </tr>
                </thead>
                <tbody>
                <tr v-for="(item,index) in getKeys(exception.server)">
                    <td>{{item}}</td>
                    <td>{{exception.server[item]}}</td>
                </tr>
                </tbody>
            </table>
            <table class="table">
                <caption>stats</caption>
                <thead>
                <tr>
                    <th width="200px">键名</th>
                    <th width="200px">值</th>
                </tr>
                </thead>
                <tbody>
                <tr v-for="(item,index) in getKeys(exception.stats)">
                    <td>{{item}}</td>
                    <td>{{exception.stats[item]}}</td>
                </tr>
                </tbody>
            </table>
        </div>

    </div>
</div>
<script src="/resources/tools/vue.min.js"></script>
<script src="/resources/echarts/echarts.min.js"></script>
<script>
    let vm = new Vue({
        el: "#app",
        data: function () {
            return {
                exception: {
                    memory:{},
                    cpu:{},
                    keyspace:{dbs:{}},
                    clients:{},
                    cluster:{},
                    persistence:{},
                    replication:{},
                    server:{},
                    stats:{}

                },
                exceptionMemory: null,
                exceptionCpu: null
            }
        },
        mounted: function () {
            this.loadData(false);
        },
        methods: {
            loadData: function (isRoll) {
                let this_ = this;
                $.ajax({
                    url: "/kernel/redisInfoController/findCurrentRedisInfo",
                    dataType: "json",
                    type: "post",
                    success: function (res) {
                        if (res.success) {
                            this_.exception = res.obj;
                            if (isRoll) {
                                this_.dynamicMemory();
                                this_.dynamicCpu();
                            } else {
                                this_.initExceptionMemory();
                                this_.initExceptionCpu();
                            }
                            setTimeout(function () {
                                this_.loadData(true)
                            }, 2000);
                        }
                    }
                })
            },
            initExceptionMemory: function (data) {
                let this_ = this;
                this.exceptionMemory = echarts.init(this.$refs.exceptionMemory);
                let option = {
                    title: {
                        x: 'center',
                        top: 0,
                        text: 'Used Memory(Byte)',
                    },
                    tooltip: {
                        trigger: 'axis'
                    },
                    grid: {
                        top: 100,
                    },
                    legend: {
                        top: 50,
                        data: ['Used Memory']
                    },
                    xAxis: [{
                        type: 'category',
                        boundaryGap: true,
                        data: [this_.exception.timeStr]
                    }],
                    yAxis: [{
                        type: 'value',
                        scale: true,
                        name: 'Used Memory',
                        boundaryGap: [0.2, 0.2]
                    }],
                    series: [{
                        name: 'Used Memory',
                        type: 'line',
                        smooth: true,
                        areaStyle: {},
                        data: [this_.exception.memory.used_memory]
                    }]
                };
                this.exceptionMemory.setOption(option);
            },
            initExceptionCpu: function (data) {
                let this_ = this;
                this.exceptionCpu = echarts.init(this.$refs.exceptionCpu);
                let option = {
                    title: {
                        x: 'center',
                        top: 0,
                        text: 'Used CPU Sys',
                    },
                    tooltip: {
                        trigger: 'axis'
                    },
                    grid: {
                        top: 100,
                    },
                    legend: {
                        top: 50,
                        data: ['Used CPU Sys']
                    },
                    xAxis: [{
                        type: 'category',
                        boundaryGap: true,
                        data: [this_.exception.timeStr]
                    }],
                    yAxis: [{
                        type: 'value',
                        scale: true,
                        name: 'Used CPU Sys',
                        boundaryGap: [0.2, 0.2]
                    }],
                    series: [{
                        name: 'Used CPU Sys',
                        type: 'line',
                        smooth: true,
                        areaStyle: {},
                        data: [this_.exception.cpu.used_cpu_sys]
                    }]
                };
                this.exceptionCpu.setOption(option);
            },
            dynamicMemory: function () {
                let this_ = this;
                let option = this_.exceptionMemory.getOption();
                let yData = option.series[0].data;
                if (yData.length > 10) {
                    yData.shift();
                }
                yData.push(this_.exception.memory.used_memory);
                let xData = option.xAxis[0].data;
                if (xData.length > 10) {
                    xData.shift();
                }
                xData.push(this_.exception.timeStr);
                this_.exceptionMemory.setOption(option);
            },
            dynamicCpu: function () {
                let this_ = this;
                let option = this_.exceptionCpu.getOption();
                let yData = option.series[0].data;
                if (yData.length > 10) {
                    yData.shift();
                }
                yData.push(this_.exception.cpu.used_cpu_sys);
                let xData = option.xAxis[0].data;
                if (xData.length > 10) {
                    xData.shift();
                }
                xData.push(this_.exception.timeStr);
                this_.exceptionCpu.setOption(option);
            },
            getKeys:function(obj){
                let result = [];
                if(Array.prototype.toString.call(obj)==="[object Object]"){
                       for(let key in obj){
                           result.push(key);
                       }
                }
                return result;
            }
        },
    })
</script>
</body>

</html>