<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>月度销售数据</title>
    <link rel="stylesheet" href="/resources/sfa/css/normalize.css">
    <link rel="stylesheet" href="/resources/sfa/css/flex.css">
    <link rel="stylesheet" href="/resources/sfa/css/spacing.css">
    <style>
        [v-cloak]{
            display: none;
        }
        .container {
            box-sizing: border-box;
            overflow-y: auto;
        }

        .chart-title {
            text-align: center;
        }

        .sale-chart {
            height: 300px;
        }

        .chart-table table {
            width: 100%;
            border-collapse: collapse;
        }

        .chart-table table td,
        .chart-table table th {
            height: 30px;
            border: 1px solid #eeeeee;
            box-sizing: border-box;
            position: relative;
            text-align: center;
        }

        .chart-table table th {
            background: #f6f6f6;
        }

        .finish-progress {
            width: 100%;
            height: 16px;
            background: #ddd;
        }

        .progress-bar {
            height: 6px;
            width: 0;
            background: #1890ff;
            border-radius: 6px;
            transition: width .5s ease-in;
        }

        .text-normal {
            color: green;
        }

        .text-danger {
            color: red;
        }
    </style>
</head>

<body>
<div id="app" v-cloak>
    <div class="container p10">
        <h1 class="chart-title">月度销售数据分析</h1>
        <div class="month-sale">
            <div class="sale-chart">
                <div ref="saleChart" style="width: 100%;height: 100%;"></div>
            </div>
            <div class="chart-table mb20">
                <table>
                    <thead>
                    <tr>
                        <th>日历月</th>
                        <th>实际-销售额</th>
                        <th>实际-销量-吨</th>
                        <th>实际-成本</th>
                        <th>实际-费用</th>
                        <th>去年-销售额</th>
                        <th>环比增长</th>
                        <th>计划达成度</th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr v-for="(item,index) in tableData" :key="index">
                        <td>{{item.month}}月</td>
                        <td>{{item.realSaleMoney}}<i class="fa fa-long-arrow-up ml5 text-normal"></i></td>
                        <td>{{item.realSaleNum}}</td>
                        <td>{{item.realCost}}</td>
                        <td>{{item.realFee}}</td>
                        <td>{{item.lastSaleMoney}}</td>
                        <td>{{item.increase}}%<i class="fa fa-circle ml5 text-danger"></i></td>
                        <td>
                            <div class="finish-progress flex flex-align-items-center">
                                <div class="progress-bar" :style="{width:item.finish+'%'}"></div>
                            </div>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<script src="/resources/sfa/js/vue.min.js"></script>
<script src="/resources/sfa/js/echarts.min.js"></script>
<script>
    let vm = new Vue({
        el: "#app",
        data: function () {
            return {
                saleChart: null,
                tableData: [{
                    month: 1,
                    realSaleMoney: 19892632,
                    realSaleNum: 3978526.4,
                    realCost: 9946316,
                    realFee: 5967789.6,
                    lastSaleMoney: 18380791.97,
                    increase: 7.60,
                    finish: 95
                }, {
                    month: 2,
                    realSaleMoney: 11867632,
                    realSaleNum: 2373526.4,
                    realCost: 5933816,
                    realFee: 3560289.6,
                    lastSaleMoney: 11499735.41,
                    increase: 3.10,
                    finish: 75
                }, {
                    month: 3,
                    realSaleMoney: 16892234,
                    realSaleNum: 3378446.8,
                    realCost: 8446117,
                    realFee: 5067670.2,
                    lastSaleMoney: 16419251.45,
                    increase: 2.80,
                    finish: 87
                }, {
                    month: 4,
                    realSaleMoney: 9856432,
                    realSaleNum: 1971286.4,
                    realCost: 4928216,
                    realFee: 2956929.6,
                    lastSaleMoney: 9324184.672,
                    increase: 5.40,
                    finish: 95
                }, {
                    month: 5,
                    realSaleMoney: 8867841,
                    realSaleNum: 1773568.2,
                    realCost: 4433920,
                    realFee: 2660352.3,
                    lastSaleMoney: 8965387.25,
                    increase: -1.10,
                    finish: 91
                }, {
                    month: 6,
                    realSaleMoney: 8696723,
                    realSaleNum: 1739344.6,
                    realCost: 4348361.5,
                    realFee: 2609016.9,
                    lastSaleMoney: 8331460.634,
                    increase: 	4.20,
                    finish: 75
                }, {
                    month: 7,
                    realSaleMoney: 19892632,
                    realSaleNum: 3978526.4,
                    realCost: 9946316,
                    realFee: 5967789.6,
                    lastSaleMoney: 18380791.41,
                    increase: 7.60,
                    finish: 95
                }, {
                    month: 8,
                    realSaleMoney: 11867632,
                    realSaleNum: 2373526.4,
                    realCost: 5933816,
                    realFee: 3560289.6,
                    lastSaleMoney: 11499735.41,
                    increase: 3.10,
                    finish: 93
                }, {
                    month: 9,
                    realSaleMoney: 16892234,
                    realSaleNum: 3378446.8,
                    realCost: 8446117,
                    realFee: 5067670.2,
                    lastSaleMoney: 16419251.45,
                    increase: 2.80,
                    finish: 87
                }, {
                    month: 10,
                    realSaleMoney: 9856432,
                    realSaleNum: 1971286.4,
                    realCost: 4928216,
                    realFee: 2956929.6,
                    lastSaleMoney: 9324184.41,
                    increase: 5.40,
                    finish: 95
                }, {
                    month: 11,
                    realSaleMoney: 8867841,
                    realSaleNum: 1773568.2,
                    realCost: 4433920,
                    realFee: 2660352.3,
                    lastSaleMoney: 8965387.251,
                    increase: -1.10,
                    finish: 91
                }, {
                    month: 12,
                    realSaleMoney: 8696723,
                    realSaleNum: 1739344.6,
                    realCost: 4348361,
                    realFee: 2609016.9,
                    lastSaleMoney: 8331460.63,
                    increase: 4.20,
                    finish: 75
                }]
            }
        },
        mounted: function () {
            this.initSaleChart();
        },
        methods: {
            initSaleChart: function () {
                this.saleChart = echarts.init(this.$refs.saleChart);
                let option = {
                    tooltip: {
                        trigger: "axis",
                        formatter: '{b}月<br>{c}元'
                    },
                    xAxis: {
                        name: "月",
                        type: 'category',
                        data: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12']
                    },
                    yAxis: {
                        name: "元",
                        type: 'value'
                    },
                    series: [{
                        data: [19892632,
                            11867632,
                            16892234,
                            9856432,
                            8867841,
                            8696723,
                            19892632,
                            11867632,
                            16892234,
                            9856432,
                            8867841,
                            8696723
                        ],
                        type: 'line',
                        smooth: true
                    }]
                }
                this.saleChart.setOption(option);
            }
        },
    })
</script>
</body>

</html>