<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>新增客户统计</title>
    <link rel="stylesheet" href="/resources/sfa/css/normalize.css">
    <link rel="stylesheet" href="/resources/sfa/css/flex.css">
    <link rel="stylesheet" href="/resources/sfa/css/spacing.css">
    <link rel="stylesheet" href="/resources/sfa/css/common.css">
    <style>
        body {
            padding: 0;
            margin: 0;
            background: #ffffff;
        }

        .add-data select {
            border: none;
            background: transparent;
            outline: none;
        }

        .panel-title {
            font-weight: 600;
        }

        .pie-legend {
            padding: 5px 10px;
        }

        .rect {
            width: 10px;
            height: 10px;
        }

        .rect-1 {

            background: #cd0074;
        }

        .rect-2 {

            background: #e60042;
        }

        .rect-3 {

            background: #ffb140;
        }

        .rect-4 {

            background: #3f92d2;
        }

        .rect-5 {

            background: #66a3d2;
        }

        .rank-item {
            padding: 10px;
            margin-bottom: 5px;
            border: 1px solid #d8d8d8;
        }
    </style>
</head>

<body>
    <div id="app" v-cloak>
        <div class="add-new">
            <div class="p10 add-data flex flex-align-items-center flex-justify-content-between">
                <select v-model="range">
                    <option value="month">最近30天</option>
                </select>
            </div>
            <div class="pv10">
                <div ref="addPie" style="width: 100%;height:250px;box-sizing: border-box;"></div>
                <div class="pie-legend flex flex-align-items-center">
                    <span class="flex-none rect rect-1 mr10"></span>
                    <span class="flex-auto">便利商店<span class="ml10">300</span></span>
                    <span class="flex-none ml10">30%</span>
                </div>
                <div class="pie-legend flex flex-align-items-center">
                    <span class="flex-none rect rect-2 mr10"></span>
                    <span class="flex-auto">小型超市<span class="ml10">100</span></span>
                    <span class="flex-none ml10">10%</span>
                </div>
                <div class="pie-legend flex flex-align-items-center">
                    <span class="flex-none rect rect-3 mr10"></span>
                    <span class="flex-auto">全国连锁大卖场<span class="ml10">100</span></span>
                    <span class="flex-none ml10">10%</span>
                </div>
                <div class="pie-legend flex flex-align-items-center">
                    <span class="flex-none rect rect-4 mr10"></span>
                    <span class="flex-auto">当地连锁大卖场<span class="ml10">300</span></span>
                    <span class="flex-none ml10">30%</span>
                </div>
                <div class="pie-legend flex flex-align-items-center">
                    <span class="flex-none rect rect-5 mr10"></span>
                    <span class="flex-auto">经销商及其它<span class="ml10">200</span></span>
                    <span class="flex-none ml10">20%</span>
                </div>
            </div>
            <div class="panel-title pl10 pb10">
                新增排行榜
            </div>
            <div class="rank-list">
                <div class="rank-item flex flex-align-items-center">
                    <span class="flex-none mr10 panel-title">张三</span>
                    <span class="flex-auto">西北大区销售部</span>
                    <span class="flex-none">+100</span>
                </div>
                <div class="rank-item flex flex-align-items-center">
                    <span class="flex-none mr10 panel-title">李四</span>
                    <span class="flex-auto">华北大区销售部</span>
                    <span class="flex-none">+500</span>
                </div>
            </div>
        </div>
    </div>

    <script src="/resources/sfa/js/vue.min.js"></script>
    <script src="/resources/sfa/js/jquery.min.js"></script>
    <script src="/resources/sfa/js/common.js"></script>
    <script src="/resources/sfa/js/echarts.min.js"></script>

    <script>
        var vm = new Vue({
            el: "#app",
            name: "",
            data: function () {
                return {
                    range: "month",
                    addPie: null
                }
            },
            created: function () {

            },
            mounted: function () {
                this.initVisitPipe();
            },
            methods: {
                initVisitPipe: function () {
                    this.addPie = echarts.init(this.$refs.addPie);
                    var option = {
                        color: ["#cd0074", "#e60042", "#ffb140", "#3f92d2", "#66a3d2"],
                        graphic: {
                            elements: [{
                                type: "text",
                                left: "center",
                                top: "center",
                                style: {
                                    text: "新增客户20%",
                                    textAlign: "center",
                                    fill: "#333",
                                    font: 'bolder 0.8em "Microsoft YaHei", sans-serif'
                                }
                            }]
                        },
                        series: [{
                            name: '',
                            type: 'pie',
                            radius: ['50%', '60%'],
                            label: {
                                normal: {
                                    show: false,
                                    position: 'center'
                                }
                            },
                            data: [{
                                    value: 300,
                                    name: '便利商店',
                                },
                                {
                                    value: 100,
                                    name: '小型超市'
                                },
                                {
                                    value: 100,
                                    name: '全国连锁大卖场'
                                },
                                {
                                    value: 300,
                                    name: '当地连锁大卖场'
                                },
                                {
                                    value: 200,
                                    name: '经销商及其它'
                                }
                            ]
                        }]
                    };

                    this.addPie.setOption(option);
                },
            }
        })
    </script>
</body>

</html>