<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>考勤统计</title>
    <link rel="stylesheet" href="/resources/sfa/css/normalize.css">
    <link rel="stylesheet" href="/resources/sfa/css/flex.css">
    <link rel="stylesheet" href="/resources/sfa/css/spacing.css">
    <link rel="stylesheet" href="/resources/sfa/css/common.css">
    <link rel="stylesheet" href="/resources/sfa/css/LCalendar.css">
    <style>
        body {
            padding: 0;
            margin: 0;
            background: #f3f3f3;
        }

        .attendance-date {
            text-align: center;
            padding: 10px;
        }

        .attendance-date input {
            border: none;
            background: transparent;
            width: 90px;
        }

        .attendance-item {
            background: #ffffff;
            height: 35px;
            line-height: 35px;
            padding: 0 10px;
            margin-bottom: 5px;
        }
    </style>
</head>

<body>
    <div id="app" v-cloak>
        <div class="attendance">
            <div class="attendance-date">
                <span>&lt</span>
                <input type="text" id="goalDate" v-model="attendanceDate" readonly="" name="input_date" />
                <span>&gt</span>
            </div>
            <div class="attendance-item">
                <span>请假1人</span>
            </div>
            <div class="attendance-item">
                <span>出差5人</span>
            </div>
            <div ref="attendancePie" style="width: 100%;height:400px;box-sizing: border-box;"></div>
        </div>
    </div>

    <script src="/resources/sfa/js/vue.min.js"></script>
    <script src="/resources/sfa/js/jquery.min.js"></script>
    <script src="/resources/sfa/js/common.js"></script>
    <script src="/resources/sfa/js/echarts.min.js"></script>
    <script src="/resources/sfa/js/LCalendar.js"></script>

    <script>
        var vm = new Vue({
            el: "#app",
            name: "",
            data: function () {
                return {
                    attendanceDate: "",
                    attendancePie: null
                }
            },
            created: function () {

            },
            mounted: function () {
                var calendar = new LCalendar();
                calendar.init({
                    'trigger': '#goalDate', //标签id
                    'type': 'date', //date 调出日期选择 datetime 调出日期时间选择 time 调出时间选择 ym 调出年月选择
                });
                this.initAttendance();
            },
            methods: {
                initAttendance: function () {
                    this.attendancePie = echarts.init(this.$refs.attendancePie);
                    var option = {
                        color: ["#1890ff", "#009999", "#ff7100", "#ffc900"],
                        legend: {
                            data: ['签到', '未签到', '请假', '出差'],
                            bottom: 0
                        },
                        tooltip: {
                            trigger: 'item',
                            formatter: "{b} : {c}"
                        },
                        series: [{
                            name: '',
                            type: 'pie',
                            radius: ['50%', '60%'],
                            label: {
                                normal: {
                                    show: false,
                                    position: 'center'
                                }
                            },
                            data: [{
                                    value: 105,
                                    name: '签到',
                                },
                                {
                                    value: 2,
                                    name: '未签到'
                                },
                                {
                                    value: 1,
                                    name: '请假'
                                },
                                {
                                    value: 5,
                                    name: '出差'
                                }
                            ],
                            itemStyle: {
                                emphasis: {
                                    shadowBlur: 10,
                                    shadowOffsetX: 0,
                                    shadowColor: 'rgba(0, 0, 0, 0.5)'
                                }
                            }
                        }]
                    };

                    this.attendancePie.setOption(option);
                }
            }
        })
    </script>
</body>

</html>