<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>订单详情</title>
    <link rel="stylesheet" href="/resources/sfa/css/normalize.css">
    <link rel="stylesheet" href="/resources/sfa/css/flex.css">
    <link rel="stylesheet" href="/resources/sfa/css/spacing.css">
    <link rel="stylesheet" href="/resources/sfa/css/common.css">
    <style>
        body {
            background: #f3f3f3;
        }

        .goods-list {
            background: #ffffff;
            padding: 16px;
        }

        .goods-item {
            padding: 10px;
            background: #f6f6f6;
            color: #333333;
            border-radius: 5px;
        }

        .order-note {
            border-top: 1px solid #ebedf0;
            font-size: 14px;
        }

        .order-note .list-cell-title {
            color: #333333;
        }
    </style>
</head>

<body>
    <div id="app" v-cloak>
        <div class="order-detail">
            <list-cell title="客户" :value="order.terminalName"></list-cell>
            <list-cell title="商品总数" :value="order.orderNum||0"></list-cell>
            <list-cell title="商品清单"></list-cell>
            <div class="goods-list">
                <div class="goods-item mb10" v-for="p in order.itemVos" :key="p.id">
                    <div class="goods-title mb10">产品名称：{{p.productName}}</div>
                    <div class="flex flex-align-items-center flex-justify-content-between">
                        <div>产品编码：{{p.productCode}}</div>
                        <div>数量：{{p.num}}</div>
                    </div>
                </div>
            </div>
            <div class="order-note">
                <list-info title="订单备注" :value="order.remarks" type="textarea"></list-info>
            </div>
        </div>
    </div>

    <script src="/resources/sfa/js/vue.min.js"></script>
    <script src="/resources/sfa/js/common.js"></script>
    <script src="/resources/sfa/js/jquery.min.js"></script>

    <script>
        var vm = new Vue({
            el: "#app",
            name: "",
            data: function () {
                return {
                    token: "",
                    orderSn: "",
                    order: {}
                }
            },
            created: function () {
                this.token = getParameterByName("token");
                this.orderSn = getParameterByName("orderSn");
                this.loadData();
            },
            computed: {

            },
            methods: {
                loadData: function () {
                    var this_ = this;
                    $.ajax({
                        url: SERVER +
                            "/sfaapi/sfaApi/orderApiController/findOrderDetail",
                        type: "post",
                        dataType: "json",
                        contentType: 'application/json',
                        data: JSON.stringify({
                            orderSn: this_.orderSn
                        }),
                        headers: {
                            'loginUserToken': this_.token
                        },
                        success: function (res) {
                            if (res.success) {
                                this_.order = res.obj;
                            }else{
                                showError(res.msg)
                            }
                        }
                    })
                },
            }
        })
    </script>
</body>

</html>