<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8" %>
<%@include file="/context/mytags.jsp" %>

<script type="text/javascript">

    var task = workflow.getFigure(nodeid);//当前节点对象

    //属性表格定义
    rows = [
        {"name": "ID", "group": "任务属性", "value": task.taskId, "field": "taskId", "editor": "text"},
        {"name": "名称", "group": "任务属性", "value": task.taskName, "field": "taskName", "editor": "text"},
        {"name": "描述", "group": "任务属性", "value": task.documentation, "field": "documentation", "editor": "text"},
        {"name": "表单Key", "group": "表单属性", "value": task.formKey, "field": "formKey", "editor": "text"}
    ];

    $(function () {
        $('#task_extend').val(task.task_extend);
        $('#isSequential').val(task.isSequential);
        $('#loopCardinality').val(task.loopCardinality);
        $('#collection').val(task.collection);
        $('#elementVariable').val(task.elementVariable);
        $('#completionCondition').val(task.completionCondition);

        task_candidate_panel = $('#task-candidate-panel').panel({
            border: false
        });

        //创建属性表格
        $('#task-propertygrid').propertygrid({
            width: 'auto',
            height: 'auto',
            showGroup: true,
            scrollbarSize: 0,
            border: 0,
            columns: [[
                {field: 'name', title: '属性名', width: 30, resizable: false},
                {field: 'value', title: '属性值', width: 100, resizable: false}
            ]],
            onAfterEdit: function () {
                <c:if test="${optype!=2}">
                saveTaskProperties();//自动保存
                </c:if>
            }
        });
        propertygrid();
        $('#performerType').change(function () {
            $('#expression').val('');
            switchTaskCandidatesList($(this).val());
        });
        $('#performerType').val(task.performerType);
        console.log(task)
        $('#expression').val(task.expression);
        setTimeout(function(){
            switchTaskCandidatesList(task.performerType)
        },50)
    });

    function switchTaskCandidatesList(performerType) {
        if (performerType == 'candidateUsers') {
            task_candidate_panel.panel("refresh", "/page/taProcessNodeController/goProcessNodePropertiesForm?turn=candidatePositionsConfig&checkbox=false&optype=${optype}");
        } else if (performerType == 'candidateGroups') {
            task_candidate_panel.panel("refresh", "/page/taProcessNodeController/goProcessNodePropertiesForm?turn=candidateRolesConfig&checkbox=true&optype=${optype}");
        } else if (performerType == 'assignee') {
            task_candidate_panel.panel("refresh", "/page/taProcessNodeController/goProcessNodePropertiesForm?turn=candidatePositionsConfig&checkbox=true&optype=${optype}");
        }
    }

    //保存
    function saveTaskProperties() {
        task.taskId = $.trim(rows[0].value);
        task.taskName = rows[1].value;
        task.formKey = rows[3].value;
        task.documentation = rows[2].value;
        task.setId($.trim(rows[0].value));
        task.setContent($.trim(rows[1].value));
        task.performerType = $('#performerType').val();
        task.expression = $.trim($('#expression').val());
        task.isUseExpression = true;
        if ($('#isSequential').val() != "") {
            task.task_extend = "sign";
        }
        //task.task_extend = $.trim($('#task_extend').val());
        task.loopCardinality = $.trim($('#loopCardinality').val());
        task.isSequential = $.trim($('#isSequential').val());
        task.loopCardinality = $.trim($('#loopCardinality').val());
        task.collection = $.trim($('#collection').val());
        task.elementVariable = $.trim($('#elementVariable').val());
        task.completionCondition = $.trim($('#completionCondition').val());

        tip('保存成功');
    }

    //加载变量
    function populateTaskProperites() {
        rows[0].value = task.taskId;
        rows[1].value = task.taskName;
        rows[2].value = task.documentation;
        rows[3].value = task.formKey;
    }

    //加载属性表格数据
    function propertygrid() {
        $('#task-propertygrid').propertygrid('loadData', rows);
        populateTaskProperites();
    }


    //获取任务监听器id
    function getOldListenerIds() {
        var listeners = task.listeners;
        var listenersIds = [];
        for (var i = 0; i < listeners.getSize(); i++) {
            var listener = listeners.get(i);
            listenersIds.push(listener.getId());
        }
        return listenersIds.join(",");
    }

    //添加任务监听器
    function addListener(id, event, serviceType, value) {
        var ls = task.getListener(id);
        if (!ls) {
            var listener = new draw2d.Task.Listener();
            listener.id = id;
            listener.event = event;
            listener.serviceType = serviceType;
            listener.serviceClass = value;
            listener.serviceExpression = value;
            task.addListener(listener);
        }
    }

    function addProcessListener(title, url, gridname) {
        add(title, url, gridname, 500, 200);
    }

    //删除任务监听器
    function removeListener(id) {
        task.deleteListener(id);
    }

    function addListeners() {
        var title = "监听列表";
        var options = {};
        var addurl = "/page/taListenerController/goListenerListPage?typeId=2";
        var width = 860;
        var height = 410
        var offsetW = window.top.document.body.offsetWidth;
        var offsetH = window.top.document.body.offsetHeight;
        if (width == "100%" || width > offsetW) {
            width = offsetW;
        }
        if (height == "100%" || height > (offsetH - 100)) {
            height = offsetH - 100;
        }
        var myOptions = {
            content: 'url:' + addurl,
            lock: true,
            width: parseInt(width),
            height: parseInt(height),
            title: title,
            opacity: 0.3,
            parent:'addListeners',
            id:'addListeners_id',
            cache: false,
            /* 为true等价于function(){} */
        };
        if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    //选择好的数据
                    var rowsDatas = iframe.$('#listenerList').datagrid('getSelections');
                    if(rowsDatas.length!=1){
                    }else{
                        var obj = {};
                        obj.listenerId = rowsDatas[0].id;
                        obj.listenerEvent= rowsDatas[0].listenerEvent;
                        obj.listenerType= rowsDatas[0].listenerType;
                        obj.listenerValue= rowsDatas[0].listenerValue;
                        obj.listenerName= rowsDatas[0].listenerName;
                        saveProcessListener(obj);
                    }
                    return true;
                },
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.extend(myOptions, options);
        safeShowDialog(myOptions);
    }


    //保存监听
    function saveProcessListener(obj) {
        var listenerIds = obj.listenerId;
        var listenerEvents = obj.listenerEvent;
        var listenerTypes = obj.listenerType;
        var listenerValues = obj.listenerValue;
        var listenerNames = obj.listenerName;

        var ls = task.getListener(listenerIds);
        addListener(listenerIds, listenerEvents, listenerTypes, listenerValues);
        if (!ls) {
            $('#listenerList').datagrid('appendRow', {
                id: listenerIds,
                listenerName: listenerNames,
                listenerEvent: listenerEvents,
                listenerType: listenerTypes,
                listenerValue: listenerValues
            });
        }
    }

    //删除流程监听
    function delRow(rowid, idx) {
        $('#listenerList').datagrid('deleteRow', idx);
        removeListener(rowid);
    }
</script>

<div id="task-properties-layout" class="easyui-layout" fit="true">
    <div id="task-properties-toolbar-panel" region="north" border="false" style="height:30px; background: #E1F0F2;">
        <c:if test="${optype!=2}">
            <a href="##" id="sb2" class="easyui-linkbutton" plain="true" iconCls="icon-save" onclick="saveTaskProperties()">保存</a>
        </c:if>
    </div>
    <div id="task-properties-panel" region="center" border="true">
        <div id="task-properties-accordion" class="easyui-accordion" fit="true" border="false">
            <div id="task" title="节点属性" selected="true" class="properties-menu">
                <table id="task-propertygrid">
                </table>
            </div>
            <div id="main-config" title="人员配置" class="properties-menu">
                <div class="datagrid-toolbar" style="height:auto">
                    <table id="main-properties">
                        <tr>
                            <td align="right">
                                <label style="font-size:13px;"> 类型:</label>
                            </td>
                            <td>
                                <select id="performerType" name="performerType" style="width:100px;" <c:if test="${optype==2}"> disabled="disabled" </c:if> >
                                    <option value="assignee">处理职位</option>
                                    <option value="candidateUsers">备选职位</option>
                                    <option value="candidateGroups">角色</option>
                                </select>
                                <c:if test="${optype!=2}">
                                <a href="#" class="easyui-linkbutton" plain="true" iconCls="icon-add"
                                   onclick="xuanze();"></a>
                                </c:if>
                            </td>
                        </tr>
                        <tr>
                            <td align="right">
                                <label style="font-size:13px;"> 表达式:</label>
                            </td>
                            <td>
                                <input type="text" id="expression" name="expression" <c:if test="${optype==2}"> disabled="disabled" </c:if> style="width:190px"/>
                            </td>
                        </tr>
                    </table>
                </div>
                <div id="task-candidate-panel" class="easyui-panel"
                     style="overflow: hidden; width: 280px; height: 450px; padding:1px;">
                </div>
            </div>

            <div id="taskHuiQianProperties" title="会签属性" selected="true">
                <table id="main-properties">
                    <tr>
                        <td align="right">
                            <label style="font-size:13px;">状态:</label>
                        </td>
                        <td>
                            <select id="isSequential" name="isSequential"  <c:if test="${optype==2}"> disabled="disabled" </c:if> style="width:160px;">
                                <option value="">不启动多实例</option>
                                <option value="false">并行</option>
                                <option value="true">顺序</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td align="right">
                            <label style="font-size:13px;"> 循环数量:</label>
                        </td>
                        <td>
                            <input type="text" id="loopCardinality" name="loopCardinality"  <c:if test="${optype==2}"> disabled="disabled" </c:if> style="width:160px"/>
                        </td>
                    </tr>
                    <tr>
                        <td align="right">
                            <label style="font-size:13px;"> 循环集合:</label>
                        </td>
                        <td>
                            <input type="text" id="collection" name="collection"  <c:if test="${optype==2}"> disabled="disabled" </c:if> style="width:160px"/>
                        </td>
                    </tr>
                    <tr>
                        <td align="right">
                            <label style="font-size:13px;">元素名称:</label>
                        </td>
                        <td>
                            <input type="text" id="elementVariable" name="elementVariable"  <c:if test="${optype==2}"> disabled="disabled" </c:if> style="width:160px"/>
                        </td>
                    </tr>
                    <tr>
                        <td align="right">
                            <label style="font-size:13px;">结束条件:</label>
                        </td>
                        <td>
                            <input type="text" id="completionCondition" name="completionCondition"  <c:if test="${optype==2}"> disabled="disabled" </c:if> style="width:160px"/>
                        </td>
                    </tr>
                </table>
                <fieldset style="line-height: 21px;">
                    <legend>说明</legend>
                    <div>1.\${flowUtil.stringToList(assigneeUserIdList)}，将字符串转换成集合，暴露的SpringBean方法</div>
                    <div>
                        2.多实例任务Activiti默认会创建3个流程变量，nrOfInstances:实例总数，nrOfActiveInstances:当前活跃的，也就是当前还未完成的，对于顺序的多实例，此值总是1,nrOfCompletedInstances:已完成的实例个数。
                    </div>
                    <div>3.状态:不启动多实例,则只会创建一个任务，默认不启动，不启动多实例，一下配置都无效，true:顺序执行，fasle:并行,同时执行。</div>
                    <div>4.循环数量:指定创建多任务的数量。可使用表达式从流程变量获取。</div>
                    <div>
                        5.循环集合:流程变量中一个集合类型变量的变量名称。根据集合元素多少创建任务数量。可使用表达式。例:流程变量：assigneeUserIdList=[user1,user2]，可用assigneeUserIdList。
                    </div>
                    <div>
                        6.集合元素:集合中每个元素的变量名称，可在每个任务中获取,可使用表达式。例：集合为当定义集合元素名称为:assigneeUserId,可在任务直接指派人员用表达式\${assigneeUserId}获取，用于动态会签。
                    </div>
                    <div>7.结束条件:多实例活动结束的条件，默认为完成多全部实例，当表达式返回true时结束多实例活动。例：\${nrOfCompletedInstances/nrOfInstances>=0.6}
                        说明当有60%的任务完成时，会完成此多实例，删除其他未完成的，继续下面的流程。
                    </div>
                </fieldset>
            </div>

            <div id="listeners" title="任务监听器" style="overflow: hidden;padding:1px;">
                <t:datagrid title="添加删除操作,需点击保存" name="listenerList" fitColumns="true"
                            actionUrl="${activitiRoot}taListenerController/findSelectedListenerList?1=1"
                            extendParams="queryParams:{ids:getOldListenerIds()}" pagination="false" idField="id">
                    <t:dgCol title="id" hidden="true" field="id"></t:dgCol>
                    <t:dgCol title="名称" field="listenerName" width="30"></t:dgCol>
                    <t:dgCol title="事件" field="listenerEvent" width="30"></t:dgCol>
                    <t:dgCol title="类型" field="listenerType" width="30"></t:dgCol>
                    <t:dgCol title="执行内容" field="listenerValue" width="50"></t:dgCol>
                    <t:dgCol title="操作" field="opt" width="30"></t:dgCol>
                    <t:dgFunOpt funname="delRow(id)" title="删除"></t:dgFunOpt>
                    <t:dgToolBar title="新增" icon="icon-add" funname="addListeners" url="/page/taListenerController/goListenerListPage?typeId=2"></t:dgToolBar>
                </t:datagrid>

                <input name="listenerId" type="hidden" id="listenerId">
                <input name="listenerName" type="hidden" id="listenerName">
                <input name="listenerEvent" type="hidden" id="listenerEvent">
                <input name="listenerType" type="hidden" id="listenerType">
                <input name="listenerValue" type="hidden" id="listenerValue"
                <%--<t:choose hiddenName="listenerId" hiddenid="id" fun="saveProcessListener"--%>
                <%--url="/page/taListenerController/goListenerListPage?typeId=2"--%>
                <%--textname="listenerName,listenerEvent,listenerType,listenerValue"--%>
                <%--name="listenerList" icon="icon-add" title="监听列表"></t:choose>--%>

            </div>
        </div>
    </div>
</div>

