<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools"/>

<div id="taProcessMain" class="easyui-layout" fit="true">
    <div region="center" style="padding: 1px;" id="process-panelss">
        <t:datagrid name="taProcessList"  fitColumns="false" queryMode="group"
                    actionUrl="/activiti/taProcessController/findProcessList?1=1" idField="id">
            <t:dgCol title="流程id" field="id" width="150" hidden="true"/>
            <t:dgCol title="流程KEY" field="processKey" query="true" width="200"/>
            <t:dgCol title="流程名称" field="processName" query="true" width="250"/>
            <t:dgCol title="流程状态" field="processState" replace="已发布_1,未发布_0" query="true" width="100"/>

            <t:dgToolBar title="添加流程" operationCode="add"  icon="icon-add" url="/page/taProcessController/goTaProcessForm"
                         funname="addTaProcess"/>
            <t:dgToolBar title="编辑流程" operationCode="edit" icon="icon-edit" url="/page/taProcessController/goTaProcessForm"
                         funname="updateTaProcess"/>
            <t:dgToolBar title="查看流程" operationCode="look" icon="icon-look" url="/page/taProcessController/goTaProcessForm"
                         funname="detailTaProcess"/>
            <t:dgToolBar icon="icon-process_config" operationCode="configure" url="/page/taProcessController/processTabs?1=1"
                         funname="systemAddOneTab" params="id" title="配置"/>
            <t:dgToolBar icon="icon-check_copy" operationCode="copy" url="/page/taCarbonCopyController/goAddCarbonCopyMain?1=1"
                         funname="view" params="id" title="抄送" width="800" height="800"/>
            <t:dgToolBar icon="icon-check_deployment" operationCode="release"
                         url="/activiti/taDeploymentController/deployProcess" funname="systemConfirm" params="id"
                         title="发布"/>
            <t:dgToolBar icon="icon-remove" id="delId" operationCode="remove"
                         url="/activiti/taProcessController/deleteTaProcess"  funname="systemConfirm"
                         params="id" title="删除"/>
            <t:dgToolBar icon="icon-check_version" id="versionId" operationCode="version"
                         url="/page/taProcessDefinitionController/goProcessDefinitionMain?1=1"
                         funname="systemAddOneTab" params="processKey" title="版本监控"/>
            <t:dgToolBar icon="icon-process_config" id="checkId" operationCode="check"
                         url="/page/taProcessCheckController/processcheckView?1=1"
                         funname="systemAddOneTab" params="processKey" title="流程检测"/>
        </t:datagrid>
    </div>
</div>

<script type="text/javascript">
    function addTaProcess(title, url, gridname) {
        url = url+"?optype=0";
        openwindow(title, url, gridname, 1150, 650);
    }

    function updateTaProcess(title, url, id) {
        gridname = id;
        var rowsData = $('#' + id).datagrid('getSelections');
        if (!rowsData || rowsData.length == 0) {
            tip('请选择编辑项目');
            return;
        }
        if (rowsData.length > 1) {
            tip('请选择一条记录再编辑');
            return;
        }

        url += '?id=' + rowsData[0].id+"&optype=1";
        openwindow(title, url, gridname, 1150, 650);
    }

    function detailTaProcess(title, url, id) {
        gridname = id;
        var rowsData = $('#' + id).datagrid('getSelections');
        if (!rowsData || rowsData.length == 0) {
            tip('请选择查看项目');
            return;
        }
        if (rowsData.length > 1) {
            tip('请选择一条记录再查看');
            return;
        }

        url += '?id=' + rowsData[0].id+"&optype=2";
        openwindow(title, url, gridname, 1150, 650);
    }

    function carbonCopy(id) {
        add("抄送", "/page/taCarbonCopyController/goAddCarbonCopyMain?taProcessId=" + id, 'taProcessList', 1000, 700);
    }
</script>