<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker,autocomplete" extendUrlKey="feeDetailListMain"></t:base>
<div id="coding_rules_List" class="easyui-layout" fit="true">
    <div region="center" style="padding: 1px;">
        <t:datagrid name="feeDetail" tagConf="${clickFunctionId}" controllerTarget="ttFeePoolDetailController" methedTarget="feeDetail" idField="id" queryMode="group" fit="true" fitColumns="true"
                    actionUrl="/fee/ttFeePoolDetailController/feeDetail" pagination="true">
            <t:dgCol title="主键" field="id"  hidden="true"></t:dgCol>
            <t:dgCol title="extChar1" field="extChar1"  hidden="true"></t:dgCol>
            <t:dgCol title="extChar2" field="extChar2"  hidden="true"></t:dgCol>
            <t:dgCol title="extChar3" field="extChar3"  hidden="true"></t:dgCol>
            <t:dgCol title="extChar4" field="extChar4"  hidden="true"></t:dgCol>
            <t:dgCol title="extChar5" field="extChar5"  hidden="true"></t:dgCol>
            <t:dgCol title="费用池编码" field="poolDetailCode"  hidden="false" ></t:dgCol>
            <t:dgCol title="客户编码" field="custCode"  hidden="false" query="true"></t:dgCol>
            <t:dgCol title="客户名称" field="custName"  hidden="false" query="true"></t:dgCol>
            <t:dgCol title="支付方式" field="payType" dictionary ="pay_type" query="true"></t:dgCol>
            <t:dgCol title="产品层级编码" field="productLevel"  hidden="false" query="true"></t:dgCol>
            <t:dgCol title="产品层级名称" field="productLevelName"  hidden="false" query="true"></t:dgCol>
            <t:dgCol title="活动明细编码" field="actDetailCode"  hidden="false" query="true"></t:dgCol>
            <t:dgCol title="活动名称" field="actName"  hidden="false" query="true"></t:dgCol>
            <t:dgCol title="活动类型" field="actType" formatterjs="tansActType" dictionary="act_type"  hidden="false" query="true"></t:dgCol>
            <t:dgCol title="上账来源编号" field="fromCode"  query="true"></t:dgCol>
            <t:dgCol title="上账来源描述" field="notes"  query="true"></t:dgCol>
            <t:dgCol title="上账类型" field="feePoolType" dictionary="fee_pool_detail_type" query="true"></t:dgCol>
            <t:dgCol title="上账金额" field="feeAmount"  ></t:dgCol>
            <t:dgCol title="余额" field="feeUsableAmount"  ></t:dgCol>

            <t:dgCol title="核销细类编码" field="auditDetailCode"  query="true"></t:dgCol>
            <t:dgCol title="科目编码" field="subjectCode"  query="true"></t:dgCol>
            <t:dgCol title="科目名称" field="subjectName"  query="true"></t:dgCol>
            <t:dgCol title="凭证编号" field="voucherCode"  query="true"></t:dgCol>
            <t:dgCol title="细类编号" field="fineCode"  query="true"></t:dgCol>
            <t:dgCol title="细类名称" field="fineName"  query="true"></t:dgCol>
            <t:dgCol title="大类编号" field="categoriesCode"  query="true"></t:dgCol>
            <t:dgCol title="大类名称" field="categoriesName"  query="true"></t:dgCol>
            <t:dgCol title="传输状态" field="sendType"   query="false"></t:dgCol>
            <t:dgCol title="支付方式类型" field="payTypeCode" hidden="true" ></t:dgCol>
            <t:dgCol title="上账时间" field="createDate" formatter="yyyy-MM-dd hh:mm:ss"></t:dgCol>
            <t:dgCol title="操作人" field="createName"  ></t:dgCol>
            <t:dgToolBar operationCode="edit" title="手工调整" icon="icon-edit" url="/page/ttFeePoolController/goSaveOrUpdate?clickFunctionId=${clickFunctionId}"
                         funname="updateParamNull" callBackBefor="check"></t:dgToolBar>
            <t:dgToolBar operationCode="add" title="手工新增" icon="icon-add" url="/page/ttFeePoolController/goSaveOrUpdateAdd?clickFunctionId=${clickFunctionId}"
                         funname="add"></t:dgToolBar>
            <t:dgToolBar operationCode="lookUsed" title="查看使用明细" icon="icon-disable" params="poolDetailCode"
                         url="/page/ttFeePoolDetailController/goDetailUsedMain?1=1"
                         funname="view" width="800" height="500"></t:dgToolBar>
            <t:dgToolBar operationCode="repeatSend" title="重发" icon="icon-reload" url="" funname="repeatSend"></t:dgToolBar>
            <t:dgToolBar title="导出" operationCode="dataOut" icon="icon-dataOut"  excelName="费用池明细" excelSheetName="费用池明细"
                         url="/fee/commonExcelController/excel" funname="excelCommonExport"></t:dgToolBar>
            <t:dgToolBar operationCode="style" title="个性设置" icon="icon-add" url="/page/knlSelectListController/goSelectList?functionId=${clickFunctionId}"
                         width="600" height="500"     funname="addSelect"></t:dgToolBar>
        </t:datagrid>
    </div>
</div>

<script>
    function check() {
        var rowsData = $('#feeDetail').datagrid('getSelections');
        if(rowsData.length==1&&rowsData[0].payTypeCode=='BILL'){
            tip("此种类型不允许调整");
          return false;
        }
        return true;
    }


    /**
     * 替換類型值
     */
    function tansActType(value, row, index) {
        if(value == '1'){
            return "价格活动";
        }
        if(value == '2'){
            return "定额活动";
        }
        if(value == '3'){
            return "部门费用";
        }
        if(value == '4'){
            return "实物费用";
        }
        if(value == '5'){
            return "部门领用";
        }
        if(value == '6'){
            return "项目活动";
        }
        if(value == '7'){
            return "返利活动";
        }
    }
</script>

