<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker,autocomplete"></t:base>
<div id="notice_List" class="easyui-layout" fit="true">
    <div region="center" style="padding: 1px;">
        <t:datagrid name="requestList" tagConf="${clickFunctionId}"  idField="id" queryMode="group" fit="true" fitColumns="true"
                    actionUrl="/kernel/knlPostRequestController/findKnlPostRequestPage" pagination="true">
            <t:dgCol field="id" title="主键"  hidden="true"></t:dgCol>
            <t:dgCol field="requestType" title="请求方式"  query="true"></t:dgCol>
            <t:dgCol field="requestUrl" title="请求url"  ></t:dgCol>
            <t:dgCol title="状态" field="enableStatus" query="true" dictionary="enable_status"></t:dgCol>
            <t:dgCol field="createName" title="创建人"   ></t:dgCol>
            <t:dgCol field="updateDate" title="最近更新时间"   formatter="yyyy-MM-dd hh:mm:ss"></t:dgCol>
            <t:dgCol title="操作" field="opt"></t:dgCol>
            <t:dgFunOpt  title="监控" funname="monitor(id)" ></t:dgFunOpt>

            <t:dgToolBar operationCode="add" title="新增" icon="icon-add" url="/page/knlPostRequestController/goKnlPostTable"
                         funname="saveRequest('add')" width="1000" height="600"></t:dgToolBar>
            <t:dgToolBar operationCode="edit" title="编辑" icon="icon-edit" url="/page/knlPostRequestController/goKnlPostTable"
                         funname="saveRequest('update')" width="1000" height="600"></t:dgToolBar>
            <t:dgToolBar operationCode="remove" title="删除" icon="icon-remove" url="/kernel/knlPostRequestController/deleteKnlPost"
                         funname="deleteALLSelect"></t:dgToolBar>
            <t:dgToolBar title="启用" operationCode="start" icon="icon-start" url="/kernel/knlPostRequestController/startOrStop" funname="startOrStop('009')"></t:dgToolBar>
            <t:dgToolBar title="停用" operationCode="stop" icon="icon-stop" url="/kernel/knlPostRequestController/startOrStop" funname="startOrStop('003')"></t:dgToolBar>

        </t:datagrid>
    </div>
</div>

<script type="text/javascript">
    function saveRequest(obj) {
        var id = "";
        if (obj == "update") {
            var target = $("#requestList").datagrid('getSelected');
            if(target == null){
                tip("请选择一条要操作的数据");
                return;
            }
            id = target.id
        }
        // add(title, addurl+"?dictTypeCode="+_dictTypeCode, gname, width, height, params)
        safeShowDialog({
            content: "url:" + '/page/knlPostRequestController/goKnlPostTable?id='+id,
            lock: true,
            title: "监控",
            width: 1000,
            height:500,
            left: '85%',
            cache: false,
            ok: function () {
                window.location.href="/page/knlPostRequestController/goKnlPostRequestMain?1=1";
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    function monitor(id){
        safeShowDialog({
            content: "url:" + '/page/knlRequestRecordController/goKnlRequestRecordMain?id='+id,
            lock: true,
            title: "监控",
            width: 1000,
            height:500,
            left: '85%',
            cache: false,
            ok: function () {
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    //启用停用
    function startOrStop(flag){
        var target = $("#requestList").datagrid('getSelected');
        if(target == null){
            tip("请选择一条要操作的数据");
            return;
        }
        var tipmMsg = "";
        if(flag == "009"){
            tipmMsg = "确定要启用该数据吗?"
        }else{
            tipmMsg = "确定要停用该数据吗?"
        }
        $.messager.confirm('操作提示',tipmMsg,function(r){
            if (r){
                $.ajax({
                    type : "POST",
                    url : "/kernel/knlPostRequestController/startOrStop",
                    data : {
                        "id" : target.id,
                        "enableStatus": flag
                    },
                    dataType : "json",
                    success : function(data) {
                        tip(data.msg);
                        $("#requestList").datagrid('reload');
                    },
                    error:function(){
                        tip("服务器异常，请稍后再试");
                    }
                });
            }
        });
    }

</script>