<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>品类销售数据</title>
    <link rel="stylesheet" href="/resources/sfa/css/normalize.css">
    <link rel="stylesheet" href="/resources/sfa/css/flex.css">
    <link rel="stylesheet" href="/resources/sfa/css/spacing.css">
    <style>
        [v-cloak]{
            display: none;
        }
        .container{
            box-sizing: border-box;
            overflow-y: auto;
        }
        .chart-title {
            text-align: center;
        }

        .sale-chart {
            height: 300px;
        }

        .chart-table table {
            width: 100%;
            border-collapse: collapse;
        }

        .chart-table table td,
        .chart-table table th {
            height: 30px;
            border: 1px solid #eeeeee;
            box-sizing: border-box;
            position: relative;
            text-align: center;
        }

        .chart-table table th {
            background: #f6f6f6;
        }

        .finish-percent {
            position: relative;
            width: 0;
            height: 80%;
            transition: all .5s ease-in;
        }

        .finish-percent span {
            color: #fff;
            position: absolute;
            left: 0;
            top: 2px;
        }

        .finish-progress {
            width: 100%;
            height: 16px;
            background: #ddd;
        }

        .progress-bar {
            height: 6px;
            width: 0;
            background: #1890ff;
            border-radius: 6px;
            transition: width .5s ease-in;
        }

        .text-normal {
            color: green;
        }

        .text-danger {
            color: red;
        }
    </style>
</head>

<body>
    <div id="app" v-cloak>
        <div class="container p10">
            <h1 class="chart-title">品类销售数据分析</h1>
            <div class="month-sale">
                <div class="chart-table mb20">
                    <table>
                        <thead>
                            <tr>
                                <th>品类</th>
                                <th>实际-销售额</th>
                                <th>实际-销量-吨</th>
                                <th>实际-成本</th>
                                <th>实际-费用</th>
                                <th>去年-销售额</th>
                                <th>环比增长</th>
                                <th>计划达成度</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="(item,index) in tableData">
                                <td>{{item.category}}</td>
                                <td>{{item.realSaleMoney}}<i class="fa fa-long-arrow-up ml5 text-normal"></i></td>
                                <td>{{item.realSaleNum}}</td>
                                <td>{{item.realCost}}</td>
                                <td>{{item.realFee}}</td>
                                <td>{{item.lastSaleMoney}}</td>
                                <td>{{item.increase}}%<i class="fa fa-circle ml5 text-danger"></i></td>
                                <td>
                                    <div class="finish-progress flex flex-align-items-center">
                                        <div class="progress-bar" :style="{width:item.finish+'%'}">
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="sale-chart">
                    <div ref="saleLine" style="width: 100%;height: 100%;"></div>
                </div>
                <div class="sale-chart">
                    <div ref="saleFeeLine" style="width: 100%;height: 100%;"></div>
                </div>
            </div>
        </div>
    </div>
    <script src="/resources/sfa/js/vue.min.js"></script>
    <script src="/resources/sfa/js/echarts.min.js"></script>
    <script>
        let vm = new Vue({
            el: "#app",
            data: function () {
                return {
                    saleLine: null,
                    saleFeeLine: null,
                    tableData: [{
                        category: "鲜奶",
                        realSaleMoney: 16892234,
                        realSaleNum: 3378446.8,
                        realCost: 8446117,
                        realFee: 5067670.2,
                        lastSaleMoney: 16419251.45,
                        increase: 2.80,
                        finish: 87
                    }, {
                        category: "常温奶",
                        realSaleMoney: 9856432,
                        realSaleNum: 1971286.4,
                        realCost: 4928216,
                        realFee: 2956929.6,
                        lastSaleMoney: 9324184.672,
                        increase: 5.40,
                        finish: 95
                    }, {
                        category: "酸奶",
                        realSaleMoney: 8867841,
                        realSaleNum: 1773568.2,
                        realCost: 4433920.5,
                        realFee: 2660352.3,
                        lastSaleMoney: 8965387.251,
                        increase: -1.10,
                        finish: 91
                    }, {
                        category: "酸酸乳",
                        realSaleMoney: 8696723,
                        realSaleNum: 1739344.6,
                        realCost: 4348361.5,
                        realFee: 2609016.9,
                        lastSaleMoney: 8331460.634,
                        increase: 4.20,
                        finish: 75
                    }]
                }
            },
            mounted: function () {
                this.initSaleLine();
                this.initSaleFeeLine();
            },
            methods: {
                initSaleLine: function () {
                    this.saleLine = echarts.init(this.$refs.saleLine);
                    let option = {
                        title: {
                            text: "品类销售额",
                            x: '20%'
                        },
                        legend: {},
                        tooltip: {
                            trigger: 'axis',
                            showContent: false
                        },
                        dataset: {
                            source: [
                                ['business', '1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月', '9月',
                                    '10月', '11月', '12月'
                                ],
                                ['鲜奶', 41.1, 30.4, 65.1, 53.3, 83.8, 98.7, 86.5, 92.1, 85.7,
                                    83.1, 73.4, 55.1
                                ],
                                ['酸奶', 86.5, 92.1, 85.7, 83.1, 73.4, 55.1, 24.1, 67.2, 79.5,
                                    86.4, 65.2, 82.5
                                ],
                                ['常温奶', 24.1, 67.2, 79.5, 86.4, 65.2, 82.5, 41.1, 30.4, 65.1,
                                    53.3, 83.8, 98.7
                                ],
                                ['酸酸乳', 55.2, 67.1, 69.2, 72.4, 53.9, 39.1, 86.5, 92.1, 85.7,
                                    83.1, 73.4, 55.1
                                ]
                            ]
                        },
                        xAxis: {
                            type: 'category'
                        },
                        yAxis: {
                            gridIndex: 0
                        },
                        grid: {
                            right: '30%'
                        },
                        series: [{
                                type: 'line',
                                smooth: true,
                                seriesLayoutBy: 'row'
                            },
                            {
                                type: 'line',
                                smooth: true,
                                seriesLayoutBy: 'row'
                            },
                            {
                                type: 'line',
                                smooth: true,
                                seriesLayoutBy: 'row'
                            },
                            {
                                type: 'line',
                                smooth: true,
                                seriesLayoutBy: 'row'
                            },
                            {
                                type: 'pie',
                                id: 'pie',
                                radius: '50%',
                                center: ['85%', '50%'],
                                label: {
                                    formatter: '{b}: {@1月} ({d}%)'
                                },
                                encode: {
                                    itemName: 'business',
                                    value: '1月',
                                    tooltip: '1月'
                                }
                            }
                        ]
                    };

                    this.saleLine.on('updateAxisPointer', (event) => {
                        var xAxisInfo = event.axesInfo[0];
                        if (xAxisInfo) {
                            var dimension = xAxisInfo.value + 1;
                            this.saleLine.setOption({
                                series: {
                                    id: 'pie',
                                    label: {
                                        formatter: '{b}: {@[' + dimension + ']} ({d}%)'
                                    },
                                    encode: {
                                        value: dimension,
                                        tooltip: dimension
                                    }
                                }
                            });
                        }
                    });

                    this.saleLine.setOption(option);
                },
                initSaleFeeLine: function () {
                    this.saleFeeLine = echarts.init(this.$refs.saleFeeLine);
                    let option = {
                        title: {
                            text: "品类费用",
                            x: '20%'
                        },
                        legend: {},
                        tooltip: {
                            trigger: 'axis',
                            showContent: false
                        },
                        dataset: {
                            source: [
                                ['business', '1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月', '9月',
                                    '10月', '11月', '12月'
                                ],
                                ['牛奶', 41.1, 30.4, 65.1, 53.3, 83.8, 98.7, 86.5, 92.1, 85.7,
                                    83.1, 73.4, 55.1
                                ],
                                ['鲜奶', 86.5, 92.1, 85.7, 83.1, 73.4, 55.1, 24.1, 67.2, 79.5,
                                    86.4, 65.2, 82.5
                                ],
                                ['常温奶', 24.1, 67.2, 79.5, 86.4, 65.2, 82.5, 41.1, 30.4, 65.1,
                                    53.3, 83.8, 98.7
                                ],
                                ['酸酸乳', 55.2, 67.1, 69.2, 72.4, 53.9, 39.1, 86.5, 92.1, 85.7,
                                    83.1, 73.4, 55.1
                                ]
                            ]
                        },
                        xAxis: {
                            type: 'category'
                        },
                        yAxis: {
                            gridIndex: 0
                        },
                        grid: {
                            right: '30%'
                        },
                        series: [{
                                type: 'line',
                                smooth: true,
                                seriesLayoutBy: 'row'
                            },
                            {
                                type: 'line',
                                smooth: true,
                                seriesLayoutBy: 'row'
                            },
                            {
                                type: 'line',
                                smooth: true,
                                seriesLayoutBy: 'row'
                            },
                            {
                                type: 'line',
                                smooth: true,
                                seriesLayoutBy: 'row'
                            },
                            {
                                type: 'pie',
                                id: 'pie',
                                radius: '50%',
                                center: ['85%', '50%'],
                                label: {
                                    formatter: '{b}: {@1月} ({d}%)'
                                },
                                encode: {
                                    itemName: 'business',
                                    value: '1月',
                                    tooltip: '1月'
                                }
                            }
                        ]
                    };

                    this.saleFeeLine.on('updateAxisPointer', (event) => {
                        var xAxisInfo = event.axesInfo[0];
                        if (xAxisInfo) {
                            var dimension = xAxisInfo.value + 1;
                            this.saleFeeLine.setOption({
                                series: {
                                    id: 'pie',
                                    label: {
                                        formatter: '{b}: {@[' + dimension + ']} ({d}%)'
                                    },
                                    encode: {
                                        value: dimension,
                                        tooltip: dimension
                                    }
                                }
                            });
                        }
                    });

                    this.saleFeeLine.setOption(option);
                }
            },
        })
    </script>
</body>

</html>