<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@include file="/context/mytags.jsp"%>
<t:base type="jquery,easyui,tools,DatePicker"></t:base>
<div id="system_org_tbaList" class="easyui-layout" fit="true">
    <div region="center" style="padding: 1px;">
        <t:datagrid name="tsDirectoryConfigList" title="采集信息管理"  actionUrl="/sfaapi/tsDirectoryInputController/findTsDirectoryInputList"
                    idField="id" fit="true"  fitColumns="false" pagination="true" queryMode="group">
            <t:dgCol title="id"  field="id"  hidden="true"  queryMode="single"  ></t:dgCol>
            <t:dgCol title="上传人"  field="createCode"  hidden="false"  query="true" queryMode="single"  ></t:dgCol>
            <t:dgCol title="上传时间"  field="submitDate"  hidden="true" query="true" formatter="yyyy-MM-dd" sortable="false" frozenColumn="true" queryMode="group"  ></t:dgCol>
            <t:dgCol title="上传时间"  field="createDate" sortable="false" hidden="false" formatter="yyyy-MM-dd hh:mm:ss" queryMode="group"  ></t:dgCol>
            <t:dgCol title="组织" field="orgNames"  query="true" hidden="true"></t:dgCol>

            <t:dgCol title="拜访对象"  field="visitObjectName"  hidden="false"   queryMode="single"  ></t:dgCol>
            <t:dgCol title="拜访对象"  field="visitObjectCode" query="true" dictionary="visit_obj"  hidden="true"  queryMode="single"  ></t:dgCol>
            <t:dgCol title="主目录"  field="primaryDirectoryName"   hidden="false"  queryMode="single"  ></t:dgCol>
            <t:dgCol title="主目录"  field="primaryDirectoryCode" query="true"  dictionary="primary_directory" hidden="true"  queryMode="single"  ></t:dgCol>
            <t:dgCol title="二级目录"  field="directoryName"  hidden="false" query="true" queryMode="single"  ></t:dgCol>
            <t:dgCol title="门店编号"  field="terinalCode"  hidden="false"  query="true" queryMode="single"  ></t:dgCol>
            <t:dgCol title="门店名称"  field="terinalName" query="true"  hidden="false"  queryMode="single"  ></t:dgCol>
            <t:dgCol title="客户编号"  field="customerCode"  hidden="false" query="true"  queryMode="single"  ></t:dgCol>
            <t:dgCol title="客户名称"  field="customerName" query="true"  hidden="false"  queryMode="single"  ></t:dgCol>
            <t:dgCol title="状态"  field="status" query="true"  hidden="false" dictionary="collection_status" queryMode="single"  ></t:dgCol>
            <t:dgCol title="是否有照片"  field="isHavePhoto" query="true"  hidden="true" dictionary="market_yn" queryMode="single"  ></t:dgCol>
            <t:dgCol title="照片是否有翻拍"  field="hasPhotoRemake" query="true"  hidden="false" dictionary="market_yn" queryMode="single"  ></t:dgCol>
            <c:forEach items="${optionList}" var="option">

                <c:if test="${option == 'on'}">
                    <t:dgToolBar title="有效" operationCode="" icon="icon-start" url="" funname="start"></t:dgToolBar>
                </c:if>
                <c:if test="${option == 'off'}">
                    <t:dgToolBar title="无效" operationCode="" icon="icon-stop" url="" funname="stop"></t:dgToolBar>
                </c:if>

            </c:forEach>

                <t:dgToolBar title="查看" operationCode="" icon="icon-look" url="/page/tsDirectoryInputController/goTsDirectoryInputInfo" funname="detail" width="800" height="800"></t:dgToolBar>
                <t:dgToolBar title="导出" operationCode="" icon="icon-dataOut" url="/sfaapi/tsDirectoryInputController/exportXls" funname="toExcel"></t:dgToolBar>
                <t:dgToolBar title="最新记录导出" operationCode="" icon="icon-dataOut" url="/sfaapi/tsDirectoryInputController/exportLastXls" funname="toLastExcel"></t:dgToolBar>
                <t:dgToolBar title="重新上传AI" operationCode="resendToAi"  icon="icon-dataIn"  url="/sfaapi/ttFridgeMainController/exportCheckXlsLatest"  funname="resendToAi"></t:dgToolBar>

        </t:datagrid>
    </div>
    <input type="text">
</div>
<script type="text/javascript">
    $(document).ready(function(){
        $("#tsDirectoryConfigListtb_r").find("input[name='submitDate_begin']").val("${curDate}");
        $("#tsDirectoryConfigListtb_r").find("input[name='submitDate_end']").val("${curDate}");
        $("input[name='orgNames']").attr("readonly",true).attr("id","orgNames").attr("style","width:180px").click(function(){openOrgSelect();}).parent().append("<input type='hidden' name='orgCodes' id='orgCodes'/>");

    });
    function start(){
        var rows = $("#tsDirectoryConfigList").datagrid("getSelected");
        if(rows == null || rows.length == 0){
            tip("请选择一条数据","error");
            return false;
        }
        if(rows.status == 1){
            tip("该数据已是有效状态","error");
            return false;
        }
        $.ajax({
            async : false,
            cache : false,
            type : 'POST',
            data:{status:'009',id:rows.id},
            url : "/sfaapi/tsDirectoryInputController/updateStatus",// 请求的action路径
            success : function(data) {
                var d = $.parseJSON(data);
                if (d.success) {
                    tip("修改成功","info");
                    $("#tsDirectoryConfigList").datagrid("reload");
                }else{
                    tip(d.msg,"error");
                }
            }
        });
    }

    function openOrgSelect(){
        var orgCode ='${orgCode}';
        var currentOrgCode='${currentOrgCode}';
        orgCode = (typeof(orgCode) == "undefined") ? '' : orgCode;
        var paraArr = {
            textName: 'orgCode,orgName',
            inputTextName: 'orgCodes,orgNames',
            searchType: '1',//查询类型？？
            encapsulationType: 'input',//封装类型--不传或默认
            isCouldRemove: false,//false：不可移除已选组织，true：可移除已选组织，默认为true；
            currentOrgCode:currentOrgCode,
            pageData: {
                orgCode: orgCode
            }
        }
        openChooseOrgSelect(paraArr);
    }

    //重新上传AI
    function resendToAi() {
        var rowsData = $('#tsDirectoryConfigList').datagrid('getSelections');
        if (!rowsData || rowsData.length != 1) {
            tip('请选择一条记录');
            return;
        }
        var businessId = rowsData[0].id;
        $.ajax({
            async : false,
            cache : false,
            type : 'POST',
            data:{businessId:businessId},
            url : '../tpm/tsSendToAiController/resendToAiByBusinessId',// 请求的action路径
            success : function(data) {
                var d = $.parseJSON(data);
                tip(d.msg);
            }
        });
    }
    function stop(){
        var rows = $("#tsDirectoryConfigList").datagrid("getSelected");
        if(rows == null || rows.length == 0){
            tip("请选择一条数据","error");
            return false;
        }
        if(rows.status == 0){
            tip("该数据已是无效状态","error");
            return false;
        }
        $.ajax({
            async : false,
            cache : false,
            type : 'POST',
            data:{status:'003',id:rows.id},
            url : "/sfaapi/tsDirectoryInputController/updateStatus",// 请求的action路径
            success : function(data) {
                var d = $.parseJSON(data);
                if (d.success) {
                    tip("修改成功","info");
                    $("#tsDirectoryConfigList").datagrid("reload");
                }else{
                    tip(d.msg,"error");
                }
            }
        });
    }

    function toExcel(){
        var title = '是否导出图片？';
        $.dialog.confirm(title, function(){
            var errMsg = validatePhotoSize("/sfaapi/tsDirectoryInputController/validatePhotoSize","tsDirectoryConfigList")
            if(errMsg!="S"){
                tip(errMsg);
                return ;
            }
            excelExport("/sfaapi/tsDirectoryInputController/exportXls&flag=1","tsDirectoryConfigList");
        }, function(){
            excelExport("/sfaapi/tsDirectoryInputController/exportXls&flag=0","tsDirectoryConfigList");
        });
    }

    function toLastExcel(){
        var title = '是否导出图片？';
        $.dialog.confirm(title, function(){
            excelExport("/sfaapi/tsDirectoryInputController/exportLastXls&flag=1","tsDirectoryConfigList");
        }, function(){
            excelExport("/sfaapi/tsDirectoryInputController/exportLastXls&flag=0","tsDirectoryConfigList");
        });
    }

    /**
     * 验证照片数量 代入查询条件
     */
    function validatePhotoSize(url, datagridId) {
        var queryParams = $('#' + datagridId).datagrid('options').queryParams;
        $('#' + datagridId + 'tb_r').find('*').each(function() {
            queryParams[$(this).attr('name')] = $(this).val();
        });
        var params = '&';
        $.each(queryParams, function(key, val) {
            params += '&' + key + '=' + encodeURIComponent(val);
        });
        var fields = '&field=';
        $.each($('#' + datagridId).datagrid('options').columns[0], function(i, val) {
            if (val.field != 'opt') {
                fields += val.field + ',';
            }
        });
        var tagetUrl = url;
        //菜单id
        var accessEntry=$("#accessEntry").val();
        if(accessEntry!=null&&accessEntry!=""&&accessEntry!=undefined){
            tagetUrl+="&accessEntry="+accessEntry;
        }
        var finalUrl = tagetUrl + (fields + params);
        var errorMsg = "";
        $.ajax({
            async : false,
            cache : false,
            type : 'POST',
            url : finalUrl,// 请求的action路径
            success : function(data) {
                var d = $.parseJSON(data);
                if (d.success) {
                    errorMsg = "S";
                }else{
                    errorMsg = d.msg;
                }
            }
        });
        return errorMsg;
    }


    function excelExport(url, datagridId) {
        var queryParams = $('#' + datagridId).datagrid('options').queryParams;
        $('#' + datagridId + 'tb').find('*').each(function() {
            queryParams[$(this).attr('name')] = $(this).val();
        });
        var params = '&';
        $.each(queryParams,
            function(key, val) {
                params += '&' + key + '=' + val;
            });
        var fields = '&field=';
        $.each($('#' + datagridId).datagrid('options').columns[0],
            function(i, val) {
                if (val.field != 'opt') {
                    fields += val.field + ',';
                }
            });

        // http://127.0.0.1:8080/eisp/dataSourceController/goDruid
        var curWwwPath = window.document.location.href;
// /eisp/dataSourceController/goDruid
        var pathName = window.document.location.pathname;
        var pos = curWwwPath.indexOf(pathName);
// http://127.0.0.1:8080
        var localhostPath = curWwwPath.substring(0,pos);
// /eisp
        var projectName = pathName.substring(0,pathName.substr(1).indexOf('/')+1);
// http://127.0.0.1:8080/eisp
        var realPath = localhostPath + projectName +"/"+ url;
        window.open(realPath + encodeURI(fields + params),"_blank");
    }
</script>
<script type="text/javascript"  src="resources/api/mdm/js/tmSelectMain.js"></script>
