<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker,autocomplete"></t:base>
<div id="ware_List" class="easyui-layout" fit="true">
    <div region="center" style="padding: 1px;">
        <t:datagrid name="wareList" tagConf="${clickFunctionId}" controllerTarget="mdmWareController"
                    methedTarget="findTmWarePage" idField="id" queryMode="group" fit="true" fitColumns="true"
                    actionUrl="/kernel/mdmWareController/findTmWarePage?clickFunctionId=${clickFunctionId}"
                    pagination="true">
            <t:dgCol title="主键" field="id" hidden="true"></t:dgCol>
            <t:dgCol title="商品编码" field="wareCode" query="true"></t:dgCol>
            <t:dgCol title="商品名称" field="wareName" query="true"></t:dgCol>
            <t:dgCol title="条形编码" field="barCode" query="true"></t:dgCol>
            <t:dgCol title="产品层级编码" field="productLevelCode" hidden="true"></t:dgCol>
            <t:dgCol title="产品层级名称" field="productLevelName" hidden="true"></t:dgCol>
            <t:dgCol title="销售单位" field="saleUnit" dictionary="sale_unit" query="true"></t:dgCol>
            <t:dgCol title="计量单位" field="meterUnit" dictionary="meter_unit" query="true"></t:dgCol>
            <t:dgCol title="规格" field="specification" query="true"></t:dgCol>
            <t:dgCol title="任务标记" field="isMarketMateriel" dictionary="is_no"></t:dgCol>
            <t:dgCol title="返利标记" field="rebateStatus" query="true" dictionary="is_no"></t:dgCol>
            <t:dgCol title="生效状态" field="enableStatus" query="true" dictionary="enable_status"></t:dgCol>
            <t:dgCol title="删除标记" field="deleteStatus" dictionary="is_no"></t:dgCol>
            <t:dgCol title="上架状态" field="shelfStatus" dictionary="is_no"></t:dgCol>
            <t:dgCol title="自定义价" field="scopePrice" hidden="true"></t:dgCol>
            <t:dgCol title="开始时间" field="beginTime"></t:dgCol>
            <t:dgCol title="结束时间" field="endTime"></t:dgCol>
            <t:dgCol title="最近操作人" field="updateName"></t:dgCol>
            <t:dgCol title="最近操作时间" field="updateDate" formatter="yyyy-MM-dd hh:mm:ss"></t:dgCol>
            <t:dgCol title="extChar1" field="extChar1" hidden="true"></t:dgCol>
            <t:dgCol title="extChar2" field="extChar2" hidden="true"></t:dgCol>
            <t:dgCol title="extChar3" field="extChar3" hidden="true"></t:dgCol>
            <t:dgCol title="extChar4" field="extChar4" hidden="true"></t:dgCol>
            <t:dgCol title="extChar5" field="extChar5" hidden="true"></t:dgCol>
            <t:dgCol title="extChar6" field="extChar6" hidden="true"></t:dgCol>
            <t:dgCol title="extChar7" field="extChar7" hidden="true"></t:dgCol>
            <t:dgCol title="extChar8" field="extChar8" hidden="true"></t:dgCol>
            <t:dgCol title="extChar9" field="extChar9" hidden="true"></t:dgCol>
            <t:dgCol title="extChar10" field="extChar10" hidden="true"></t:dgCol>
            <t:dgToolBar operationCode="add" title="新增" icon="icon-add" width="1300" height="600" url=""
                         onclick="goForm(0)"></t:dgToolBar>
            <t:dgToolBar operationCode="edit" title="编辑" icon="icon-edit" width="1300" height="600" url=""
                         onclick="goForm(1)"></t:dgToolBar>
            <t:dgToolBar operationCode="look" title="查看" icon="icon-edit" width="1300" height="600" url=""
                         onclick="goForm(2)"></t:dgToolBar>
            <t:dgToolBar title="启用" operationCode="start" icon="icon-start" url="/kernel/mdmWareController/startOrStop"
                         onclick="changeStatus('009')"></t:dgToolBar>
            <t:dgToolBar title="停用" operationCode="stop" icon="icon-stop" url="/kernel/mdmWareController/startOrStop"
                         onclick="changeStatus('003')"></t:dgToolBar>
            <t:dgToolBar title="删除" operationCode="remove" icon="icon-remove"
                         url="/kernel/mdmWareController/deleteWareProduct"
                         funname="deleteALLSelect"></t:dgToolBar>
            <t:dgToolBar title="导出" operationCode="dataOut" icon="icon-dataOut"
                         url="/kernel/commonExcelController/excel" excelName="商品信息" excelSheetName="商品信息" funname="excelCommonExport"></t:dgToolBar>
            <t:dgToolBar title="日志" operationCode="log" icon="icon-log" url="/page/knlLogController/goShowLog"
                         width="1000" height="500" funname="detail"></t:dgToolBar>

        </t:datagrid>
    </div>
</div>
<script>
    //启用停用
    function changeStatus(flag) {
        var tmUseTarget = $("#wareList").datagrid('getSelected');
        if (tmUseTarget == null) {
            tip("请选择一条要操作的数据", "error");
            return;
        }
        var tipmMsg = "确定进行当前操作吗";

        $.messager.confirm('操作提示', tipmMsg, function (r) {
            if (r) {
                $.ajax({
                    type: "POST",
                    url: "/kernel/mdmWareController/startOrStop",
                    data: {
                        "id": tmUseTarget.id,
                        "enableStatus": flag
                    },
                    dataType: "json",
                    success: function (data) {
                        tip(data.msg, "info");
                        $("#wareList").datagrid('reload');
                    },
                    error: function () {
                        tip("服务器异常，请稍后再试", "error");
                    }
                });
            }
        });
    }

    var datagrid = $('#wareList');

    /**
     * 跳转表单
     * @param isView 是否查看模式
     */
    function goForm(isView) {
        var rows = datagrid.datagrid('getSelections');

        if (isView == 0) {
            var formUrl = "/page/tmWareController/goTmWareForm?isView=" + isView + "&clickFunctionId=${clickFunctionId}";

            createwindowExt("新增", formUrl, 1000, 600, {
                id: 'productForm',
                okVal: '保存',
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    $('#btn_sub', iframe.document).click();
                    return false;
                }
            })
        } else if (isView == 1) {
            if (!rows || rows.length === 0) {
                tip("请选择一行");
                return false;
            }
            if (rows.length > 1) {
                tip("请只选择一行进行查看或修改");
                return false;
            }
            var row = rows[0];
            var formUrl = "/page/tmWareController/goTmWareForm?id=" + row.id + "&isView=" + isView + "&clickFunctionId=${clickFunctionId}";
            createwindowExt("修改", formUrl, 1000, 600, {
                id: 'productForm',
                okVal: '保存',
                ok: function () {
                    var iframe = this.iframe.contentWindow;
                    $('#btn_sub', iframe.document).click();
                    return false;
                }
            })
        } else if (isView == 2) {
            if (!rows || rows.length === 0) {
                tip("请选择一行");
                return false;
            }
            if (rows.length > 1) {
                tip("请只选择一行进行查看或修改");
                return false;
            }
            var row = rows[0];
            var formUrl = "/page/tmWareController/goTmWareForm?id=" + row.id + "&isView=" + isView + "&clickFunctionId=${clickFunctionId}";

            createwindowExt("查看", formUrl, 1000, 600, {
                ok: false
            })
        }
    }
</script>