<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0,maximum-scale=1.0, user-scalable=0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>移动审批</title>
    <link rel="stylesheet" href="/resources/sfa/css/normalize.css">
    <link rel="stylesheet" href="/resources/sfa/css/flex.css">
    <link rel="stylesheet" href="/resources/sfa/css/spacing.css">
    <link rel="stylesheet" href="/resources/sfa/css/common.css">
    <link rel="stylesheet" href="/resources/sfa/fontawesome/css/font-awesome.min.css">
    <style>
        body {
            background: #f3f3f3;
        }
        .list-cell .badge-num{
            background: #ff0000;
            color: #fff;
            border-radius: 10px;
            font-size: 14px;
            padding: 0 6px;
            min-width: 20px;
            height: 20px;
            line-height: 20px;
        }
    </style>
</head>

<body>
<div id="app" v-cloak>
    <div class="mt20">
        <list-cell title="处理" :value="dealNum" link badge @click="handleDeal"></list-cell>
    </div>
    <div class="mt20">
        <list-cell title="抄送" link @click="handleCopy"></list-cell>
    </div>
</div>

<script src="/resources/sfa/js/vue.min.js"></script>
<script src="/resources/sfa/js/common.js"></script>
<script src="/resources/sfa/js/jquery.min.js"></script>

<script>
    function onJsJumpWithUrl(url) {
        js.onJsJumpWithUrl(url);
    }

    var vm = new Vue({
        el: "#app",
        name: "approve",
        data: function () {
            return {
                token: "",
                dealNum: 0
            }
        },
        created: function () {
            this.token = getParameterByName("token");
            this.loadData();
        },
        computed: {},
        methods: {
            loadData: function () {
                let this_ = this;
                $.ajax({
                    url: '/activiti/taTaskController/findMyTaskList?page=1&rows=5',
                    contentType: "application/json",
                    data: JSON.stringify({}),
                    headers: {
                        'loginUserToken': this_.token
                    },
                    type: "post",
                    dataType: "json",
                    success: function (res) {
                        if (res.success) {
                            this_.dealNum = res.total;
                        }
                    }, error: function (error) {

                    }
                })
            },
            handleDeal: function () {
                let url = "/page/sfaWebController/approveDeal";
                var u = navigator.userAgent;
                var isAndroid = u.indexOf('Android') > -1 || u.indexOf('Adr') > -1; //android终端
                var isiOS = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/); //ios终端
                if (isAndroid) {
                    onJsJumpWithUrl(url);
                }
                if (isiOS) {
                    window.webkit.messageHandlers.onJsJumpWithUrl.postMessage(url);
                }
            },
            handleCopy:function(){
                let url = "/page/sfaWebController/approveCopy";
                var u = navigator.userAgent;
                var isAndroid = u.indexOf('Android') > -1 || u.indexOf('Adr') > -1; //android终端
                var isiOS = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/); //ios终端
                if (isAndroid) {
                    onJsJumpWithUrl(url);
                }
                if (isiOS) {
                    window.webkit.messageHandlers.onJsJumpWithUrl.postMessage(url);
                }
            }
        }
    })
</script>
</body>

</html>