<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0,maximum-scale=1.0, user-scalable=0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>流程审批</title>
    <link rel="stylesheet" href="/resources/sfa/css/normalize.css">
    <link rel="stylesheet" href="/resources/sfa/css/flex.css">
    <link rel="stylesheet" href="/resources/sfa/css/spacing.css">
    <link rel="stylesheet" href="/resources/sfa/css/common.css">
    <link rel="stylesheet" href="/resources/sfa/css/mescroll.min.css">
    <style>
        body {
            background: #f3f3f3;
        }

        .tabbar {
            box-sizing: border-box;
            border-bottom: 1px solid #ddd;
            height: 40px;
        }

        .tabbar-item span {
            box-sizing: content-box;
            display: inline-block;
            border-bottom-width: 2px;
            border-bottom-style: solid;
            border-bottom-color: transparent;
        }

        .tabbar-item span.active {
            color: #1890ff;
            border-bottom-color: #1890ff;
        }

        .search-bar {
            height: 40px;
            padding: 0 10px;
            margin: 10px 0;
            width: 100%;
            box-sizing: border-box;
            position: absolute;
            top: 40px;
            z-index: 50;
        }

        .search-input {
            width: 100%;
            position: relative;
        }

        .search-input>input {
            width: 100%;
            box-sizing: border-box;
            border: 1px solid #eee;
            height: 35px;
            line-height: 35px;
            border-radius: 5px;
            font-size: 14px;
            padding: 0 10px 0 30px;
            outline: none;
        }

        .search-button {
            width: 100%;
            box-sizing: border-box;
            border: none;
            height: 35px;
            line-height: 35px;
            padding: 0;
            margin: 0;
            border-radius: 5px;
            font-size: 14px;
            outline: none;
            background: #1890ff;
            color: #fff;
        }

        .search-button:active {
            opacity: .8;
        }

        .search-icon {
            position: absolute;
            left: 10px;
            top: 7px;
        }

        .search-icon>span {
            color: #aaa;
        }

        .list-wrapper {
            height: calc(100vh - 80px);
            overflow-y: hidden;
        }

        .list-content {
            list-style: none;
            padding: 0 10px;
            margin: 0;
            box-sizing: border-box;
        }

        .list-item {
            margin-bottom: 10px;
            padding: 10px;
            font-size: 14px;
            color: #333333;
            background: #ffffff;
            border-radius: 5px;
        }

        .list-item-title {
            width: 100%;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
            font-weight: 600;
        }

        .item-label {
            font-weight: 600;
        }

        .item-value {
            color: #666666;
        }

        .mescroll {
            position: fixed;
            top: 95px;
            bottom: 0;
            height: auto;
        }
    </style>
</head>

<body>
    <div id="app" v-cloak>
        <div class="tabbar flex flex-align-items-center">
            <div class="tabbar-item flex-1 text-center">
                <span @click="handleTab('wait')" class="p5" :class="active==='wait'?'active':''">待处理</span>
            </div>
            <div class="tabbar-item flex-1 text-center p5">
                <span @click="handleTab('deal')" class="p5" :class="active==='deal'?'active':''">已处理</span>
            </div>
        </div>
        <div v-if="active=='wait'">
            <div class="search-bar">
                <form @submit.prevent="handleSearch">
                    <div class="search-input">
                        <input type="text" v-model="waitParams.processDefinitionName" placeholder="请输入流程名称">
                        <div class="search-icon">
                            <span class="fa fa-search"></span>
                        </div>
                    </div>
                </form>
            </div>
            <div ref="wrapper" class="mescroll">
                <ul class="list-content">
                    <li @click="clickItem(item)" class="list-item" v-for="item in waitList" :key="item.id">
                        <div class="list-item-title pv5">{{item.createUserName}}</div>
                        <div class="pv5">
                            <span class="item-label">流程主题：</span>
                            <span class="item-value">{{item.processTitle}}</span>
                        </div>
                        <div class="pv5">
                            <span class="item-label">流程名称：</span>
                            <span class="item-value">{{item.processDefinitionName}}</span>
                        </div>
                        <div class="pv5">
                            <span class="item-label">流程编号：</span>
                            <span class="item-value">{{item.processInstanceId}}</span>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
        <div v-else>
            <div class="search-bar">
                <div class="search-input">
                    <input type="text" v-model="dealParams.processDefinitionName" placeholder="请输入流程名称">
                </div>
                <div class="search-input mt5">
                    <input type="text" v-model="dealParams.processTitle" placeholder="请输入流程主题">
                </div>
                <div class="search-input mt5">
                    <input type="text" v-model="dealParams.createUserName" placeholder="请输入发起人">
                </div>
                <div class="search-input mt5">
                    <button class="search-button" @click="handleDealSearch">查询</button>
                </div>
            </div>
            <div ref="wrapper" class="mescroll" style="top:215px;">
                <ul class="list-content">
                    <li @click="clickItemDeal(item)" class="list-item" v-for="item in dealList" :key="item.id">
                        <div class="list-item-title pv5">{{item.createUserName}}</div>
                        <div class="pv5">
                            <span class="item-label">流程主题：</span>
                            <span class="item-value">{{item.processTitle}}</span>
                        </div>
                        <div class="pv5">
                            <span class="item-label">流程名称：</span>
                            <span class="item-value">{{item.processDefinitionName}}</span>
                        </div>
                        <div class="pv5">
                            <span class="item-label">流程编号：</span>
                            <span class="item-value">{{item.processInstanceId}}</span>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    <script src="/resources/sfa/js/vue.min.js"></script>
    <script src="/resources/sfa/js/common.js"></script>
    <script src="/resources/sfa/js/jquery.min.js"></script>
    <script src="/resources/sfa/js/mescroll.min.js"></script>

    <script>
        function onJsJumpWithUrl(url) {
            js.onJsJumpWithUrl(url);
        }
        var vm = new Vue({
            el: "#app",
            name: "",
            data: function () {
                return {
                    token: "",
                    active: 'wait',
                    waitParams: {
                        page: 1,
                        rows: 10,
                        processDefinitionName: ""
                    },
                    dealParams: {
                        page: 1,
                        rows: 10,
                        processDefinitionName: "",
                        processTitle:"",
                        createUserName:""
                    },
                    waitList: [],
                    dealList: [],
                    scroll: null
                }
            },
            created: function () {
                this.token = getParameterByName("token");
                this.loadWaitData(false);
            },
            mounted() {
                let this_ = this;
                setTimeout(function () {
                    this_.scroll = new MeScroll(this_.$refs.wrapper, {
                        down: {
                            callback: this_.downCallback
                        },
                        up: {
                            callback: this_.upCallback,
                            scrollbar: false
                        }
                    });
                }, 20)
            },
            computed: {

            },
            methods: {
                handleTab:function(type) {
                    this.active = type;
                    this.active==="wait"?this.loadWaitData():this.loadDealData();
                },
                downCallback: function () {
                    if(this.active==="wait"){
                        this.waitParams.page = 1;
                        this.loadWaitData()
                    }else{
                        this.dealParams.page = 1;
                        this.loadDealData()
                    }
                },
                upCallback: function (page, mescroll) {
                    if(this.active==="wait"){
                        this.waitParams.page = page.num;
                        this.loadWaitData()
                    }else{
                        this.dealParams.page = page.num;
                        this.loadDealData()
                    }
                },
                handleSearch: function () {
                    this.waitParams.page = 1;
                    this.loadWaitData();
                },
                handleDealSearch:function(){
                    this.dealParams.page = 1;
                    this.loadDealData();
                },
                loadWaitData:function() {
                    var this_ = this;
                    $.ajax({
                        url: SERVER + "/activiti/taTaskController/findMyTaskList",
                        type: "post",
                        data: this.waitParams,
                        dataType: "json",
                        contentType: "application/x-www-form-urlencoded",
                        headers: {
                            'loginUserToken': this_.token
                        },
                        success: function (res) {
                            if (res.success) {
                                if (this_.waitParams.page > 1) {
                                    this_.waitList = this_.waitList.concat(res.rows || []);
                                    this_.scroll && this_.scroll.endByPage(res
                                        .rows.length, res.total)
                                } else {
                                    this_.waitList = res.rows || [];
                                    this_.scroll && this_.scroll.endByPage(res
                                        .rows.length, res.total)
                                }
                            } else {
                                showError(res.msg)
                                this_.scroll && this_.scroll.endErr();
                            }
                        },
                        error: function (error) {
                            this_.scroll && this_.scroll.endErr();
                        }
                    })
                },
                loadDealData:function() {
                    var this_ = this;
                    $.ajax({
                        url: SERVER + "/activiti/taTaskController/findMyHistoryTaskList",
                        type: "post",
                        data: this.dealParams,
                        dataType: "json",
                        contentType: "application/x-www-form-urlencoded",
                        headers: {
                            'loginUserToken': this_.token
                        },
                        success: function (res) {
                            if (res.success) {
                                if (this_.dealParams.page > 1) {
                                    this_.dealList = this_.dealList.concat(res.rows || []);
                                    this_.scroll && this_.scroll.endByPage(res
                                        .rows.length, res.total)
                                } else {
                                    this_.dealList = res.rows || [];
                                    this_.scroll && this_.scroll.endByPage(res
                                        .rows.length, res.total)
                                }
                            } else {
                                showError(res.msg)
                                this_.scroll && this_.scroll.endErr();
                            }
                        },
                        error: function (error) {
                            this_.scroll && this_.scroll.endErr();
                        }
                    })
                },
                clickItem:function(item) {
                    let url = "/page/sfaWebController/approveDetail?taskId="+item.taskId+"&processInstanceId="+item.processInstanceId;
                    var u = navigator.userAgent;
                    var isAndroid = u.indexOf('Android') > -1 || u.indexOf('Adr') > -1; //android终端
                    var isiOS = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/); //ios终端
                    if (isAndroid) {
                        onJsJumpWithUrl(url);
                    }
                    if (isiOS) {
                        window.webkit.messageHandlers.onJsJumpWithUrl.postMessage(url);
                    }
                },
                clickItemDeal:function(item) {
                    let url = "/page/sfaWebController/approveDetail?taskId="+item.id+"&processInstanceId="+item.processInstanceId+"&isView=true";
                    var u = navigator.userAgent;
                    var isAndroid = u.indexOf('Android') > -1 || u.indexOf('Adr') > -1; //android终端
                    var isiOS = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/); //ios终端
                    if (isAndroid) {
                        onJsJumpWithUrl(url);
                    }
                    if (isiOS) {
                        window.webkit.messageHandlers.onJsJumpWithUrl.postMessage(url);
                    }
                }
            }
        })
    </script>
</body>

</html>