<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>客户详情</title>
    <link rel="stylesheet" href="/resources/sfa/css/normalize.css">
    <link rel="stylesheet" href="/resources/sfa/css/flex.css">
    <link rel="stylesheet" href="/resources/sfa/css/spacing.css">
    <link rel="stylesheet" href="/resources/sfa/css/common.css">
</head>

<body>
    <div id="app" v-cloak>
        <!-- 客户 -->
        <div class="customer-info" v-if="clientType=='01'">
            <list-info title="客户编码" :value="customer.customerCode"></list-info>
            <list-info title="客户名称" :value="customer.customerName"></list-info>
            <list-info title="客户类型" :value="customer.customerType"></list-info>
            <list-info title="客户级别" :value="customer.extChar16"></list-info>
            <list-info title="渠道类型" :value="customer.channelType"></list-info>
            <list-info title="联系人" :value="customer.linkman"></list-info>
            <list-info title="联系电话" :value="customer.linkmanPhone"></list-info>
            <list-info title="省" :value="customer.province"></list-info>
            <list-info title="市" :value="customer.city"></list-info>
            <list-info title="区县" :value="customer.area"></list-info>
            <list-info title="详细地址" :value="customer.address"></list-info>
            <list-info title="对接人" :value="customer.dockUserName"></list-info>
            <list-info title="启用状态" :value="customer.enableStatus"></list-info>
        </div>
        <!-- 终端 -->
        <div class="customer-info" v-if="clientType=='02'">
            <list-info title="终端编码" :value="customer.terminalCode"></list-info>
            <list-info title="终端名称" :value="customer.terminalName"></list-info>
            <list-info title="终端类型" :value="customer.terminalType"></list-info>
            <list-info title="终端渠道" :value="customer.channelType"></list-info>
            <list-info title="联系人" :value="customer.linkman"></list-info>
            <list-info title="联系人电话" :value="customer.linkmanPhone"></list-info>
            <list-info title="所属经销商编码" :value="customer.customerCode"></list-info>
            <list-info title="所属经销商名称" :value="customer.customerName"></list-info>
            <list-info title="所属组织" :value="customer.orgName"></list-info>
            <list-info title="国家" :value="customer.province"></list-info>
            <list-info title="省" :value="customer.province"></list-info>
            <list-info title="市" :value="customer.city"></list-info>
            <list-info title="区县" :value="customer.area"></list-info>
            <list-info title="终端地址" :value="customer.address"></list-info>
            <list-info title="对接人" :value="customer.dockUserName"></list-info>
            <list-info title="启用状态" :value="customer.enableStatus"></list-info>
            <list-info title="合作状态" :value="customer.cooperative"></list-info>
        </div>
    </div>

    <script src="/resources/sfa/js/vue.min.js"></script>
    <script src="/resources/sfa/js/common.js"></script>
    <script src="/resources/sfa/js/jquery.min.js"></script>

    <script>
        var vm = new Vue({
            el: "#app",
            name: "",
            data: function () {
                return {
                    token: "",
                    clientId: "",
                    clientType: "",
                    customer: {}
                }
            },
            created: function () {
                this.token = getParameterByName("token");
                this.clientId = getParameterByName("clientId");
                this.clientType = getParameterByName("clientType");
                this.loadData();
            },
            computed: {

            },
            methods: {
                loadData: function () {
                    var this_ = this;
                    $.ajax({
                        url: SERVER +
                            "/sfaapi/sfaApi/tsClientController/getClientDetail",
                        type: "post",
                        dataType: "json",
                        contentType: 'application/json',
                        headers: {
                            'loginUserToken': this_.token
                        },
                        data: JSON.stringify({
                            clientId: this_.clientId,
                            clientType: this_.clientType,
                        }),
                        success: function (res) {
                            if (res.success) {
                                this_.customer = res.obj;
                            }else{
                                showError(res.msg)
                            }
                        }
                    })
                },
            }
        })
    </script>
</body>

</html>