<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>产品详情</title>
    <link rel="stylesheet" href="/resources/sfa/css/normalize.css">
    <link rel="stylesheet" href="/resources/sfa/fontawesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="/resources/sfa/css/flex.css">
    <link rel="stylesheet" href="/resources/sfa/css/spacing.css">
    <link rel="stylesheet" href="/resources/sfa/css/common.css">
    <style>
        body {
            background: #f3f3f3;
        }

        .product-img {
            background: #ffffff;
        }

        .product-img img {
            width: 100%;
            height: auto;
        }

        .product-title {
            padding: 16px;
        }

        .product-favorites {
            border-left: 1px solid #ebedf0;
            padding-left: 10px;
        }

        .product-favorites span {
            color: #969799;
            font-size: 14px;
        }

        .product-favorites span:first-child {
            font-size: 18px;
        }

        .divider {
            margin-top: 20px;
        }

        .divider .divider-line {
            height: 1px;
            width: 0;
            background: #e8e8e8;

        }

        .divider>span {
            color: #333;
            padding: 0 5px;
            font-size: 14px;
        }
    </style>
</head>

<body>
    <div id="app" v-cloak>
        <div class="product-img">
            <img :src="product.tbAttachmentVos[0].urlPath" alt="">
            <div class="product-title flex flex-align-items-center flex-justify-content-between">
                <div>{{product.productInfoName}}</div>
                <div class="product-favorites flex flex-column flex-justify-content-center flex-align-items-center">
                    <span class="fa fa-heart-o"></span><span>收藏</span></div>
            </div>
        </div>
        <div class="product-info mt10">
            <list-cell title="编码" :value="product.productInfoCode"></list-cell>
            <list-cell title="类型" :value="product.productInfoType"></list-cell>
        </div>
    </div>

    <script src="/resources/sfa/js/vue.min.js"></script>
    <script src="/resources/sfa/js/common.js"></script>
    <script src="/resources/sfa/js/jquery.min.js"></script>

    <script>
        var vm = new Vue({
            el: "#app",
            name: "",
            data: function () {
                return {
                    token: "",
                    id: "",
                    product: {}
                }
            },
            created: function () {
                this.token = getParameterByName("token");
                this.id = getParameterByName("id");
                this.loadData();
            },
            computed: {
                productImg: function () {
                    if (this.product.tbAttachmentVos && this.product.tbAttachmentVos.length > 0) {
                        return this.product.tbAttachmentVos[0].realPath;
                    } else {
                        return ""
                    }
                }
            },
            methods: {
                loadData: function () {
                    var this_ = this;
                    $.ajax({
                        url: SERVER +
                            "/sfaapi/sfaApi/orderApiController/getProductInfoDetail?id=" + this_.id,
                        type: "post",
                        dataType: "json",
                        contentType: 'application/x-www-form-urlencoded',
                        headers: {
                            'loginUserToken': this_.token
                        },
                        success: function (res) {
                            if (res.success) {
                                this_.product = res.obj;
                            }else{
                                showError(res.msg)
                            }
                        }
                    })
                },
            }
        })
    </script>
</body>

</html>