<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>数据报表</title>
    <link rel="stylesheet" href="/resources/sfa/css/normalize.css">
    <link rel="stylesheet" href="/resources/sfa/css/flex.css">
    <link rel="stylesheet" href="/resources/sfa/css/spacing.css">
    <link rel="stylesheet" href="/resources/sfa/css/common.css">
    <style>
        body {
            background: #f3f3f3;
            padding: 10px;
            margin: 0;
            box-sizing: border-box;
        }

        .panel {
            border-radius: 5px;
            padding: 10px;
            background: #fff;
            box-sizing: border-box;
        }

        .panel-title {
            font-weight: 600;
        }

        .panel-detail {
            font-size: 14px;
            color: #c5c5c5;
        }

        .panel-label {
            font-size: 14px;
            color: #d8d8d8;
        }

        .panel-tabs {
            font-size: 0;
        }

        .panel-tabs span {
            padding: 0 3px;
            color: #333;
            background: #fff;
            font-size: 14px;
            height: 20px;
            line-height: 20px;
            transition: all .3s;
            display: inline-block;
            border-style: solid;
            border-width: 1px;
            border-color: #c5c5c5;
        }

        .panel-tabs span:first-child {
            border-right: 0;
            border-radius: 3px 0 0 3px;
        }

        .panel-tabs span:last-child {
            border-left: 0;
            border-radius: 0 3px 3px 0;
        }

        .panel-tabs span.active {
            color: #fff;
            background: #0188FB;
            border-color: #0188FB;
        }

        .progress-bar {
            position: relative;
            width: 100%;
            height: 10px;
            border-radius: 10px;
            background: #f3f3f3;
        }

        .progress-bar-active {
            position: absolute;
            left: 0;
            top: -1px;
            width: 15%;
            height: 12px;
            border-radius: 12px;
            background: #0188FB;
            transition: all .3s;
        }

        .range-progress {
            padding: 10px 0;
            box-sizing: border-box;
        }

        .range-progress-label {
            width: 60px;
            padding-right: 10px;
            text-align: right;
            font-size: 14px;
            color: #c5c5c5;
            box-sizing: border-box;
            white-space: nowrap;
        }

        .range-progress-bar {
            position: relative;
            width: 100%;
            height: 10px;
            border-radius: 10px;
            background: #f3f3f3;
        }

        .range-progress-bar-active {
            position: absolute;
            left: 0;
            top: -1px;
            width: 20%;
            height: 12px;
            border-radius: 12px;
            background: #0188FB;
            transition: all .3s;
        }

        .rang-progress-bar-text {
            position: absolute;
            top: -1px;
            right: 5px;
            font-size: 12px;
        }
    </style>
</head>

<body>
    <div id="app" v-cloak>
        <div class="panel goal">
            <div class="flex flex-align-items-center flex-justify-content-between">
                <div class="panel-title">拜访目标</div>
                <div class="panel-detail" @click="handleDetail('goal')">
                    查看详情>
                </div>
            </div>
            <div class="panel-tabs flex flex-justify-content-end mt10">
                <span @click="handleTab('week')" :class="activeTab==='week'?'active':''">本周</span>
                <span @click="handleTab('month')" :class="activeTab==='month'?'active':''">本月</span>
            </div>
            <div class="my-goal mt10">
                <div class="flex flex-align-items-center flex-justify-content-between">
                    <span>我的目标</span>
                    <span>40/180次</span>
                </div>
                <div class="goal-progress mt10">
                    <div class="progress-bar">
                        <div class="progress-bar-active"></div>
                    </div>
                </div>
            </div>
            <div class="group-goal mt10">
                <div class="flex flex-align-items-center flex-justify-content-between">
                    <span>部门目标</span>
                    <span>90/180次</span>
                </div>
                <div class="goal-progress mt10">
                    <div class="progress-bar">
                        <div class="progress-bar-active" style="width: 50%;"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="panel mt10">
            <div class="flex flex-align-items-center flex-justify-content-between">
                <div class="panel-title">客户拜访数量</div>
                <div class="panel-detail" @click="handleDetail('visit')">
                    查看详情>
                </div>
            </div>
            <div>
                <div ref="visitPipe" style="width: 100%;height:200px;box-sizing: border-box;"></div>
            </div>
        </div>
        <div class="panel mt10">
            <div class="flex flex-align-items-center flex-justify-content-between">
                <div class="panel-title">客户新增数量</div>
                <div class="panel-detail" @click="handleDetail('add')">
                    查看详情>
                </div>
            </div>
            <div>
                <div ref="addLine" style="width: 100%;height:200px;box-sizing: border-box;"></div>
            </div>

        </div>
        <div class="panel mt10">
            <div class="flex flex-align-items-center flex-justify-content-between">
                <div class="panel-title">考勤分析</div>
                <div class="panel-detail" @click="handleDetail('attendance')">
                    查看详情>
                </div>
            </div>
            <div class="panel-label  flex flex-justify-content-end mt10">
                今日实到2人/100人
            </div>
            <div class="attendance-progress flex">
                <div class="flex-1">
                    <div class="range-progress flex flex-align-items-center">
                        <div class="range-progress-label flex-none">
                            请假
                        </div>
                        <div class="range-progress-bar flex-auto">
                            <div class="range-progress-bar-active" style="width:1%"></div>
                            <div class="rang-progress-bar-text">1人</div>
                        </div>
                    </div>
                    <div class="range-progress flex flex-align-items-center">
                        <div class="range-progress-label flex-none">
                            出差
                        </div>
                        <div class="range-progress-bar flex-auto">
                            <div class="range-progress-bar-active" style="width:5%"></div>
                            <div class="rang-progress-bar-text">5人</div>
                        </div>
                    </div>
                </div>
                <div class="flex-1">
                    <div class="range-progress flex flex-align-items-center">
                        <div class="range-progress-label flex-none">
                            签到
                        </div>
                        <div class="range-progress-bar flex-auto">
                            <div class="range-progress-bar-active" style="width:92%"></div>
                            <div class="rang-progress-bar-text">92人</div>
                        </div>
                    </div>
                    <div class="range-progress flex flex-align-items-center">
                        <div class="range-progress-label flex-none">
                            未签到
                        </div>
                        <div class="range-progress-bar flex-auto">
                            <div class="range-progress-bar-active" style="width:8%"></div>
                            <div class="rang-progress-bar-text">8人</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="/resources/sfa/js/vue.min.js"></script>
    <script src="/resources/sfa/js/common.js"></script>
    <script src="/resources/sfa/js/jquery.min.js"></script>
    <script src="/resources/sfa/js/echarts.min.js"></script>

    <script>
        function onJsJumpWithUrl(url) {
            js.onJsJumpWithUrl(url);
        }
        var vm = new Vue({
            el: "#app",
            name: "",
            data: function () {
                return {
                    activeTab: "week",
                    visitPipe: null,
                    addLine: "",
                    progress: "10", //客户拜访数量覆盖率
                }
            },
            created: function () {

            },
            mounted: function () {
                this.initVisitPipe();
                this.initAddLine();
            },
            methods: {
                handleTab: function (tab) {
                    this.activeTab = tab;
                },
                initVisitPipe: function () {
                    this.visitPipe = echarts.init(this.$refs.visitPipe);
                    var option = {
                        color: ['#33b62e', '#f3f3f3'],
                        legend: {
                            orient: 'vertical',
                            x: 'right',
                            y: 'center',
                            formatter: function (name) {
                                if (name === "覆盖客户数") {
                                    return name + '3800'
                                }
                                if (name === "未覆盖客户数") {
                                    return name + '10500'
                                }
                            },
                            data: ['覆盖客户数', '未覆盖客户数']
                        },
                        graphic: {
                            elements: [{
                                type: "text",
                                left: "70",
                                top: "center",
                                style: {
                                    text: "覆盖率36%",
                                    textAlign: "center",
                                    fill: "#333",
                                    font: 'bolder 0.8em "Microsoft YaHei", sans-serif'
                                }
                            }]
                        },
                        series: [{
                            name: '',
                            type: 'pie',
                            center: ['100', '50%'],
                            radius: ['50%', '60%'],
                            label: {
                                normal: {
                                    show: false,
                                    position: 'center'
                                }
                            },
                            data: [{
                                    value: 3800,
                                    name: '覆盖客户数',
                                },
                                {
                                    value: 10500,
                                    name: '未覆盖客户数'
                                }
                            ]
                        }]
                    };

                    this.visitPipe.setOption(option);
                },
                initAddLine: function () {
                    this.addLine = echarts.init(this.$refs.addLine);
                    var option = {
                        xAxis: {
                            type: 'category',
                            boundaryGap: false,
                            data: ['08-21', '08-22', '08-23', '08-24', '08-25', '08-26',
                                '08-27'
                            ]
                        },
                        yAxis: {
                            type: 'value'
                        },
                        series: [{
                            data: [100, 500, 200, 150, 110, 800, 100],
                            type: 'line',
                            lineStyle: {
                                color: "#1890ff",
                            },
                            areaStyle: {
                                color: "#ffffff",
                                shadowColor: '#1890ff',
                                shadowBlur: 15
                            }
                        }]
                    };
                    this.addLine.setOption(option);
                },
                handleDetail(page) {
                    let url = "/page/sfaWebController/"+ page;
                    var u = navigator.userAgent;
                    var isAndroid = u.indexOf('Android') > -1 || u.indexOf('Adr') > -1; //android终端
                    var isiOS = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/); //ios终端
                    if(isAndroid){
                        onJsJumpWithUrl(url);
                    }
                    if(isiOS){
                        window.webkit.messageHandlers.onJsJumpWithUrl.postMessage(url);
                    }
                }
            }
        })
    </script>
</body>

</html>