/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.estimate.controller;

import com.biz.eisp.base.ImpExpController;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.vo.ExcelDate;
import com.biz.eisp.estimate.service.TtEstimateExtractService;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.pay.estimate.entity.TtEstimateExtractEntity;
import com.biz.eisp.pay.estimate.vo.TtEstimateExtractVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ttEstimateExtractController"})
public class TtEstimateExtractController
extends ImpExpController {
    @Autowired
    private TtEstimateExtractService ttEstimateExtractService;

    @GetMapping(value={"getTtEstimateExtractEntity"})
    public AjaxJson<TtEstimateExtractEntity> getTtEstimateExtractEntity(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        TtEstimateExtractEntity entity = this.ttEstimateExtractService.getTtEstimateExtractEntity(id);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }

    @RequestMapping(value={"findTtEstimateExtractPage"})
    @ResponseBody
    public DataGrid findTtEstimateExtractPage(HttpServletRequest request, TtEstimateExtractVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<TtEstimateExtractVo> TtEstimateExtractVoPageInfo = this.ttEstimateExtractService.findTtEstimateExtractPage(vo, (Page)page);
        if (TtEstimateExtractVoPageInfo != null) {
            return new DataGrid(TtEstimateExtractVoPageInfo);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"saveOrUpdate"})
    @ResponseBody
    public AjaxJson saveOrUpdate(TtEstimateExtractVo vo) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
                this.ttEstimateExtractService.update(vo);
            } else {
                vo.setEstimateType(ConstantEnum.EstimateExtractEnum.THIRTY.getValue());
                this.ttEstimateExtractService.save(vo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setMsg("\u64cd\u4f5c\u5931\u8d25\uff01");
            j.setSuccess(false);
        }
        return j;
    }

    @ResponseBody
    @RequestMapping(value={"deleteTtEstimateExtract"})
    public AjaxJson deleteTtEstimateExtract(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (!this.ttEstimateExtractService.delete(ids)) {
                j.setSuccess(false);
                j.setMsg("\u5220\u9664\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"feePoolAmountEstimate"})
    @ResponseBody
    public AjaxJson feePoolAmountEstimate() {
        AjaxJson j = new AjaxJson();
        try {
            if (!this.ttEstimateExtractService.feePoolAmountEstimate()) {
                j.setSuccess(false);
                j.setMsg("\u9884\u63d0\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u9884\u63d0\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"applyEstimate"})
    @ResponseBody
    public AjaxJson applyEstimate() {
        AjaxJson j = new AjaxJson();
        try {
            if (!this.ttEstimateExtractService.applyEstimate()) {
                j.setSuccess(false);
                j.setMsg("\u9884\u63d0\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u9884\u63d0\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"contractCostEstimate"})
    @ResponseBody
    public AjaxJson contractCostEstimate() {
        AjaxJson j = new AjaxJson();
        try {
            if (!this.ttEstimateExtractService.contractCostEstimate()) {
                j.setSuccess(false);
                j.setMsg("\u9884\u63d0\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u9884\u63d0\u5931\u8d25");
        }
        return j;
    }

    protected AjaxJson checkImportList(List importList, ExcelDate excelDate) {
        return null;
    }

    protected AjaxJson doImportList(List importList, ExcelDate excelDate) {
        return null;
    }
}

