/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.pay.audit.controller;

import com.biz.eisp.act.act.TtActFeign;
import com.biz.eisp.act.entity.TtActEntity;
import com.biz.eisp.audit.entity.TtAuditActEntity;
import com.biz.eisp.audit.vo.TtAuditActVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.pay.audit.service.TtAuditActService;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

@RestController
@RequestMapping(value={"/ttAuditActController"})
public class TtAuditActController {
    @Autowired
    private TtAuditActService ttAuditActService;
    @Autowired
    private TtActFeign ttActFeign;

    @PostMapping(value={"insertSelective"})
    public AjaxJson insertSelective(@RequestBody TtAuditActEntity actEntity) {
        AjaxJson ajaxJson = new AjaxJson();
        Integer i = this.ttAuditActService.insertSelective(actEntity);
        if (i < 0) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u6dfb\u52a0\u6838\u9500\u5bf9\u5e94\u6d3b\u52a8\u8868\u5931\u8d25");
        }
        return ajaxJson;
    }

    @ResponseBody
    @RequestMapping(value={"findTtAuditActPage"})
    public DataGrid findTtAuditActPage(HttpServletRequest request, TtAuditActVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<TtAuditActVo> info = this.ttAuditActService.findTtAuditActPage(vo, (Page)page);
        if (info != null) {
            return new DataGrid(info);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @ResponseBody
    @RequestMapping(value={"saveAuditAct"})
    public AjaxJson saveAuditAct(HttpServletRequest request, String tempUuid, String acts) {
        AjaxJson j = new AjaxJson();
        this.ttAuditActService.saveAuditAct(tempUuid, acts);
        return j;
    }

    @ResponseBody
    @RequestMapping(value={"delAuditAct"})
    public AjaxJson delAuditAct(HttpServletRequest request, String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)ids)) {
                this.ttAuditActService.delByIds(ids);
            }
        }
        catch (RuntimeException e) {
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        catch (Exception e) {
            j.setSuccess(false);
            e.printStackTrace();
            j.setMsg("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return j;
    }

    @GetMapping(value={"getActCodeByTempId"})
    public AjaxJson<TtAuditActEntity> getActCodeByTempId(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        Example example = new Example(TtAuditActEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("tempUuid", (Object)id);
        List list = this.ttAuditActService.selectExample(example);
        ajaxJson.setList(list);
        return ajaxJson;
    }

    @RequestMapping(value={"getTtActVoByActCode"})
    public AjaxJson<TtActEntity> getTtActVoByActCode(String actCode) {
        AjaxJson ajaxJson = new AjaxJson();
        TtActEntity entity = (TtActEntity)this.ttActFeign.getTtActVoByActCode(actCode).getObj();
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }
}

