/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.reports.service.impl;

import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.act.service.AuditActService;
import com.biz.eisp.act.vo.TtActDetailVo;
import com.biz.eisp.audit.entity.TtAuditActDetailEntity;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.SqlUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.pojo.glob.vo.FeeUseBudgutParam;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.budget.fee.TtBudgetDetailFeign;
import com.biz.eisp.mdm.feign.OperationFeign;
import com.biz.eisp.mdm.vo.OperationAuthobj;
import com.biz.eisp.operation.OperationConfig;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.pay.audit.dao.TtAuditActDetailDao;
import com.biz.eisp.reports.service.ActDetailReportsAuthExpand;
import com.biz.eisp.reports.service.ActDetailReportsService;
import com.biz.eisp.reports.service.EnddepartuseExtend;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ActDetailReportsServiceImpl
implements ActDetailReportsService {
    @Autowired
    private TtAuditActDetailDao ttAuditActDetailDao;
    @Autowired
    private AuditActService auditActService;
    @Autowired
    private TtBudgetDetailFeign ttBudgetDetailFeign;
    @Autowired(required=false)
    private EnddepartuseExtend enddepartuseExtend;
    @Autowired(required=false)
    private ActDetailReportsAuthExpand actDetailReportsAuthExpand;
    @Autowired
    private OperationFeign operationFeign;

    @Override
    public PageInfo<TtActDetailVo> findActDetailReports(TtActDetailVo vo, Page page) {
        List authEntities;
        UserRedis userRedis = UserUtils.getUser();
        StringBuffer buffer = new StringBuffer();
        if (StringUtil.isNotBlank((CharSequence)vo.getClickFunctionId()) && userRedis != null && !Globals.Admin_Name.equals(userRedis.getUsername()) && CollectionUtil.listNotEmptyNotSizeZero((List)(authEntities = ApiResultUtil.listResult((AjaxJson)this.operationFeign.findListByFunidAndFuncode(vo.getClickFunctionId(), Globals.VIEW), (boolean)true)))) {
            buffer.append(" and (");
            List authobjs = ApiResultUtil.listResult((AjaxJson)this.operationFeign.findAuthobjUserAndFunIdAndFuncode(userRedis.getId(), vo.getClickFunctionId(), Globals.VIEW), (boolean)true);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)authobjs)) {
                if (!OperationConfig.checAll((List)authobjs)) {
                    String expandSql;
                    String temp;
                    Map<Object, Object> auValMap;
                    List items;
                    HashMap<String, List<OperationAuthobj>> auMap = new HashMap<String, List<OperationAuthobj>>();
                    authobjs.stream().collect(Collectors.groupingBy(OperationAuthobj::getAuthobj, Collectors.toList())).forEach((parentId, list) -> auMap.put((String)parentId, (List<OperationAuthobj>)list));
                    boolean flagOr = false;
                    if (auMap.containsKey("org")) {
                        flagOr = true;
                        buffer.append(" (");
                        items = (List)auMap.get("org");
                        auValMap = new HashMap();
                        auValMap = items.stream().collect(Collectors.toMap(OperationAuthobj::getAuthobjValue, item -> item));
                        if (auValMap.containsKey("20")) {
                            List codes = ApiResultUtil.listResult((AjaxJson)this.operationFeign.getOrgCodesDownByUser(userRedis.getId(), userRedis.getUsername()), (boolean)true);
                            temp = SqlUtil.setSqlIn500((List)codes, (String)"detail.org_code", (boolean)true);
                            buffer.append(temp);
                        } else if (auValMap.containsKey("30")) {
                            buffer.append(" detail.org_code = '" + userRedis.getOrgCode() + "' ");
                        }
                        buffer.append(")");
                    }
                    if (auMap.containsKey("position")) {
                        if (flagOr) {
                            buffer.append(" or ");
                        }
                        flagOr = true;
                        buffer.append(" (");
                        items = (List)auMap.get("position");
                        auValMap = new HashMap();
                        auValMap = items.stream().collect(Collectors.toMap(OperationAuthobj::getAuthobjValue, item -> item));
                        if (auValMap.containsKey("40")) {
                            List posCode = ApiResultUtil.listResult((AjaxJson)this.operationFeign.findAllPosCodeByUser(userRedis.getId(), userRedis.getUsername(), Integer.valueOf(1)), (boolean)true);
                            if (!CollectionUtil.listNotEmptyNotSizeZero((List)posCode)) {
                                posCode.add("_");
                            }
                            temp = SqlUtil.setSqlIn500((List)posCode, (String)"detail.position_code", (boolean)true);
                            buffer.append(temp);
                        } else if (auValMap.containsKey("50")) {
                            buffer.append("  detail.position_code = '" + userRedis.getPosCode() + "' ");
                        }
                        buffer.append(")");
                    }
                    if (Objects.nonNull(this.actDetailReportsAuthExpand) && StringUtil.isNotEmpty((CharSequence)(expandSql = this.actDetailReportsAuthExpand.buildSql(auMap, userRedis, flagOr, buffer)))) {
                        buffer.append(expandSql);
                    }
                } else {
                    buffer.append(" 1=1");
                }
            } else {
                buffer.append("1=2");
            }
            buffer.append(" ) ");
        }
        String aUsql = buffer.toString();
        return PageAutoHelperUtil.generatePage(() -> this.ttAuditActDetailDao.findActDetailReports(vo, aUsql), (Page)page);
    }

    @Override
    public AjaxJson endAudit(List<String> actDetailCodes) {
        AjaxJson ajaxJson = new AjaxJson();
        if (!CollectionUtil.listNotEmptyNotSizeZero(actDetailCodes)) {
            ajaxJson.setErrMsg("\u9009\u62e9\u6570\u636e\u4e0d\u5b58\u5728");
            return ajaxJson;
        }
        List<TtActDetailEntity> detailEntities = this.auditActService.getDetailList(actDetailCodes);
        if (!CollectionUtil.listNotEmptyNotSizeZero(detailEntities)) {
            ajaxJson.setErrMsg("\u9009\u62e9\u6570\u636e\u4e0d\u5b58\u5728");
            return ajaxJson;
        }
        this.checkEndAudit(detailEntities, actDetailCodes, ajaxJson);
        if (!ajaxJson.isSuccess()) {
            return ajaxJson;
        }
        ArrayList<FeeUseBudgutParam> feeUseBudgutParams = new ArrayList<FeeUseBudgutParam>();
        ArrayList<TtActDetailEntity> updateList = new ArrayList<TtActDetailEntity>();
        for (TtActDetailEntity item2 : detailEntities) {
            FeeUseBudgutParam feeUseBudgutParam = new FeeUseBudgutParam();
            BigDecimal auditAmount = item2.getAuditAmount() == null ? BigDecimal.ZERO : item2.getAuditAmount();
            feeUseBudgutParam.setAmount(item2.getAmount().subtract(auditAmount));
            feeUseBudgutParam.setType(ConstantEnum.BudgetUesdTypeEnum.BACK.getValue());
            feeUseBudgutParam.setBusinessCode(item2.getActCode());
            feeUseBudgutParam.setBusinessCodeAttached(item2.getActDetailCode());
            feeUseBudgutParams.add(feeUseBudgutParam);
            TtActDetailEntity updateEntity = new TtActDetailEntity();
            updateEntity.setId(item2.getId());
            updateEntity.setAuditStatus(TtActDetailEntity.AUDITSTATUS.COMPLETE.getCode());
            updateList.add(updateEntity);
        }
        ApiResultUtil.objResult((AjaxJson)this.ttBudgetDetailFeign.releaseFeeBudgutDetail(feeUseBudgutParams), (boolean)true);
        updateList.forEach(item -> this.auditActService.updateTtActDetailEntity((TtActDetailEntity)item));
        return ajaxJson;
    }

    private void checkEndAudit(List<TtActDetailEntity> detailEntities, List<String> actDetailCodes, AjaxJson ajaxJson) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u6d3b\u52a8\u660e\u7ec6\u7f16\u53f7:");
        List<TtAuditActDetailEntity> auditDetail = this.ttAuditActDetailDao.findAudtDetailByBpmstatus(ConstantEnum.bpmStatus.APPROVAL.getValue(), actDetailCodes);
        if (CollectionUtil.listNotEmptyNotSizeZero(auditDetail)) {
            for (TtAuditActDetailEntity item : auditDetail) {
                stringBuffer.append(item.getActDetailCode()).append(",");
            }
            stringBuffer.append("\u5728\u6838\u9500\u6d41\u7a0b\u4e2d");
            ajaxJson.setErrMsg(stringBuffer.toString());
            return;
        }
        boolean noFlag = true;
        for (TtActDetailEntity detailEntity : detailEntities) {
            if (!TtActDetailEntity.AUDITSTATUS.COMPLETE.getCode().equals(detailEntity.getAuditStatus())) continue;
            noFlag = false;
            stringBuffer.append(detailEntity.getActDetailCode()).append(",");
        }
        if (!noFlag) {
            stringBuffer.append("\u5df2\u7ecf\u5b8c\u5168\u6838\u9500");
            ajaxJson.setErrMsg(stringBuffer.toString());
            return;
        }
        HashMap<String, ConstantEnum.ACTTYPE> map = new HashMap<String, ConstantEnum.ACTTYPE>();
        map.put(ConstantEnum.ACTTYPE.quota.getVal(), ConstantEnum.ACTTYPE.quota);
        map.put(ConstantEnum.ACTTYPE.departcost.getVal(), ConstantEnum.ACTTYPE.departcost);
        map.put(ConstantEnum.ACTTYPE.rebate.getVal(), ConstantEnum.ACTTYPE.rebate);
        for (TtActDetailEntity detailEntity : detailEntities) {
            if (map.containsKey(detailEntity.getActType())) continue;
            noFlag = false;
            stringBuffer.append(detailEntity.getActDetailCode()).append(",");
        }
        if (!noFlag) {
            stringBuffer.append("\u4e0d\u5141\u8bb8\u4f7f\u7528\u6b64\u529f\u80fd");
            ajaxJson.setErrMsg(stringBuffer.toString());
            return;
        }
    }

    @Override
    public AjaxJson enddepartuse(List<String> actDetailCodes) {
        AjaxJson ajaxJson = new AjaxJson();
        if (this.enddepartuseExtend != null) {
            return this.enddepartuseExtend.enddepartuse(actDetailCodes);
        }
        ajaxJson.setErrMsg("\u6b64\u529f\u80fd\u4e8c\u5f00\u5b9e\u73b0\uff1aenddepartuseExtend");
        return ajaxJson;
    }
}

