/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.withholding.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.pay.withholding.vo.DelByParamReq;
import com.biz.eisp.pay.withholding.vo.ManualReq;
import com.biz.eisp.pay.withholding.vo.UdpateAmontByIdsReq;
import com.biz.eisp.pay.withholding.vo.UdpateAmontByParamReq;
import com.biz.eisp.pay.withholding.vo.WithholdingByParamReq;
import com.biz.eisp.withholding.service.WithholdingService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(value="pc-\u9884\u63d0", tags={"pc-\u9884\u63d0"})
@RestController
@RequestMapping(value={"/withholding"})
public class WithholdingController {
    @Autowired
    private WithholdingService withholdingService;

    @ApiOperation(value="\u624b\u52a8\u9884\u63d0")
    @RequestMapping(value={"manual"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public AjaxJson manual(@RequestBody @Valid ManualReq manualReq) {
        this.withholdingService.manual(manualReq);
        return AjaxJson.ok();
    }

    @ApiOperation(value="\u6839\u636eid\u5220\u9664\u9884\u63d0\u7ed3\u679c")
    @RequestMapping(value={"delByIds"}, method={RequestMethod.DELETE}, consumes={"application/json"}, produces={"application/json"})
    public AjaxJson delByIds(@RequestBody @Valid @NotEmpty ArrayList<String> ids) {
        this.withholdingService.delByIds(ids);
        return AjaxJson.ok();
    }

    @ApiOperation(value="\u6839\u636e\u67e5\u8be2\u6761\u4ef6\u5220\u9664\u9884\u63d0\u7ed3\u679c")
    @RequestMapping(value={"delByParam"}, method={RequestMethod.DELETE}, consumes={"application/json"}, produces={"application/json"})
    public AjaxJson delByParam(@RequestBody DelByParamReq delByParamReq) {
        this.withholdingService.delByParam(delByParamReq);
        return AjaxJson.ok();
    }

    @ApiOperation(value="\u6839\u636eid\u6279\u91cf\u4fee\u6539\u9884\u63d0\u7ed3\u679c\u91d1\u989d")
    @RequestMapping(value={"udpateAmontByIds"}, method={RequestMethod.PUT}, consumes={"application/json"}, produces={"application/json"})
    public AjaxJson udpateAmontByIds(@RequestBody @Valid UdpateAmontByIdsReq udpateAmontByIdsReq) {
        UserRedis userRedis = UserUtils.getUser();
        this.withholdingService.updateAmontByIds(udpateAmontByIdsReq.getIds(), udpateAmontByIdsReq.getFinalAmount(), userRedis.getId(), userRedis.getUsername());
        return AjaxJson.ok();
    }

    @ApiOperation(value="\u6839\u636e\u67e5\u8be2\u6761\u4ef6\u6279\u91cf\u4fee\u6539\u9884\u63d0\u7ed3\u679c\u91d1\u989d")
    @RequestMapping(value={"udpateAmontByParam"}, method={RequestMethod.PUT}, consumes={"application/json"}, produces={"application/json"})
    public AjaxJson udpateAmontByParam(@RequestBody UdpateAmontByParamReq udpateAmontByParamReq) {
        UserRedis userRedis = UserUtils.getUser();
        this.withholdingService.udpateAmontByParam(udpateAmontByParamReq, udpateAmontByParamReq.getFinalAmount(), userRedis.getId(), userRedis.getUsername());
        return AjaxJson.ok();
    }

    @ApiOperation(value="\u6309\u7167\u6761\u4ef6\u6279\u91cf\u66f4\u65b0\u9884\u63d0")
    @RequestMapping(value={"withholdingByParam"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public AjaxJson withholdingByParam(@RequestBody @Valid WithholdingByParamReq withholdingByParamReq) {
        ArrayList<String> types = this.withholdingService.withholdingByParam(withholdingByParamReq);
        AjaxJson ajaxJson = AjaxJson.ok();
        ajaxJson.setList(types);
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636e\u7ed3\u679cid\u91cd\u65b0\u9884\u63d0")
    @RequestMapping(value={"withholdingByIds"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public AjaxJson withholdingByIds(@RequestBody @Valid @NotEmpty(message="\u8bf7\u9009\u62e9\u9700\u8981\u91cd\u65b0\u9884\u63d0\u7684\u9884\u63d0\u7ed3\u679c") @Valid @NotEmpty(message="\u8bf7\u9009\u62e9\u9700\u8981\u91cd\u65b0\u9884\u63d0\u7684\u9884\u63d0\u7ed3\u679c") ArrayList<String> ids) {
        this.withholdingService.withholdingByIds(ids);
        return AjaxJson.ok();
    }
}

