/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.policy.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.pay.policy.entity.PayPolicyCalculationProcessEntity;
import com.biz.eisp.pay.policy.entity.PayPolicyCalculationResultEntity;
import com.biz.eisp.pay.policy.vo.PayPolicyCalculationParamVo;
import com.biz.eisp.policy.service.PayPolicyCalculationService;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/payPolicyCalculationController"})
public class PayPolicyCalculationController {
    private static final Logger log = LoggerFactory.getLogger(PayPolicyCalculationController.class);
    @Autowired
    private PayPolicyCalculationService payPolicyCalculationService;

    @PostMapping(value={"calculation"}, produces={"application/json;charset=UTF-8"})
    public AjaxJson calculation(@RequestBody PayPolicyCalculationParamVo paramVo) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            this.payPolicyCalculationService.calculation(paramVo);
        }
        catch (Exception e) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg(e.getMessage());
        }
        return ajaxJson;
    }

    @RequestMapping(value={"/findPayPolicyCalculationResultList"})
    public DataGrid findPayPolicyCalculationResultList(PayPolicyCalculationResultEntity resultEntity, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        PageInfo pageInfo = null;
        try {
            resultEntity.setClickFunctionId(request.getParameter("clickFunctionId"));
            if (StringUtil.isEmpty((String)resultEntity.getPolicyCalculationYearMonth())) {
                resultEntity.setPolicyCalculationYearMonth(DateUtils.format((Date)new Date(), (String)"yyyy-MM"));
            }
            if (Objects.isNull(pageInfo = this.payPolicyCalculationService.findPayPolicyCalculationResultList(resultEntity, (Page)page))) {
                pageInfo = new PageInfo();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"/findPayPolicyCalculationProcessList"})
    public DataGrid findPayPolicyCalculationProcessList(PayPolicyCalculationProcessEntity processEntity, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        PageInfo pageInfo = null;
        try {
            if (StringUtil.isEmpty((String)processEntity.getPolicyCalculationYearMonth())) {
                processEntity.setPolicyCalculationYearMonth(DateUtils.format((Date)new Date(), (String)"yyyy-MM"));
            }
            if (Objects.isNull(pageInfo = this.payPolicyCalculationService.findPayPolicyCalculationProcessList(processEntity, (Page)page))) {
                pageInfo = new PageInfo();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return new DataGrid(pageInfo);
    }
}

