/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.ai.display.controller;

import com.biz.eisp.ai.display.enity.TsAiCheckEntity;
import com.biz.eisp.ai.display.service.TsAiCheckService;
import com.biz.eisp.ai.display.service.TsAiRestService;
import com.biz.eisp.ai.display.vo.TsAiCheckApiVo;
import com.biz.eisp.ai.display.vo.TsAiCheckVo;
import com.biz.eisp.ai.display.vo.TsAiDetailVo;
import com.biz.eisp.ai.display.vo.TsCheckStatusVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.params.Constant;
import com.biz.eisp.picture.entity.TsPictureEntity;
import com.biz.eisp.tools.DictUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"AI-\u68c0\u6838"}, description="CRM-SFA-AI AI-\u68c0\u6838")
@RestController
@RequestMapping(value={"/aiApi/tsAiCheckApiController"})
public class TsAiCheckApiController {
    @Autowired
    private TsAiCheckService tsAiCheckService;
    @Autowired
    TsAiRestService tsAiRestService;

    @ApiOperation(value="\u63d0\u4ea4\u68c0\u6838\u6570\u636e", notes="\u63d0\u4ea4\u68c0\u6838\u6570\u636e", httpMethod="POST")
    @PostMapping(value={"saveCheckData"})
    public AjaxJson<TsAiCheckEntity> saveCheckData(@RequestBody TsAiCheckVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            ajaxJson.setObj((Object)this.tsAiCheckService.saveCheckData(vo));
        }
        catch (Exception e) {
            e.printStackTrace();
            ajaxJson.setMsg("\u63d0\u4ea4\u5931\u8d25");
            ajaxJson.setSuccess(false);
        }
        return ajaxJson;
    }

    @ApiOperation(value="\u4fdd\u5b58AI\u68c0\u67e5\u6570\u636e", notes="\u4fdd\u5b58AI\u68c0\u67e5\u6570\u636e", httpMethod="POST")
    @PostMapping(value={"saveTsAiCheck"})
    public AjaxJson saveTsAiCheck(@RequestBody TsAiCheckEntity entity) {
        AjaxJson ajaxJson = new AjaxJson();
        this.tsAiCheckService.insertSelective(entity);
        return ajaxJson;
    }

    @PostMapping(value={"findAICheckPage"})
    public AjaxJson<TsAiCheckVo> findAICheckPage(@RequestBody TsAiCheckApiVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson.setPageInfo(this.tsAiCheckService.findAICheckPage(vo));
        return ajaxJson;
    }

    @PostMapping(value={"findAICheckPageForWeb"})
    public AjaxJson<TsAiCheckVo> findAICheckPageForWeb(@RequestBody TsAiCheckApiVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson.setPageInfo(this.tsAiCheckService.findAICheckPageForWeb(vo));
        return ajaxJson;
    }

    @PostMapping(value={"getAICheckData"})
    public AjaxJson<TsAiCheckVo> getAICheckData(@RequestBody TsAiCheckApiVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            ajaxJson.setObj((Object)this.tsAiCheckService.getAICheckData(vo));
        }
        catch (Exception e) {
            e.printStackTrace();
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u67e5\u8be2\u5931\u8d25\uff01");
        }
        return ajaxJson;
    }

    @PostMapping(value={"checkStatus"})
    public AjaxJson checkStatus(@RequestBody TsCheckStatusVo vo) {
        AjaxJson j = new AjaxJson();
        try {
            j.setAttributes(this.tsAiCheckService.checkStatus(vo));
        }
        catch (BusinessException e) {
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @PostMapping(value={"getAICheckDetail"})
    public AjaxJson<TsAiDetailVo> getAICheckDetail(@RequestParam(value="id") String id) {
        AjaxJson j = new AjaxJson();
        try {
            j.setObj((Object)this.tsAiCheckService.getAICheckDetail(id));
        }
        catch (BusinessException e) {
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @PostMapping(value={"dealAIRest"})
    public AjaxJson dealAIRest(@RequestParam(value="dictCode") String dictCode, @RequestBody List<TsPictureEntity> picList, @RequestParam(value="id") String id) {
        AjaxJson j = new AjaxJson();
        try {
            KnlDictDataEntity data = DictUtil.getDicData((String)Constant.aiProject.ai_project_group.getVal(), (String)dictCode);
            this.tsAiRestService.dealAIRest(data, picList, id);
        }
        catch (BusinessException e) {
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @PostMapping(value={"delete"})
    public AjaxJson<TsAiDetailVo> delete(@RequestParam(value="id") String id) {
        AjaxJson j = new AjaxJson();
        this.tsAiCheckService.deleteByPrimaryKey(id);
        return j;
    }

    @PostMapping(value={"deleteByIds"})
    public AjaxJson<TsAiDetailVo> deleteByIds(@RequestParam(value="idsStr") String idsStr) {
        String[] ids;
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((CharSequence)idsStr) && (ids = idsStr.split(",")) != null && ids.length > 0) {
            for (String id : ids) {
                this.tsAiCheckService.deleteByPrimaryKey(id);
            }
        }
        return j;
    }
}

