/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.grpc.parse.service.impl;

import com.biz.eisp.grpc.parse.mapper.AiTerminalResultMapper;
import com.biz.eisp.grpc.parse.mapper.AiTerminalSimilarMapper;
import com.biz.eisp.grpc.parse.model.AiTerminalResultEntity;
import com.biz.eisp.grpc.parse.model.AiTerminalSimilarEntity;
import com.biz.eisp.grpc.parse.service.impl.ActIdentifyAbstractServiceImpl;
import com.biz.eisp.grpc.service.TerminalIdentifyService;
import com.biz.eisp.grpc.vo.AiTerminalResultVo;
import com.biz.eisp.picture.entity.TsPictureEntity;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="actTerminalIdentifyService")
@Transactional
public class ActTerminalIdentifyServiceImpl
extends ActIdentifyAbstractServiceImpl {
    @Autowired
    private TerminalIdentifyService terminalIdentifyService;
    @Autowired
    private AiTerminalResultMapper aiTerminalResultMapper;
    @Autowired
    private AiTerminalSimilarMapper aiTerminalSimilarMapper;

    @Override
    public void identify(List<TsPictureEntity> tsPictures, String businessId, String appId, String modelName) {
        String errorMsg = null;
        try {
            for (TsPictureEntity tsPicture : tsPictures) {
                String imgPath = tsPicture.getImgUrl();
                AiTerminalResultVo terminalResultVo = this.terminalIdentifyService.identifyTerminalInfo(appId, modelName, imgPath);
                boolean hasLogo = this.terminalIdentifyService.identifyTerminalLogo(imgPath);
                String mainColor = this.terminalIdentifyService.identifyTerminalColor(imgPath);
                boolean insert = false;
                AiTerminalResultEntity tempResult = new AiTerminalResultEntity();
                tempResult.setImgId(tsPicture.getId() + "");
                AiTerminalResultEntity aiTerminalResult = (AiTerminalResultEntity)this.aiTerminalResultMapper.selectOne(tempResult);
                if (null == aiTerminalResult) {
                    aiTerminalResult = new AiTerminalResultEntity();
                    aiTerminalResult.setImgId(tsPicture.getId() + "");
                    String id = UUID.randomUUID().toString().replaceAll("-", "");
                    aiTerminalResult.setId(id);
                    insert = true;
                }
                aiTerminalResult.setBusinessId(businessId);
                aiTerminalResult.setCreatedTime(new Date());
                aiTerminalResult.setImgId(tsPicture.getId() + "");
                aiTerminalResult.setTerminalName(terminalResultVo.getTerminalName());
                aiTerminalResult.setTerminalTel(terminalResultVo.getTerminalTel());
                aiTerminalResult.setTerminalAddress(terminalResultVo.getTerminalAddress());
                aiTerminalResult.setHasLogo(hasLogo ? "\u662f" : "\u5426");
                aiTerminalResult.setColorName(mainColor);
                if (insert) {
                    this.aiTerminalResultMapper.insert(aiTerminalResult);
                } else {
                    this.aiTerminalResultMapper.updateByPrimaryKey(aiTerminalResult);
                }
                AiTerminalSimilarEntity tempResult2 = new AiTerminalSimilarEntity();
                tempResult2.setImgId(tsPicture.getId() + "");
                tempResult2.setBusinessId(businessId);
                List tempList2 = this.aiTerminalSimilarMapper.select(tempResult2);
                for (AiTerminalSimilarEntity terminalSimilarEntity : tempList2) {
                    this.aiTerminalSimilarMapper.delete(terminalSimilarEntity);
                }
                if (!StringUtils.isNotEmpty((CharSequence)aiTerminalResult.getTerminalName())) continue;
                AiTerminalSimilarEntity entity = new AiTerminalSimilarEntity();
                entity.setTerminalName(aiTerminalResult.getTerminalName());
                List aiTerminalSimilarList = this.aiTerminalSimilarMapper.select(entity);
                for (AiTerminalSimilarEntity aiTerminalSimilar : aiTerminalSimilarList) {
                    aiTerminalSimilar.setCreatedTime(new Date());
                    aiTerminalSimilar.setImgId(tsPicture.getId() + "");
                    aiTerminalSimilar.setId(UUID.randomUUID().toString().replaceAll("-", ""));
                    this.aiTerminalSimilarMapper.insert(aiTerminalSimilar);
                }
            }
        }
        catch (Exception e) {
            errorMsg = e.getMessage();
        }
        this.updateStatus(businessId, true, errorMsg, true);
    }
}

