/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.grpc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.grpc.service.ProductIdentifyService;
import com.biz.eisp.grpc.service.impl.AiIdentifyAbstractService;
import com.biz.eisp.grpc.vo.AiResultVo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="productIdentifyService")
@Transactional
public class ProductIdentifyServiceImpl
extends AiIdentifyAbstractService
implements ProductIdentifyService {
    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public AiResultVo displayIdentify(String appId, String modelName, String imgUrl) {
        String pushContent = null;
        String receiveContent = null;
        try {
            pushContent = this.newRequestBody(appId, modelName, Collections.singletonList(imgUrl));
            JSONObject jsonObject = this.aiIdentify(pushContent);
            receiveContent = jsonObject.toJSONString();
            if (jsonObject.containsKey((Object)"error_msg")) {
                throw new BusinessException(jsonObject.getString("error_msg"));
            }
            this.addLog(imgUrl, modelName, null, pushContent, receiveContent, true, null);
            AiResultVo result = (AiResultVo)jsonObject.getObject("result", AiResultVo.class);
            result.setDetectionObject(imgUrl);
            return result;
        }
        catch (BusinessException e) {
            this.addLog(imgUrl, modelName, null, pushContent, receiveContent, false, e.getMessage());
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.addLog(imgUrl, modelName, null, pushContent, receiveContent, false, e.getMessage());
            throw e;
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<AiResultVo> displayDuplicateIdentify(List<AiResultVo> list) {
        String pushContent = null;
        String receiveContent = null;
        try {
            JSONObject extendArgs = new JSONObject();
            extendArgs.put("display_dects", list);
            pushContent = this.newRequestBody("display_remove_duplicate", new ArrayList<String>(), extendArgs);
            JSONObject jsonObject = this.aiIdentify(pushContent);
            receiveContent = jsonObject.toJSONString();
            if (jsonObject.containsKey((Object)"error_msg")) {
                throw new BusinessException(jsonObject.getString("error_msg"));
            }
            this.addLog(null, "display_remove_duplicate", null, pushContent, receiveContent, true, null);
            return JSONObject.parseArray((String)jsonObject.getString("result"), AiResultVo.class);
        }
        catch (BusinessException e) {
            this.addLog(null, "display_remove_duplicate", null, pushContent, receiveContent, false, e.getMessage());
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.addLog(null, "display_remove_duplicate", null, pushContent, receiveContent, false, e.getMessage());
            throw e;
        }
    }
}

