/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.ai.display.service.impl;

import com.biz.eisp.ai.display.dao.TsAiCheckDao;
import com.biz.eisp.ai.display.dao.TsDisProductDao;
import com.biz.eisp.ai.display.dao.TsPictureDao;
import com.biz.eisp.ai.display.enity.TsAiCheckEntity;
import com.biz.eisp.ai.display.service.TsAiCheckService;
import com.biz.eisp.ai.display.service.TsAiDisplayConfService;
import com.biz.eisp.ai.display.service.TsAiRestService;
import com.biz.eisp.ai.display.vo.TsAiCheckApiVo;
import com.biz.eisp.ai.display.vo.TsAiCheckVo;
import com.biz.eisp.ai.display.vo.TsAiDetailVo;
import com.biz.eisp.ai.display.vo.TsAiDisplayConfVo;
import com.biz.eisp.ai.display.vo.TsAiDisplayRulesVo;
import com.biz.eisp.ai.display.vo.TsAiProductDetailVo;
import com.biz.eisp.ai.display.vo.TsCheckStatusVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.disproduct.entity.TsDisProductEntity;
import com.biz.eisp.grpc.parse.mapper.AiPersonnelRedrawPictureMapper;
import com.biz.eisp.grpc.parse.mapper.AiPersonnelResultMapper;
import com.biz.eisp.grpc.parse.mapper.AiPriceTagResultMapper;
import com.biz.eisp.grpc.parse.mapper.AiProduceDateResultMapper;
import com.biz.eisp.grpc.parse.mapper.AiProductRedrawPictureMapper;
import com.biz.eisp.grpc.parse.mapper.AiProductResultMapper;
import com.biz.eisp.grpc.parse.mapper.AiSceneResultMapper;
import com.biz.eisp.grpc.parse.mapper.AiTerminalResultMapper;
import com.biz.eisp.grpc.parse.mapper.AiTerminalSimilarMapper;
import com.biz.eisp.grpc.parse.model.AiPersonnelRedrawPictureEntity;
import com.biz.eisp.grpc.parse.model.AiPersonnelResultEntity;
import com.biz.eisp.grpc.parse.model.AiPriceTagResultEntity;
import com.biz.eisp.grpc.parse.model.AiProductRedrawPictureEntity;
import com.biz.eisp.grpc.parse.model.AiProductResultEntity;
import com.biz.eisp.grpc.parse.model.AiSceneResultEntity;
import com.biz.eisp.grpc.parse.model.AiTerminalResultEntity;
import com.biz.eisp.grpc.utils.ResultConstant;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.params.Constant;
import com.biz.eisp.picture.entity.TsPictureEntity;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.tools.DictUtil;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class TsAiCheckServiceImpl
extends BaseServiceImpl<TsAiCheckEntity>
implements TsAiCheckService {
    @Autowired
    private TsAiCheckDao tsAiCheckDao;
    @Autowired
    private TsAiDisplayConfService tsAiDisplayConfService;
    @Autowired
    private TsPictureDao tsPictureDao;
    @Autowired
    private AiPersonnelResultMapper aiPersonnelResultMapper;
    @Autowired
    private AiPersonnelRedrawPictureMapper aiPersonnelRedrawPictureMapper;
    @Autowired
    private AiPriceTagResultMapper aiPriceTagResultMapper;
    @Autowired
    private AiProduceDateResultMapper aiProduceDateResultMapper;
    @Autowired
    private AiProductRedrawPictureMapper aiProductRedrawPictureMapper;
    @Autowired
    private AiProductResultMapper aiProductResultMapper;
    @Autowired
    private AiTerminalResultMapper aiTerminalResultMapper;
    @Autowired
    private AiTerminalSimilarMapper aiTerminalSimilarMapper;
    @Autowired
    private AiSceneResultMapper aiSceneResultMapper;
    @Autowired
    private TsDisProductDao tsDisProductDao;
    @Autowired
    private TsAiRestService tsAiRestService;

    @Override
    public TsAiCheckVo getAICheckData(TsAiCheckApiVo vo) throws Exception {
        TsAiCheckVo result = new TsAiCheckVo();
        TsAiCheckEntity entity = null;
        if (vo.getId() != null) {
            entity = (TsAiCheckEntity)this.selectByPrimaryKey(vo.getId());
        } else {
            List checks;
            UserRedis user = UserUtils.getUser();
            String date = DateUtils.getDate((String)"yyyy-MM-dd");
            Example example = new Example(TsAiCheckEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("createBy", (Object)user.getId());
            criteria.andEqualTo("dictCode", (Object)vo.getDictCode());
            criteria.andEqualTo("checkDate", (Object)date);
            criteria.andEqualTo("isTerminalType", (Object)vo.getIsTerminalType());
            if (StringUtils.isNotBlank((CharSequence)vo.getTerminalCode())) {
                criteria.andEqualTo("terminalCode", (Object)vo.getTerminalCode());
            }
            if (CollectionUtil.listNotEmptyNotSizeZero((List)(checks = this.selectExample(example)))) {
                entity = (TsAiCheckEntity)checks.get(0);
            }
        }
        if (entity != null) {
            MyBeanUtils.copyBeanNotNull2Bean((Object)entity, (Object)result);
            this.dealPic(result);
        }
        return result;
    }

    private void dealPic(TsAiCheckVo result) {
        Example example = new Example(TsPictureEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("imgType", (Object)(Constant.imgType.aicheck + result.getDictCode()));
        criteria.andEqualTo("businessId", (Object)result.getId());
        List pics = this.tsPictureDao.selectByExample(example);
        result.setPicList(pics);
    }

    @Override
    public TsAiCheckEntity saveCheckData(TsAiCheckVo vo) throws Exception {
        TsAiCheckEntity entity = new TsAiCheckEntity();
        MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
        entity.setCheckDate(DateUtils.getDate((String)"yyyy-MM-dd"));
        entity.setStatus(Constant.IDENTIFY_STATUS.IDENTIFY.getStatus());
        this.insertSelective(entity);
        List picList = vo.getPicList();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)picList)) {
            picList.forEach(item -> {
                item.setBusinessId(entity.getId());
                item.setImgType(Constant.imgType.aicheck + vo.getDictCode());
            });
            this.tsPictureDao.insertList(picList);
        }
        KnlDictDataEntity data = DictUtil.getDicData((String)Constant.aiProject.ai_project_group.getVal(), (String)vo.getDictCode());
        this.tsAiRestService.dealAIRest(data, picList, entity.getId() + "");
        return entity;
    }

    @Override
    public Map<String, Object> checkStatus(TsCheckStatusVo vo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        UserRedis user = UserUtils.getUser();
        if (user == null) {
            throw new BusinessException("\u767b\u5f55\u5931\u6548\uff01");
        }
        String date = DateUtils.getDate((String)"yyyy-MM-dd");
        Example example = new Example(TsAiCheckEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("checkDate", (Object)date);
        criteria.andEqualTo("createBy", (Object)user.getId());
        if (vo.isTerm()) {
            if (StringUtils.isNotBlank((CharSequence)vo.getTerminalCode())) {
                criteria.andEqualTo("terminalCode", (Object)vo.getTerminalCode());
                if (CollectionUtil.listNotEmptyNotSizeZero((List)vo.getCodes())) {
                    criteria.andIn("dictCode", (Iterable)vo.getCodes());
                }
            } else if (CollectionUtil.listNotEmptyNotSizeZero((List)vo.getCodes())) {
                criteria.andIn("terminalCode", (Iterable)vo.getCodes());
            }
            criteria.andEqualTo("isTerminalType", (Object)"1");
        } else {
            if (CollectionUtil.listNotEmptyNotSizeZero((List)vo.getCodes())) {
                criteria.andIn("dictCode", (Iterable)vo.getCodes());
            }
            criteria.andEqualTo("isTerminalType", (Object)"0");
        }
        List list = this.selectExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            list.forEach(item -> {
                if (StringUtils.isNotBlank((CharSequence)item.getTerminalCode())) {
                    map.put(item.getTerminalCode(), 1);
                }
                map.put("checkId", item.getId());
                map.put(item.getDictCode(), 1);
            });
        }
        return map;
    }

    @Override
    public PageInfo<TsAiCheckVo> findAICheckPage(TsAiCheckApiVo vo) {
        EuPage page = new EuPage();
        page.setRows(vo.getRows());
        page.setPage(vo.getPage());
        HashMap map = new HashMap();
        UserRedis user = UserUtils.getUser();
        Example example = new Example(TsAiCheckEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("createBy", (Object)user.getId());
        example.orderBy("createDate").desc();
        return PageAutoHelperUtil.generatePage(() -> this.selectExample(example), (Page)page);
    }

    @Override
    public PageInfo<TsAiCheckVo> findAICheckPageForWeb(TsAiCheckApiVo vo) {
        EuPage page = new EuPage();
        page.setRows(vo.getRows());
        page.setPage(vo.getPage());
        return PageAutoHelperUtil.generatePage(() -> this.tsAiCheckDao.findAICheckPageForWeb(vo), (Page)page);
    }

    @Override
    public TsAiDetailVo getAICheckDetail(String id) throws Exception {
        Map map;
        TsAiDetailVo result = new TsAiDetailVo();
        TsAiCheckEntity checkEntity = (TsAiCheckEntity)this.selectByPrimaryKey(id);
        if (checkEntity != null && checkEntity.getStatus() != null && checkEntity.getStatus() == Constant.IDENTIFY_STATUS.CREATED.getStatus()) {
            throw new BusinessException("\u672a\u8bc6\u522b\u5f00\u59cb\uff01");
        }
        String terminalCode = checkEntity.getTerminalCode();
        TsAiDisplayConfVo confVo = null;
        confVo = StringUtils.isBlank((CharSequence)terminalCode) && StringUtils.isNotBlank((CharSequence)checkEntity.getCustCode()) ? this.tsAiDisplayConfService.findOneDisPlayConfObjByCust(checkEntity.getCustCode()) : this.tsAiDisplayConfService.findOneDisPlayConfObj(terminalCode);
        KnlDictDataEntity data = DictUtil.getDicData((String)Constant.aiProject.ai_project_group.getVal(), (String)checkEntity.getDictCode());
        if (data != null && (map = data.getExtendMap()) != null && map.size() > 0) {
            String a = OConvertUtils.getString(map.get(Constant.aiProject.project_a.getVal()));
            String b = OConvertUtils.getString(map.get(Constant.aiProject.project_b.getVal()));
            String c = OConvertUtils.getString(map.get(Constant.aiProject.project_c.getVal()));
            if (StringUtils.isNotBlank((CharSequence)a)) {
                this.switchAi(confVo, a, result, id, terminalCode);
            }
            if (StringUtils.isNotBlank((CharSequence)b)) {
                this.switchAi(confVo, b, result, id, terminalCode);
            }
            if (StringUtils.isNotBlank((CharSequence)c)) {
                this.switchAi(confVo, c, result, id, terminalCode);
            }
        }
        return result;
    }

    private void switchAi(TsAiDisplayConfVo confVo, String aiType, TsAiDetailVo result, String id, String terminalCode) {
        result.setDisplay(true);
        switch (aiType) {
            case "product": {
                this.dealDisPlayAI(confVo, result, id, terminalCode);
                break;
            }
            case "scene": {
                this.dealsceneAI(result, id);
                break;
            }
            case "terminal": {
                this.dealTermianlAI(result, id);
                break;
            }
            case "price_tag": {
                this.dealPriceAI(result, id);
                break;
            }
            case "produce_date": {
                break;
            }
            case "yanghe_person": {
                this.dealPersonAI(result, id);
                break;
            }
            case "product_no_repeat": {
                this.dealDisPlayAI(confVo, result, id, terminalCode);
                break;
            }
        }
    }

    private void dealDisPlayAI(TsAiDisplayConfVo confVo, TsAiDetailVo result, String id, String ternimalCode) {
        Example example = new Example(AiProductResultEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("businessId", (Object)id);
        List products = this.aiProductResultMapper.selectByExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)products)) {
            ArrayList productDetailVos = new ArrayList();
            products.forEach(item -> {
                if (Constant.productType.sp.getValue() == Integer.parseInt(item.getProductType())) {
                    if (result.getProductTypeNum() == null) {
                        result.setProductTypeNum(BigDecimal.ZERO);
                    }
                    result.setProductTypeNum(result.getProductTypeNum().add(BigDecimal.ONE));
                    if (result.getProductNum() == null) {
                        result.setProductNum(BigDecimal.ZERO);
                    }
                    if (item.getProductCount() != null) {
                        result.setProductNum(result.getProductNum().add(new BigDecimal(item.getProductCount())));
                    }
                }
                if (Constant.productType.jp.getValue() == Integer.parseInt(item.getProductType())) {
                    if (result.getProductCompeting() == null) {
                        result.setProductCompeting(BigDecimal.ZERO);
                    }
                    if (item.getProductCount() != null) {
                        result.setProductCompeting(result.getProductCompeting().add(new BigDecimal(item.getProductCount())));
                    }
                }
                if (result.getProductCompeting() == null) {
                    result.setProductCompeting(BigDecimal.ZERO);
                }
                if (result.getProductTypeNum() == null) {
                    result.setDisplayRate(BigDecimal.ZERO);
                } else {
                    result.setDisplayRate(result.getProductTypeNum().multiply(new BigDecimal(100)).divide(result.getProductTypeNum().add(result.getProductCompeting())).setScale(0));
                }
            });
            result.setProdetails(productDetailVos);
            Example fx = new Example(TsDisProductEntity.class);
            Example.Criteria fxcri = fx.createCriteria();
            fxcri.andEqualTo("ternimalCode", (Object)ternimalCode);
            int num = this.tsDisProductDao.selectCountByExample(fx);
            if (num == 0) {
                result.setDistributionRate(new BigDecimal(100));
            } else {
                result.setDistributionRate(result.getProductTypeNum().multiply(new BigDecimal(100)).divide(new BigDecimal(num)).setScale(0));
            }
            products.forEach(item -> {
                TsAiProductDetailVo pvo = new TsAiProductDetailVo();
                pvo.setProductType(item.getProductType());
                pvo.setProductName(item.getProductName());
                pvo.setDisplayNum(item.getProductCount().intValue());
                pvo.setLayerNum(item.getLayerCount() == null ? 0 : item.getLayerCount());
                if (confVo != null) {
                    List standardvos = confVo.getStandardVos();
                    List rulues = confVo.getRulues();
                    if (CollectionUtil.listNotEmptyNotSizeZero((List)standardvos) && CollectionUtil.listNotEmptyNotSizeZero((List)rulues)) {
                        standardvos.stream().filter(dd -> StringUtils.isNotBlank((CharSequence)dd.getCode())).forEach(ss -> {
                            if (ss.getCode().equals(item.getProductCode())) {
                                int surfaceNum = ss.getSurfaceNum();
                                int layerNum = ss.getLayerNum();
                                pvo.setDisplayStandNum(surfaceNum);
                                pvo.setLayerStandNum(layerNum);
                                BigDecimal dcsurface = BigDecimal.valueOf(Math.round(pvo.getDisplayNum() * 100 / surfaceNum));
                                BigDecimal dclayer = new BigDecimal(100);
                                Map<String, TsAiDisplayRulesVo> rulesVoMap = rulues.stream().collect(Collectors.toMap(TsAiDisplayRulesVo::getJudgeResult, TsAiDisplayRulesVo2 -> TsAiDisplayRulesVo2));
                                TsAiDisplayRulesVo wm = rulesVoMap.get(ResultConstant.judgeResult.wm.getVal());
                                this.calculateCheckResult(dcsurface, dclayer, result, wm, pvo, 1);
                                TsAiDisplayRulesVo yx = rulesVoMap.get(ResultConstant.judgeResult.yx.getVal());
                                this.calculateCheckResult(dcsurface, dclayer, result, yx, pvo, 2);
                                TsAiDisplayRulesVo hg = rulesVoMap.get(ResultConstant.judgeResult.yx.getVal());
                                this.calculateCheckResult(dcsurface, dclayer, result, hg, pvo, 3);
                                TsAiDisplayRulesVo bhg = rulesVoMap.get(ResultConstant.judgeResult.yx.getVal());
                                this.calculateCheckResult(dcsurface, dclayer, result, bhg, pvo, 4);
                            }
                        });
                    }
                }
                productDetailVos.add(pvo);
            });
            Example example_ = new Example(AiProductRedrawPictureEntity.class);
            Example.Criteria criteria_ = example_.createCriteria();
            criteria_.andEqualTo("businessId", (Object)id);
            List pics = this.aiProductRedrawPictureMapper.selectByExample(example_);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)pics)) {
                result.setDisPicList(pics.stream().map(AiProductRedrawPictureEntity::getImgPath).collect(Collectors.toList()));
            }
        }
    }

    private void calculateCheckResult(BigDecimal dcsurface, BigDecimal dclayer, TsAiDetailVo result, TsAiDisplayRulesVo rulesVo, TsAiProductDetailVo pvo, int type) {
        BigDecimal fx = result.getDistributionRate() != null ? rulesVo.getDistributionRate() : BigDecimal.ZERO;
        BigDecimal distributionRate = rulesVo.getDistributionRate() != null ? rulesVo.getDistributionRate() : BigDecimal.ZERO;
        BigDecimal surfaceRate = rulesVo.getSurfaceRate() != null ? rulesVo.getSurfaceRate() : BigDecimal.ZERO;
        BigDecimal layerRate = rulesVo.getLayerRate() != null ? rulesVo.getLayerRate() : BigDecimal.ZERO;
        switch (type) {
            case 1: {
                if (fx.compareTo(distributionRate) >= 0) {
                    result.setDistributionResult(ResultConstant.judgeResult.wm.getVal());
                }
                if (dcsurface.compareTo(surfaceRate) >= 0) {
                    pvo.setDisplayResult(ResultConstant.judgeResult.wm.getVal());
                }
                if (dclayer.compareTo(layerRate) < 0) break;
                pvo.setLayerResult(ResultConstant.judgeResult.wm.getVal());
                break;
            }
            case 2: {
                if (fx.compareTo(distributionRate) >= 0) {
                    result.setDistributionResult(ResultConstant.judgeResult.yx.getVal());
                }
                if (dcsurface.compareTo(surfaceRate) >= 0) {
                    pvo.setDisplayResult(ResultConstant.judgeResult.yx.getVal());
                }
                if (dclayer.compareTo(layerRate) < 0) break;
                pvo.setLayerResult(ResultConstant.judgeResult.yx.getVal());
                break;
            }
            case 3: {
                if (fx.compareTo(distributionRate) >= 0) {
                    result.setDistributionResult(ResultConstant.judgeResult.hg.getVal());
                }
                if (dcsurface.compareTo(surfaceRate) >= 0) {
                    pvo.setDisplayResult(ResultConstant.judgeResult.hg.getVal());
                }
                if (dclayer.compareTo(layerRate) < 0) break;
                pvo.setLayerResult(ResultConstant.judgeResult.hg.getVal());
                break;
            }
            case 4: {
                if (fx.compareTo(distributionRate) < 0) {
                    result.setDistributionResult(ResultConstant.judgeResult.bhg.getVal());
                }
                if (dcsurface.compareTo(surfaceRate) >= 0) {
                    pvo.setDisplayResult(ResultConstant.judgeResult.bhg.getVal());
                }
                if (dclayer.compareTo(layerRate) < 0) break;
                pvo.setLayerResult(ResultConstant.judgeResult.bhg.getVal());
                break;
            }
        }
    }

    private void dealPersonAI(TsAiDetailVo result, String id) {
        Example example = new Example(AiPersonnelRedrawPictureEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("businessId", (Object)id);
        List entities = this.aiPersonnelRedrawPictureMapper.selectByExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)entities)) {
            result.setPerson(true);
            entities.forEach(item -> {
                Example example_ = new Example(AiPersonnelResultEntity.class);
                Example.Criteria criteria_ = example_.createCriteria();
                criteria_.andEqualTo("imgId", (Object)item.getId());
                List list = this.aiPersonnelResultMapper.selectByExample(example_);
                if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                    int sum = list.stream().filter(dd -> dd.getPersonnelNum() != null).mapToInt(AiPersonnelResultEntity::getPersonnelNum).sum();
                    result.setPersonNum(new BigDecimal(sum));
                }
            });
            result.setPersonPicList(entities.stream().map(AiPersonnelRedrawPictureEntity::getImgPath).collect(Collectors.toList()));
        }
    }

    private void dealTermianlAI(TsAiDetailVo result, String id) {
        Example example = new Example(AiTerminalResultEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("businessId", (Object)id);
        List resultEntities = this.aiTerminalResultMapper.selectByExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)resultEntities)) {
            result.setTerminal(true);
            result.setTerminalName(((AiTerminalResultEntity)resultEntities.get(0)).getTerminalName());
        }
    }

    private void dealPriceAI(TsAiDetailVo result, String id) {
        Example example = new Example(AiPriceTagResultEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("businessId", (Object)id);
        List list = this.aiPriceTagResultMapper.selectByExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            result.setPrice(true);
        }
    }

    private void dealBigHighSpeedAI(TsAiDetailVo result, String id) {
    }

    private void dealsceneAI(TsAiDetailVo result, String id) {
        Example example = new Example(AiSceneResultEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("businessId", (Object)id);
        List entities = this.aiSceneResultMapper.selectByExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)entities)) {
            List list = entities.stream().map(AiSceneResultEntity::getClassesName).collect(Collectors.toList());
            result.setDisplayType(StringUtils.join(list, (String)","));
        }
    }

    @Override
    public void delete(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            this.selectByPrimaryKey(ids);
        }
    }
}

