/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.grpc.parse.service.impl;

import com.biz.eisp.grpc.parse.mapper.AiSceneResultMapper;
import com.biz.eisp.grpc.parse.model.AiSceneResultEntity;
import com.biz.eisp.grpc.parse.service.impl.ActIdentifyAbstractServiceImpl;
import com.biz.eisp.grpc.service.SceneIdentifyService;
import com.biz.eisp.params.Constant;
import com.biz.eisp.picture.entity.TsPictureEntity;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="actSceneIdentifyService")
@Transactional
public class ActSceneIdentifyServiceImpl
extends ActIdentifyAbstractServiceImpl {
    @Autowired
    private SceneIdentifyService sceneIdentifyService;
    @Autowired
    private AiSceneResultMapper aiSceneResultMapper;

    @Override
    public void identify(List<TsPictureEntity> tsPictures, String businessId, String appId, String modelName) {
        boolean success = true;
        String errorMsg = null;
        try {
            for (TsPictureEntity tsPicture : tsPictures) {
                String imgPath = tsPicture.getImgUrl();
                String sceneClassStr = this.sceneIdentifyService.sceneIdentify(appId, modelName, imgPath);
                Constant.SceneClass sceneClass = Constant.SceneClass.newInstance((String)sceneClassStr);
                boolean insert = false;
                AiSceneResultEntity tempResult = new AiSceneResultEntity();
                tempResult.setImgId(tsPicture.getId() + "");
                AiSceneResultEntity aiSceneResult = (AiSceneResultEntity)this.aiSceneResultMapper.selectOne(tempResult);
                if (null == aiSceneResult) {
                    aiSceneResult = new AiSceneResultEntity();
                    aiSceneResult.setImgId(tsPicture.getId() + "");
                    insert = true;
                }
                aiSceneResult.setCreatedTime(new Date());
                aiSceneResult.setImgId(tsPicture.getId() + "");
                if (null != sceneClass) {
                    aiSceneResult.setClasses(sceneClass.getCode());
                    aiSceneResult.setClassesName(sceneClass.getName());
                } else {
                    aiSceneResult.setClasses(null);
                    aiSceneResult.setClassesName(null);
                }
                aiSceneResult.setBusinessId(businessId);
                if (insert) {
                    this.aiSceneResultMapper.insert(aiSceneResult);
                    continue;
                }
                this.aiSceneResultMapper.updateByPrimaryKey(aiSceneResult);
            }
        }
        catch (Exception e) {
            success = false;
            errorMsg = e.getMessage();
        }
        this.updateStatus(businessId, success, errorMsg, false);
    }
}

