/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.grpc.service.impl;

import biz_grpc.proto.Message;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import io.grpc.biz.grpc_cv.Grpc_cvGrpc;
import net.devh.boot.grpc.client.inject.GrpcClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AIGrpcClientService {
    private static final Logger log = LoggerFactory.getLogger(AIGrpcClientService.class);
    @GrpcClient(value="ai-grpc-server")
    private Grpc_cvGrpc.Grpc_cvBlockingStub grpcStub;

    public JSONObject sendMessage(String requestJson) {
        long start = System.currentTimeMillis();
        log.debug("\u5f00\u59cb\u8bf7\u6c42grpc-{} :{}", (Object)start, (Object)requestJson);
        JSONObject result = new JSONObject();
        String grpcReturnStr = "";
        try {
            Message.JsonRequest jsonRequest = Message.JsonRequest.newBuilder().setJsonRequest(requestJson).build();
            Message.JsonReply jsonReply = this.grpcStub.doCv(jsonRequest);
            grpcReturnStr = jsonReply.getJsonReply();
            result = JSONObject.parseObject((String)grpcReturnStr);
            String grpcResult = result.toJSONString();
            log.debug("grpc-{} \u6b63\u5e38\u89e3\u6790\u540e\u8fd4\u56de\u6570\u636e :{}", (Object)start, (Object)grpcResult);
        }
        catch (JSONException e) {
            result.put("error_msg", (Object)e.getMessage());
            log.warn("grpc-{} \u8fd4\u56de\u6570\u636ejson\u89e3\u6790\u5f02\u5e38 :{}", (Object)start, (Object)grpcReturnStr);
            log.error("grpc\u5f02\u5e38\u8fd4\u56de\u6570\u636ejson\u89e3\u6790\u5f02\u5e38", (Throwable)e);
        }
        catch (Exception e) {
            result.put("error_msg", (Object)"\u8bf7\u6c42grpc\u672a\u77e5\u5f02\u5e38");
            log.warn("grpc-{} \u8bf7\u6c42\u5f02\u5e38 :{}", (Object)start, (Object)result.toJSONString());
            log.error("\u8bf7\u6c42grpc\u9519\u8bef", (Throwable)e);
        }
        log.debug("grpc-{} \u8fd4\u56de\u7ed3\u679c\uff0c\u8017\u65f6 {} ", (Object)start, (Object)(System.currentTimeMillis() - start));
        return result;
    }
}

