/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.attendance;

import com.biz.eisp.api.feign.MdmApiFeign;
import com.biz.eisp.attendance.entity.TsFreesignConfigEntity;
import com.biz.eisp.attendance.entity.TsLeaveEntity;
import com.biz.eisp.attendance.entity.TsSignTypeEntity;
import com.biz.eisp.attendance.entity.TsTravelEntity;
import com.biz.eisp.attendance.entity.TsWorkSignEntity;
import com.biz.eisp.attendance.service.TsWorkSignService;
import com.biz.eisp.attendance.vo.TsFreesignConfigVo;
import com.biz.eisp.attendance.vo.TsLeaveVo;
import com.biz.eisp.attendance.vo.TsSignTypeVo;
import com.biz.eisp.attendance.vo.TsTravelVo;
import com.biz.eisp.attendance.vo.TsWorkSignVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.org.TmOrgVo;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.params.Constant;
import com.biz.eisp.tree.TreeGrid;
import com.biz.eisp.user.TmUserQueryVo;
import com.biz.eisp.user.TmUserVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/tsWorkSignController"})
public class TsWorkSignController {
    @Autowired
    TsWorkSignService tsWorkSignService;
    @Autowired
    MdmApiFeign mdmApiFeign;

    @RequestMapping(value={"goWorkSignMain"})
    public String goWorkSignMain(HttpServletRequest request, Model model) {
        return "tsworksign/goWorkSignMain";
    }

    @RequestMapping(value={"toTsSignTypePage"})
    public String toTsSignTypePage(HttpServletRequest request, Model model) {
        return "tsworksign/toTsSignTypePage";
    }

    @RequestMapping(value={"toTmOrgListMain"})
    public String toTmOrgListMain(HttpServletRequest request, Model model) {
        return "tsworksign/TmOrgListMain";
    }

    @RequestMapping(value={"toUserListMain"})
    public String toUserListMain(HttpServletRequest request, Model model) {
        return "tsworksign/toUserListMain";
    }

    @RequestMapping(value={"goWorkSignMainReport"})
    public String goWorkSignMainReport(HttpServletRequest request, Model model) {
        return "tsworksign/goWorkSignMainReport";
    }

    @RequestMapping(value={"goLeaveReport"})
    public String goLeaveReport(HttpServletRequest request, Model model) {
        model.addAttribute("leaveType", (Object)Constant.tsleaveType.replaceStr());
        model.addAttribute("bpmStatus", (Object)Constant.leaveBpmStatus.replaceStr());
        return "tsworksign/goLeaveReport";
    }

    @RequestMapping(value={"goTravelReport"})
    public String goTravelReport(HttpServletRequest request, Model model) {
        model.addAttribute("bpmStatus", (Object)Constant.leaveBpmStatus.replaceStr());
        return "tsworksign/goTravelReport";
    }

    @RequestMapping(value={"findTsFreesignConfigPage"})
    @ResponseBody
    public DataGrid findTsFreesignConfigPage(HttpServletRequest request, TsFreesignConfigVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<TsFreesignConfigEntity> ttSalesPlansVoPageInfo = this.tsWorkSignService.findTsFreesignConfigPage(vo, (Page)page);
        if (ttSalesPlansVoPageInfo != null) {
            return new DataGrid(ttSalesPlansVoPageInfo);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"findTsSignTypeList"})
    @ResponseBody
    public DataGrid findTsSignTypeList(HttpServletRequest request, TsSignTypeVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<TsSignTypeVo> ttSalesPlansVoPageInfo = this.tsWorkSignService.findTsSignTypeList(vo, (Page)page);
        if (ttSalesPlansVoPageInfo != null) {
            return new DataGrid(ttSalesPlansVoPageInfo);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"toAddPage"})
    public String toAddPage(HttpServletRequest request, TsFreesignConfigVo vo, Model model) {
        TsFreesignConfigVo tsFreesignConfigVo = null;
        if (StringUtil.isNotEmpty((CharSequence)vo.getId())) {
            tsFreesignConfigVo = this.tsWorkSignService.findTsFreesignConfigById(vo.getId());
            if (StringUtil.isEmpty((String)tsFreesignConfigVo.getObjStrJson())) {
                tsFreesignConfigVo.setObjStrJson("[]");
            }
            model.addAttribute("vo", (Object)tsFreesignConfigVo);
        } else {
            tsFreesignConfigVo = new TsFreesignConfigVo();
            tsFreesignConfigVo.setObjStrJson("[]");
            model.addAttribute("vo", (Object)tsFreesignConfigVo);
        }
        return "tsworksign/toAddPage";
    }

    @RequestMapping(value={"toAddTsSignTypePage"})
    public String toAddTsSignTypePage(HttpServletRequest request, TsSignTypeVo vo, Model model) {
        if (StringUtil.isNotEmpty((CharSequence)vo.getId())) {
            TsSignTypeEntity entity = this.tsWorkSignService.getTsSignTypeEntityById(vo.getId());
            model.addAttribute("vo", (Object)entity);
        } else {
            model.addAttribute("vo", (Object)new TsSignTypeEntity());
        }
        return "tsworksign/toAddTsSignTypePage";
    }

    @RequestMapping(value={"addSignType"})
    @ResponseBody
    public AjaxJson addSignType(TsSignTypeVo vo) {
        AjaxJson ajaxJson = this.tsWorkSignService.addSignType(vo);
        return ajaxJson;
    }

    @RequestMapping(value={"addTsFreesignConfig"})
    @ResponseBody
    public AjaxJson addTsFreesignConfig(TsFreesignConfigVo vo) {
        AjaxJson ajaxJson = this.tsWorkSignService.addTsFreesignConfig(vo);
        return ajaxJson;
    }

    @RequestMapping(value={"deleteSignType"})
    @ResponseBody
    public AjaxJson deleteSignType(TsSignTypeVo vo) {
        AjaxJson ajaxJson = this.tsWorkSignService.deleteSignType(vo);
        return ajaxJson;
    }

    @RequestMapping(value={"getTmOrgEntityTree"})
    @ResponseBody
    public List<TreeGrid> getTmOrgEntityTree(TmOrgVo tmOrgVo) {
        AjaxJson treeGrids = this.mdmApiFeign.getTmOrgEntityTree(tmOrgVo);
        return treeGrids.getObjList();
    }

    @RequestMapping(value={"getAllUserList"})
    @ResponseBody
    public DataGrid getAllUserList(HttpServletRequest request, TmUserVo query) {
        EuPage page = new EuPage(request);
        TmUserQueryVo vo = new TmUserQueryVo();
        if (StringUtil.isNotEmpty((CharSequence)query.getUsername())) {
            vo.setUsername(query.getUsername());
        }
        if (StringUtil.isNotEmpty((CharSequence)query.getFullname())) {
            vo.setRealName(query.getFullname());
        }
        AjaxJson ttSalesPlansVoPageInfo = this.mdmApiFeign.getAllUserList(vo);
        PageInfo pageInfo = new PageInfo();
        pageInfo.setList(ttSalesPlansVoPageInfo.getObjList());
        if (ttSalesPlansVoPageInfo != null) {
            return new DataGrid(pageInfo);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"findWorkSignReportList"})
    @ResponseBody
    public DataGrid findWorkSignReportList(HttpServletRequest request, TsWorkSignVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<TsWorkSignEntity> ttSalesPlansVoPageInfo = this.tsWorkSignService.findWorkSignReportList(vo, (Page)page);
        if (ttSalesPlansVoPageInfo != null) {
            return new DataGrid(ttSalesPlansVoPageInfo);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"findLeaveReportList"})
    @ResponseBody
    public DataGrid findLeaveReportList(HttpServletRequest request, TsLeaveVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<TsLeaveEntity> ttSalesPlansVoPageInfo = this.tsWorkSignService.findLeaveReportList(vo, (Page)page);
        if (ttSalesPlansVoPageInfo != null) {
            return new DataGrid(ttSalesPlansVoPageInfo);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"findTravelReportList"})
    @ResponseBody
    public DataGrid findTravelReportList(HttpServletRequest request, TsTravelVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<TsTravelEntity> ttSalesPlansVoPageInfo = this.tsWorkSignService.findTravelReportList(vo, (Page)page);
        if (ttSalesPlansVoPageInfo != null) {
            return new DataGrid(ttSalesPlansVoPageInfo);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }
}

