/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.collection.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.BaseController;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.collection.entity.TsInputConfigEntity;
import com.biz.eisp.collection.service.TsInputConfigService;
import com.biz.eisp.collection.vo.TsInputConfigVo;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/tsInputConfigController"})
public class TsInputConfigController
extends BaseController {
    @Autowired
    private TsInputConfigService tsInputConfigService;

    @RequestMapping(value={"goTsInputConfigMain"})
    public ModelAndView goTsInputConfigMain(HttpServletRequest request) {
        ModelAndView view = new ModelAndView("com/biz/eisp/sfa/collection/tsInputConfigMain");
        return view;
    }

    @RequestMapping(value={"findTsInputConfigList"})
    @ResponseBody
    public DataGrid findTsInputConfigList(TsInputConfigVo tsInputConfigVo, String ids, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        ArrayList<String> idsList = new ArrayList<String>();
        if (ids != null && ids.length() > 0) {
            String[] idList;
            for (String s : idList = ids.split(",")) {
                if (s == null || s.length() <= 0) continue;
                idsList.add(s);
            }
        }
        PageInfo<TsInputConfigEntity> result = this.tsInputConfigService.findTsInputConfigVoList(tsInputConfigVo, idsList, (Page)page);
        return new DataGrid(result);
    }

    @RequestMapping(value={"goTsInputConfigForm"})
    public ModelAndView goTsInputConfigForm(TsInputConfigVo tsInputConfigVo, HttpServletRequest req) {
        if (!StringUtil.isEmpty((Object)tsInputConfigVo.getId())) {
            TsInputConfigEntity entity = (TsInputConfigEntity)this.tsInputConfigService.selectByPrimaryKey(tsInputConfigVo.getId());
            req.setAttribute("vo", (Object)entity);
        }
        return new ModelAndView("com/biz/eisp/sfa/collection/tsInputConfigFrom");
    }

    @RequestMapping(value={"saveTsInputConfig"})
    @ResponseBody
    public AjaxJson saveTsInputConfig(TsInputConfigVo tsInputConfigVo) {
        AjaxJson j = new AjaxJson();
        try {
            this.tsInputConfigService.saveTsInputConfig(tsInputConfigVo);
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u64cd\u4f5c\u5931\u8d25:" + e.getMessage());
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(value={"checkData"})
    @ResponseBody
    public AjaxJson checkData(String id, String lableName, String inputType) {
        AjaxJson j = new AjaxJson();
        j.setSuccess(true);
        j.setMsg("\u63a7\u4ef6\u7c7b\u578b\u5bf9\u5e94\u7684\u540d\u79f0\u5df2\u5b58\u5728");
        try {
            List<TsInputConfigEntity> list = this.tsInputConfigService.getListByNameAndType(id, lableName, inputType);
            boolean flag = true;
            if (list != null && list.size() > 0) {
                for (TsInputConfigEntity entity : list) {
                    if (!StringUtil.isEmpty((String)id)) {
                        if (id.equals(entity.getId())) continue;
                        flag = false;
                        continue;
                    }
                    flag = false;
                }
            }
            j.setSuccess(flag);
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u64cd\u4f5c\u5931\u8d25:" + e.getMessage());
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(value={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(Integer ids, HttpServletRequest request, HttpServletResponse response) {
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson.setMsg("\u5220\u9664\u5931\u8d25");
        ajaxJson.setSuccess(false);
        try {
            boolean result = this.tsInputConfigService.doBatchDel(ids);
            if (result) {
                ajaxJson.setSuccess(true);
                ajaxJson.setMsg("\u5220\u9664\u6210\u529f");
            } else {
                ajaxJson.setMsg("\u5220\u9664\u5931\u8d25\u63a7\u4ef6\u5df2\u88ab\u4f7f\u7528");
            }
        }
        catch (Exception var6) {
            var6.printStackTrace();
            ajaxJson.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return ajaxJson;
    }

    @RequestMapping(value={"selectInputConfig"})
    public ModelAndView selectInputConfig(String ids, HttpServletRequest request) {
        request.setAttribute("ids", (Object)ids);
        return new ModelAndView("com/biz/eisp/sfa/collection/tsInputConfigSelect");
    }
}

