/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.ai.terminal;

import com.biz.eisp.ai.display.vo.TsAiCheckApiVo;
import com.biz.eisp.ai.display.vo.TsAiCheckVo;
import com.biz.eisp.ai.display.vo.TsAiDetailVo;
import com.biz.eisp.ai.display.vo.TsAiResultApiGroupVo;
import com.biz.eisp.ai.display.vo.TsCheckStatusVo;
import com.biz.eisp.api.feign.TmTerminalFeign;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.params.Constant;
import com.biz.eisp.sfa.TsAiCheckFegin;
import com.biz.eisp.terminal.TmTerminalVo;
import com.biz.eisp.tools.DictUtil;
import com.biz.eisp.utils.Result;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"AI\u68c0\u6838"})
@RestController
@RequestMapping(value={"/ai/tsTerminalController"})
public class TsTerminalController {
    @Autowired
    private TmTerminalFeign tmTerminalFeign;
    @Autowired
    private TsAiCheckFegin tsAiCheckFegin;

    @ApiOperation(value="\u67e5\u8be2\u68c0\u6d4b\u95e8\u5e97", notes="\u67e5\u8be2\u68c0\u6d4b\u95e8\u5e97", httpMethod="GET")
    @GetMapping(value={"findAITerminal"})
    public Result<PageInfo<TmTerminalVo>> findAITerminal(@RequestParam(value="page") Integer page, @RequestParam(value="rows") Integer rows) {
        Result<PageInfo<TmTerminalVo>> j = new Result<PageInfo<TmTerminalVo>>();
        try {
            HashMap<String, Integer> param = new HashMap<String, Integer>();
            param.put("page", page);
            param.put("rows", rows);
            PageInfo info = ApiResultUtil.pageInfoResult((AjaxJson)this.tmTerminalFeign.getTerminalPage(param));
            this.getIsCheck((PageInfo<TmTerminalVo>)info);
            j.setObj((PageInfo<TmTerminalVo>)info);
        }
        catch (BusinessException e) {
            j.setMsg(e.getMessage());
            j.setSuccess(false);
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setMsg("\u67e5\u8be2\u5931\u8d25");
            j.setSuccess(false);
        }
        return j;
    }

    private void getIsCheck(PageInfo<TmTerminalVo> info) {
        List terms = info.getList();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)terms)) {
            List codes = terms.stream().map(TmTerminalVo::getTerminalCode).collect(Collectors.toList());
            TsCheckStatusVo vo = new TsCheckStatusVo();
            vo.setTerm(true);
            vo.setCodes(codes);
            AjaxJson j = this.tsAiCheckFegin.checkStatus(vo);
            if (j.isSuccess()) {
                Map map = j.getAttributes();
                if (map != null) {
                    terms.forEach(item -> {
                        if (map.containsKey(item.getTerminalCode())) {
                            item.setFlagId("1");
                        } else {
                            item.setFlagId("0");
                        }
                    });
                }
            } else {
                throw new BusinessException(j.getMsg());
            }
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u68c0\u6d4b\u7ec4\u6570\u636e", notes="\u67e5\u8be2\u68c0\u6d4b\u7ec4\u6570\u636e", httpMethod="GET")
    @GetMapping(value={"findAIGroup"})
    public Result<TsAiResultApiGroupVo> findAIGroup(@RequestParam(value="terminalCode", required=false) String terminalCode, @RequestParam(value="isTerm") boolean isTerm) {
        Result<TsAiResultApiGroupVo> j = new Result<TsAiResultApiGroupVo>();
        try {
            ArrayList<TsAiResultApiGroupVo> terms = new ArrayList<TsAiResultApiGroupVo>();
            List list = DictUtil.getDictList((String)Constant.aiProject.ai_project_group.getVal());
            if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                this.getTerms(terminalCode, terms, list, isTerm);
                j.setObjList(terms);
            } else {
                j.setSuccess(false);
                j.setMsg("\u672a\u914d\u7f6e\u6570\u636e");
            }
        }
        catch (BusinessException e) {
            j.setMsg(e.getMessage());
            j.setSuccess(false);
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u67e5\u8be2\u5931\u8d25");
        }
        return j;
    }

    @ApiOperation(value="\u4fdd\u5b58\u68c0\u6d4b\u6570\u636e", notes="\u4fdd\u5b58\u68c0\u6d4b\u6570\u636e", httpMethod="POST")
    @PostMapping(value={"saveAiCheck"})
    public Result saveAiCheck(@RequestBody TsAiCheckVo vo) {
        Result<Object> j = new Result<Object>();
        try {
            AjaxJson ajaxJson = this.tsAiCheckFegin.saveCheckData(vo);
            if (!ajaxJson.isSuccess()) {
                j.setSuccess(false);
                j.setMsg(ajaxJson.getMsg());
            }
            j.setObj(ajaxJson.getObj());
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u67e5\u8be2\u5931\u8d25");
        }
        return j;
    }

    private void getTerms(String terminalCode, List<TsAiResultApiGroupVo> terms, List<KnlDictDataEntity> list, boolean isTerm) {
        list.forEach(item -> {
            Map extendMap = item.getExtendMap();
            if (extendMap != null && extendMap.size() > 0) {
                TsAiResultApiGroupVo vo = new TsAiResultApiGroupVo();
                vo.setDictCode(OConvertUtils.getString(extendMap.get("dictCode")));
                vo.setDictValue(OConvertUtils.getString(extendMap.get("dictValue")));
                vo.setIsTerminalType(OConvertUtils.getString(extendMap.get("isTerminalType")));
                vo.setOrderNum(Integer.valueOf(OConvertUtils.getInt((String)extendMap.get("orderNum").toString())));
                vo.setProjecta(OConvertUtils.getString(extendMap.get("project_a")));
                vo.setProjectb(OConvertUtils.getString(extendMap.get("project_b")));
                vo.setProjectc(OConvertUtils.getString(extendMap.get("project_c")));
                String isTermType = "0";
                if (isTerm) {
                    isTermType = "1";
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getIsTerminalType()) && vo.getIsTerminalType().equals(isTermType)) {
                    terms.add(vo);
                }
            }
        });
        List codes = terms.stream().map(TsAiResultApiGroupVo::getDictCode).collect(Collectors.toList());
        TsCheckStatusVo vo = new TsCheckStatusVo();
        vo.setTerm(isTerm);
        vo.setCodes(codes);
        vo.setTerminalCode(terminalCode);
        AjaxJson j = this.tsAiCheckFegin.checkStatus(vo);
        if (j.isSuccess()) {
            Map map = j.getAttributes();
            if (map != null) {
                terms.forEach(item -> {
                    if (map.containsKey(item.getDictCode())) {
                        item.setStatus(Integer.valueOf(1));
                        item.setCheckId(Integer.valueOf(Integer.parseInt(map.get("checkId").toString())));
                    } else {
                        item.setStatus(Integer.valueOf(0));
                    }
                });
            }
        } else {
            throw new BusinessException(j.getMsg());
        }
        Collections.sort(terms, Comparator.comparing(TsAiResultApiGroupVo::getOrderNum));
    }

    @ApiOperation(value="\u67e5\u8be2\u68c0\u6d4b\u5217\u8868", notes="\u67e5\u8be2\u68c0\u6d4b\u5217\u8868", httpMethod="POST")
    @PostMapping(value={"findAICheckPage"})
    public Result<PageInfo<TsAiCheckVo>> findAICheckPage(@RequestBody TsAiCheckApiVo vo) {
        Result<PageInfo<TsAiCheckVo>> j = new Result<PageInfo<TsAiCheckVo>>();
        PageInfo info = ApiResultUtil.pageInfoResult((AjaxJson)this.tsAiCheckFegin.findAICheckPage(vo));
        j.setObj(info);
        return j;
    }

    @ApiOperation(value="\u6839\u636e\u8bc6\u522b\u7ec4\u7f16\u7801+\u95e8\u5e97+\u7528\u6237id+\u65e5\u671f\uff0c\u83b7\u53d6\u5f53\u524d\u8bc6\u522b\u7ec4\u5bf9\u5e94\u6570\u636e", notes="\u83b7\u53d6\u5f53\u524d\u8bc6\u522b\u7ec4\u5bf9\u5e94\u6570\u636e", httpMethod="POST")
    @PostMapping(value={"getAICheckData"})
    public Result<TsAiCheckVo> getAICheckData(@RequestBody TsAiCheckApiVo vo) {
        Result<TsAiCheckVo> j = new Result<TsAiCheckVo>();
        j.setObj((TsAiCheckVo)ApiResultUtil.objResult((AjaxJson)this.tsAiCheckFegin.getAICheckData(vo)));
        return j;
    }

    @ApiOperation(value="\u6839\u636e\u68c0\u6838id \u67e5\u8be2\u5bf9\u5e94\u8bc6\u522b\u660e\u7ec6", notes="\u6839\u636e\u68c0\u6838id \u67e5\u8be2\u5bf9\u5e94\u8bc6\u522b\u660e\u7ec6", httpMethod="POST")
    @PostMapping(value={"getAICheckDetail"})
    public Result<TsAiDetailVo> getAICheckDetail(@RequestParam(value="id") String id) {
        Result<TsAiDetailVo> j = new Result<TsAiDetailVo>();
        j.setObj((TsAiDetailVo)ApiResultUtil.objResult((AjaxJson)this.tsAiCheckFegin.getAICheckDetail(id)));
        return j;
    }
}

