/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.disproduct.service.impl;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.disproduct.dao.TsDisProductDao;
import com.biz.eisp.disproduct.entity.TsDisProductEntity;
import com.biz.eisp.disproduct.service.TsDisProductService;
import com.biz.eisp.disproduct.vo.ImportDisProductVo;
import com.biz.eisp.disproduct.vo.TsDisProductVo;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class TsDisProductServiceImpl
extends BaseServiceImpl<TsDisProductEntity>
implements TsDisProductService {
    @Autowired
    TsDisProductDao tsDisProductDao;

    @Override
    public PageInfo<TsDisProductEntity> findDisProductList(TsDisProductVo vo, Page page) {
        PageInfo list = PageAutoHelperUtil.generatePage(() -> this.tsDisProductDao.findDisProductList(vo), (Page)page);
        return list;
    }

    @Override
    public AjaxJson checkImportList(List list) {
        AjaxJson ajaxJson = new AjaxJson();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            ajaxJson.setErrMsg("\u4e0a\u4f20\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            return ajaxJson;
        }
        for (int i = 0; i < list.size(); ++i) {
            ImportDisProductVo vo = (ImportDisProductVo)list.get(i);
            if (StringUtil.isEmpty((String)vo.getProductCode())) {
                ajaxJson.setErrMsg("\u7b2c" + (i + 1) + "\u884c\uff0c\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                return ajaxJson;
            }
            if (StringUtil.isEmpty((String)vo.getProductName())) {
                ajaxJson.setErrMsg("\u7b2c" + (i + 1) + "\u884c\uff0c\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                return ajaxJson;
            }
            if (StringUtil.isEmpty((String)vo.getTernimalCode())) {
                ajaxJson.setErrMsg("\u7b2c" + (i + 1) + "\u884c\uff0c\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                return ajaxJson;
            }
            if (!StringUtil.isEmpty((String)vo.getTernimalName())) continue;
            ajaxJson.setErrMsg("\u7b2c" + (i + 1) + "\u884c\uff0c\u95e8\u5e97\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            return ajaxJson;
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson saveProductList(List list) {
        AjaxJson ajaxJson = new AjaxJson();
        List entities = list;
        if (CollectionUtil.listNotEmptyNotSizeZero((List)entities)) {
            for (ImportDisProductVo entity : entities) {
                TsDisProductEntity entity1 = new TsDisProductEntity();
                BeanUtils.copyProperties((Object)entity, (Object)entity1);
                Example example = new Example(TsDisProductEntity.class);
                Example.Criteria criteria = example.createCriteria();
                criteria.andEqualTo("ternimalCode", (Object)entity1.getTernimalCode());
                criteria.andEqualTo("ternimalName", (Object)entity1.getTernimalName());
                criteria.andEqualTo("productCode", (Object)entity1.getProductCode());
                criteria.andEqualTo("productName", (Object)entity1.getProductName());
                this.tsDisProductDao.deleteByExample(example);
                this.tsDisProductDao.insertSelective(entity1);
            }
        }
        return ajaxJson;
    }
}

