/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.actcheck;

import com.biz.eisp.act.vo.TtActDetailVo;
import com.biz.eisp.actcheck.entity.TsActCheckEntity;
import com.biz.eisp.actcheck.service.TsActCheckService;
import com.biz.eisp.actcheck.vo.TsActCheckVo;
import com.biz.eisp.api.feign.CustomerFeign;
import com.biz.eisp.api.feign.TmTerminalFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.common.SfaConstantEnum;
import com.biz.eisp.customer.TmCustomerVo;
import com.biz.eisp.picture.entity.TsPictureEntity;
import com.biz.eisp.sfa.act.TtActApiFeign;
import com.biz.eisp.terminal.TmTerminalVo;
import com.biz.eisp.tpm.SfaAiFegin;
import com.biz.eisp.utils.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sfaApi/tsActCheckController"})
@Api(tags={"\u6d3b\u52a8\u68c0\u67e5"})
public class TsActCheckController {
    @Autowired
    private TtActApiFeign ttActApiFeign;
    @Autowired
    private TmTerminalFeign tmTerminalFeign;
    @Autowired
    private CustomerFeign customerFeign;
    @Autowired
    private TsActCheckService tsActCheckService;
    @Autowired
    private SfaAiFegin sfaAiFegin;

    @GetMapping(value={"findActDetailByCon"})
    @ApiOperation(value="\u67e5\u8be2\u53ef\u68c0\u6d4b\u6d3b\u52a8", notes="\u67e5\u8be2\u53ef\u68c0\u6d4b\u6d3b\u52a8", httpMethod="GET")
    public Result<TtActDetailVo> findActDetailByCon(@RequestParam(value="clientId") String clientId, @RequestParam(value="clientType") String clientType) {
        Result<TtActDetailVo> j = new Result<TtActDetailVo>();
        try {
            String clientCode = this.getClientCode(clientId, clientType);
            if (StringUtils.isNotBlank((CharSequence)clientCode)) {
                j.setObjList(ApiResultUtil.listResult((AjaxJson)this.ttActApiFeign.findActDetailByCon(clientCode, clientType)));
            } else {
                j.setSuccess(false);
                j.setMsg("\u6d3b\u52a8\u7f51\u70b9\u4e0d\u5b58\u5728\uff01");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u83b7\u53d6\u53ef\u6267\u884c\u6d3b\u52a8\u5217\u8868\u5931\u8d25");
        }
        return j;
    }

    private String getClientCode(String clientId, String clientType) {
        TmTerminalVo tmTerminalVo;
        String clientCode = "";
        if (StringUtils.isNotBlank((CharSequence)clientType) && clientType.equals(SfaConstantEnum.CusType.channel.getVal())) {
            TmCustomerVo customerVo = (TmCustomerVo)ApiResultUtil.objResult((AjaxJson)this.customerFeign.getCustomerByIdOrCode(clientId, ""));
            if (customerVo != null) {
                clientCode = customerVo.getCustomerCode();
            }
        } else if (StringUtils.isNotBlank((CharSequence)clientType) && clientType.equals(SfaConstantEnum.CusType.terminal_type.getVal()) && (tmTerminalVo = (TmTerminalVo)ApiResultUtil.objResult((AjaxJson)this.tmTerminalFeign.getTerminalById(clientId))) != null) {
            clientCode = tmTerminalVo.getTerminalCode();
        }
        return clientCode;
    }

    @PostMapping(value={"saveCheckAct"})
    @ApiOperation(value="\u63d0\u4ea4\u6d3b\u52a8\u68c0\u6d4b\u6570\u636e", notes="\u63d0\u4ea4\u6d3b\u52a8\u68c0\u6d4b\u6570\u636e", httpMethod="POST")
    public Result saveCheckAct(@RequestBody TsActCheckVo vo) {
        Result j = new Result();
        try {
            this.tsActCheckService.saveCheckAct(vo);
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u63d0\u4ea4\u68c0\u6d4b\u6570\u636e\u5931\u8d25\uff01");
        }
        return j;
    }

    @GetMapping(value={"getCheckActDetail"})
    @ApiOperation(value="\u5386\u53f2\u68c0\u6d4b\u6570\u636e", notes="\u5386\u53f2\u68c0\u6d4b\u6570\u636e", httpMethod="GET")
    public Result<TsActCheckEntity> getCheckActDetail(@RequestParam(value="actDetailCode", required=true) String actDetailCode, @RequestParam(value="visitType", required=true) String visitType, @RequestParam(value="visitId", required=true) Integer visitId) {
        Result<TsActCheckEntity> j = new Result<TsActCheckEntity>();
        try {
            if (StringUtils.isBlank((CharSequence)actDetailCode)) {
                j.setSuccess(false);
                j.setMsg("\u672a\u627e\u5230\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801");
                return j;
            }
            j.setObj(this.tsActCheckService.getCheckActDetail(actDetailCode, visitType, visitId));
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u67e5\u8be2\u68c0\u6d4b\u6570\u636e\u5931\u8d25\uff01");
        }
        return j;
    }

    @PostMapping(value={"dealAIRest"})
    @ApiOperation(value="\u91cd\u65b0\u63d0\u4ea4ai\u68c0\u6838", notes="\u91cd\u65b0\u63d0\u4ea4ai\u68c0\u6838", httpMethod="POST")
    public Result dealAIRest() {
        Result j = new Result();
        try {
            ArrayList<TsPictureEntity> pictureVoList = new ArrayList<TsPictureEntity>();
            TsPictureEntity entity = new TsPictureEntity();
            entity.setImgUrl("http://125.64.5.82:29999/img/2019-09-23/20190923113653910c50a587d844ff8af7bdd363362327.jpg");
            pictureVoList.add(entity);
            this.sfaAiFegin.dealAIRest("A1", pictureVoList, "12");
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u63d0\u4ea4\u68c0\u6d4b\u6570\u636e\u5931\u8d25\uff01");
        }
        return j;
    }
}

