/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.datareport.service.impl;

import com.biz.eisp.attendance.picture.dao.TsPictureDao;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.common.FilePathUtil;
import com.biz.eisp.datareport.dao.TsDataReportDao;
import com.biz.eisp.datareport.dao.TsDatareportProductDao;
import com.biz.eisp.datareport.entity.TsDataReportEntity;
import com.biz.eisp.datareport.entity.TsDatareportProductEntity;
import com.biz.eisp.datareport.service.TsDataReportService;
import com.biz.eisp.datareport.vo.TsDataReportGridVo;
import com.biz.eisp.datareport.vo.TsDataReportVo;
import com.biz.eisp.datareport.vo.TsDatareportProductVo;
import com.biz.eisp.order.dao.TsCompetitiveDao;
import com.biz.eisp.order.entity.TsCompetitiveGoodsEntity;
import com.biz.eisp.order.vo.TsCompetitiveGoodsVo;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.params.Constant;
import com.biz.eisp.picture.entity.TsPictureEntity;
import com.biz.eisp.service.BaseServiceImpl;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class TsDataReportServiceImpl
extends BaseServiceImpl<TsDataReportEntity>
implements TsDataReportService {
    @Autowired
    TsDataReportDao tsDataReportDao;
    @Autowired
    TsDatareportProductDao tsDatareportProductDao;
    @Autowired
    TsPictureDao tsPictureDao;
    @Autowired
    TsCompetitiveDao tsCompetitiveDao;
    @Autowired
    FilePathUtil filePathUtil;

    @Override
    public AjaxJson<TsDatareportProductVo> findProductInfoByPage(TsCompetitiveGoodsVo vo, String page, String rows) {
        AjaxJson ajaxJson = new AjaxJson();
        EuPage page1 = new EuPage();
        if (StringUtil.isEmpty((String)page)) {
            page = "1";
        }
        if (StringUtil.isEmpty((String)rows)) {
            rows = "15";
        }
        page1.setPage(page);
        page1.setRows(rows);
        Example example = new Example(TsCompetitiveGoodsEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)vo.getGoodName())) {
            criteria.andLike("goodName", "%" + vo.getGoodName() + "%");
        }
        List list = this.tsCompetitiveDao.selectByExample(example);
        ArrayList<TsDatareportProductVo> productVos = new ArrayList<TsDatareportProductVo>();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            for (TsCompetitiveGoodsEntity entity : list) {
                TsDatareportProductVo productVo = new TsDatareportProductVo();
                productVo.setBarCode(entity.getGoodBar());
                productVo.setProductInfoCode(entity.getGoodCode());
                productVo.setProductInfoName(entity.getGoodName());
                productVo.setSaleUnit(entity.getGoodUnit());
                productVos.add(productVo);
            }
        }
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> productVos, (Page)page1);
        ajaxJson.setPageInfo(pageInfo);
        return ajaxJson;
    }

    @Override
    public AjaxJson addDataReport(TsDataReportVo vo) {
        List pictureEntities;
        List productEntities;
        AjaxJson ajaxJson = new AjaxJson();
        if (!(ajaxJson = this.valite_addDataReport(vo, ajaxJson)).isSuccess()) {
            return ajaxJson;
        }
        TsDataReportEntity entity = new TsDataReportEntity();
        BeanUtils.copyProperties((Object)vo, (Object)entity);
        this.tsDataReportDao.insertSelective(entity);
        List competitiveEntities = vo.getComList();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)competitiveEntities)) {
            for (TsDatareportProductEntity entity1 : competitiveEntities) {
                entity1.setOtherId(entity.getId() + "");
                entity1.setType(Constant.productType.jp.getValue() + "");
                entity1.setId(null);
                this.tsDatareportProductDao.insertSelective(entity1);
            }
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(productEntities = vo.getProList()))) {
            for (TsDatareportProductEntity entity1 : productEntities) {
                entity1.setOtherId(entity.getId() + "");
                entity1.setType(Constant.productType.sp.getValue() + "");
                entity1.setId(null);
                this.tsDatareportProductDao.insertSelective(entity1);
            }
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(pictureEntities = vo.getPicList()))) {
            for (TsPictureEntity tsPictureEntity : pictureEntities) {
                tsPictureEntity.setBusinessId(entity.getId());
                tsPictureEntity.setImgType(Constant.imgType.sjsb.getValue());
                tsPictureEntity.setId(null);
                this.filePathUtil.getChangePicturePath(tsPictureEntity);
                this.tsPictureDao.insertSelective(tsPictureEntity);
            }
        }
        return ajaxJson;
    }

    private AjaxJson valite_addDataReport(TsDataReportVo vo, AjaxJson ajaxJson) {
        if (StringUtil.isEmpty((String)vo.getTerminalName())) {
            ajaxJson.setErrMsg("\u95e8\u5e97\u540d\u5b57\u5fc5\u4f20");
            return ajaxJson;
        }
        if (StringUtil.isEmpty((String)vo.getTerminalCode())) {
            ajaxJson.setErrMsg("\u95e8\u5e97\u7f16\u7801\u5fc5\u4f20");
            return ajaxJson;
        }
        if (StringUtil.isEmpty((String)vo.getDataType())) {
            ajaxJson.setErrMsg("\u6570\u636e\u7c7b\u578b\u5fc5\u4f20");
            return ajaxJson;
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)vo.getComList())) {
            for (TsDatareportProductEntity tsDatareportProductEntity : vo.getComList()) {
                if (tsDatareportProductEntity.getNum() != null && tsDatareportProductEntity.getNum() > 0) continue;
                ajaxJson.setErrMsg("\u7ade\u54c1\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0");
                return ajaxJson;
            }
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)vo.getProList())) {
            for (TsDatareportProductEntity tsDatareportProductEntity : vo.getProList()) {
                if (tsDatareportProductEntity.getNum() != null && tsDatareportProductEntity.getNum() > 0) continue;
                ajaxJson.setErrMsg("\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0");
                return ajaxJson;
            }
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson<TsDataReportEntity> findDataHistoryList(TsDataReportVo vo, String page, String rows) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtil.isEmpty((String)vo.getDataType())) {
            ajaxJson.setErrMsg("\u6570\u636e\u7c7b\u578b\u5fc5\u4f20");
            return ajaxJson;
        }
        UserRedis userRedis = UserUtils.getUser();
        if (userRedis == null) {
            ajaxJson.setErrMsg("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
            return ajaxJson;
        }
        EuPage page1 = new EuPage();
        if (StringUtil.isEmpty((String)page)) {
            page = "1";
        }
        if (StringUtil.isEmpty((String)rows)) {
            rows = "15";
        }
        page1.setPage(page);
        page1.setRows(rows);
        Example example = new Example(TsDataReportEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("dataType", (Object)vo.getDataType());
        criteria.andEqualTo("createBy", (Object)userRedis.getId());
        example.orderBy("createDate").desc();
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> this.tsDataReportDao.selectByExample(example), (Page)page1);
        List entities = pageInfo.getList();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)entities)) {
            ArrayList<String> ids = new ArrayList<String>();
            for (TsDataReportEntity tsDataReportEntity : entities) {
                ids.add(tsDataReportEntity.getId() + "");
            }
            List<TsDataReportGridVo> gridVos = this.tsDataReportDao.findProductListByIds(ids);
            if (CollectionUtil.listNotEmptyNotSizeZero(gridVos)) {
                HashMap<String, Integer> ttMap = new HashMap<String, Integer>();
                for (TsDataReportGridVo reportGridVo : gridVos) {
                    String key = reportGridVo.getOtherId() + "_" + reportGridVo.getProductCode() + "_" + reportGridVo.getProductType();
                    ttMap.put(key, 0);
                }
                for (TsDataReportEntity tsDataReportEntity : entities) {
                    for (String key : ttMap.keySet()) {
                        String[] strings = key.split("_");
                        if (!StringUtil.equals((String)strings[0], (String)(tsDataReportEntity.getId() + ""))) continue;
                        Integer jpNum = tsDataReportEntity.getJpNum() == null ? 0 : tsDataReportEntity.getJpNum();
                        Integer spNum = tsDataReportEntity.getBpNum() == null ? 0 : tsDataReportEntity.getBpNum();
                        if (StringUtil.equals((String)strings[2], (String)(Constant.productType.sp.getValue() + ""))) {
                            tsDataReportEntity.setBpNum(Integer.valueOf(spNum + 1));
                            continue;
                        }
                        tsDataReportEntity.setJpNum(Integer.valueOf(jpNum + 1));
                    }
                    for (TsDataReportGridVo tsDataReportGridVo : gridVos) {
                        Integer proTotal;
                        Integer bpTotal;
                        if (!StringUtil.equals((String)tsDataReportGridVo.getOtherId(), (String)tsDataReportEntity.getId().toString())) continue;
                        if (StringUtil.equals((String)tsDataReportGridVo.getProductType(), (String)(Constant.productType.sp.getValue() + ""))) {
                            bpTotal = tsDataReportEntity.getBpTotalNum() == null ? 0 : tsDataReportEntity.getBpTotalNum();
                            proTotal = tsDataReportGridVo.getNum() == null ? 0 : tsDataReportGridVo.getNum();
                            tsDataReportEntity.setBpTotalNum(Integer.valueOf(bpTotal + proTotal));
                            continue;
                        }
                        bpTotal = tsDataReportEntity.getJpTotalNum() == null ? 0 : tsDataReportEntity.getJpTotalNum();
                        proTotal = tsDataReportGridVo.getNum() == null ? 0 : tsDataReportGridVo.getNum();
                        tsDataReportEntity.setJpTotalNum(Integer.valueOf(bpTotal + proTotal));
                    }
                }
            }
        }
        ajaxJson.setPageInfo(pageInfo);
        return ajaxJson;
    }

    @Override
    public AjaxJson<TsDataReportVo> findDataReportInfo(TsDataReportVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtil.isEmpty((String)vo.getId())) {
            ajaxJson.setErrMsg("id\u5fc5\u4f20");
            return ajaxJson;
        }
        TsDataReportEntity entity = (TsDataReportEntity)this.tsDataReportDao.selectByPrimaryKey(vo.getId());
        if (entity == null) {
            ajaxJson.setErrMsg("\u83b7\u53d6\u5b9e\u4f53\u5931\u8d25");
            return ajaxJson;
        }
        TsDataReportVo tsDataReportVo = new TsDataReportVo();
        BeanUtils.copyProperties((Object)entity, (Object)tsDataReportVo);
        tsDataReportVo.setId(entity.getId() + "");
        Example example1 = new Example(TsDatareportProductEntity.class);
        Example.Criteria criteria1 = example1.createCriteria();
        criteria1.andEqualTo("otherId", (Object)vo.getId());
        criteria1.andEqualTo("type", (Object)(Constant.productType.jp.getValue() + ""));
        List list1 = this.tsDatareportProductDao.selectByExample(example1);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list1)) {
            tsDataReportVo.setComList(list1);
        }
        Example example2 = new Example(TsDatareportProductEntity.class);
        Example.Criteria criteria2 = example2.createCriteria();
        criteria2.andEqualTo("otherId", (Object)vo.getId());
        criteria2.andEqualTo("type", (Object)(Constant.productType.sp.getValue() + ""));
        List list2 = this.tsDatareportProductDao.selectByExample(example2);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list2)) {
            tsDataReportVo.setProList(list2);
        }
        Example example3 = new Example(TsPictureEntity.class);
        Example.Criteria criteria3 = example3.createCriteria();
        criteria3.andEqualTo("businessId", (Object)Integer.valueOf(vo.getId()));
        criteria3.andEqualTo("imgType", (Object)Constant.imgType.sjsb.getValue());
        List list3 = this.tsPictureDao.selectByExample(example3);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list3)) {
            tsDataReportVo.setPicList(list3);
        }
        ajaxJson.setObj((Object)tsDataReportVo);
        return ajaxJson;
    }

    @Override
    public PageInfo<TsDataReportGridVo> findPhMainList(TsDataReportGridVo vo, Page page) {
        UserRedis userRedis = UserUtils.getUser();
        vo.setCreateBy(userRedis.getId());
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> this.tsDataReportDao.findProductList(vo), (Page)page);
        return pageInfo;
    }
}

