/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.worktask.service.impl;

import com.biz.eisp.attendance.picture.dao.TsPictureDao;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.common.FilePathUtil;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.params.Constant;
import com.biz.eisp.picture.entity.TsPictureEntity;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.worktask.dao.TsWorkTaskDao;
import com.biz.eisp.worktask.entity.TsWorkTaskEntity;
import com.biz.eisp.worktask.service.TsWorkTaskService;
import com.biz.eisp.worktask.vo.TsWorkTaskVo;
import com.github.pagehelper.PageInfo;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class TsWorkTaskServiceImpl
extends BaseServiceImpl<TsWorkTaskEntity>
implements TsWorkTaskService {
    @Autowired
    TsWorkTaskDao tsWorkTaskDao;
    @Autowired
    TsPictureDao tsPictureDao;
    @Autowired
    FilePathUtil filePathUtil;

    @Override
    public PageInfo<TsWorkTaskEntity> findPageList(TsWorkTaskVo vo, Page page) {
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> this.tsWorkTaskDao.findPageList(vo), (Page)page);
        List list1 = pageInfo.getList();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list1)) {
            for (TsWorkTaskEntity tsWorkTaskVo : list1) {
                Example picexample = new Example(TsPictureEntity.class);
                Example.Criteria piccriteria = picexample.createCriteria();
                piccriteria.andEqualTo("businessId", (Object)tsWorkTaskVo.getId());
                List pictureEntities = this.tsPictureDao.selectByExample(picexample);
                if (!CollectionUtil.listNotEmptyNotSizeZero((List)pictureEntities)) continue;
                for (int i = 0; i < pictureEntities.size(); ++i) {
                    if (i == 0) {
                        tsWorkTaskVo.setDoorwayUrl1(((TsPictureEntity)pictureEntities.get(i)).getImgUrl());
                        continue;
                    }
                    if (i == 1) {
                        tsWorkTaskVo.setDoorwayUrl2(((TsPictureEntity)pictureEntities.get(i)).getImgUrl());
                        continue;
                    }
                    if (i == 2) {
                        tsWorkTaskVo.setDoorwayUrl3(((TsPictureEntity)pictureEntities.get(i)).getImgUrl());
                        continue;
                    }
                    if (i == 3) {
                        tsWorkTaskVo.setDoorwayUrl4(((TsPictureEntity)pictureEntities.get(i)).getImgUrl());
                        continue;
                    }
                    if (i != 4) continue;
                    tsWorkTaskVo.setDoorwayUrl5(((TsPictureEntity)pictureEntities.get(i)).getImgUrl());
                }
            }
        }
        return pageInfo;
    }

    @Override
    public AjaxJson addWorkTask(TsWorkTaskVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        UserRedis userRedis = UserUtils.getUser();
        if (userRedis == null) {
            ajaxJson.setErrMsg("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
            return ajaxJson;
        }
        if (StringUtil.isEmpty((String)vo.getTaskContent())) {
            ajaxJson.setErrMsg("\u4efb\u52a1\u5185\u5bb9\u5fc5\u586b");
            return ajaxJson;
        }
        if (StringUtil.isEmpty((String)vo.getExecutorBy())) {
            ajaxJson.setErrMsg("\u6267\u884c\u4eba\u5fc5\u9009");
            return ajaxJson;
        }
        if (StringUtil.isEmpty((String)vo.getEndTime())) {
            ajaxJson.setErrMsg("\u622a\u6b62\u65f6\u95f4\u5fc5\u586b");
            return ajaxJson;
        }
        TsWorkTaskEntity entity = new TsWorkTaskEntity();
        BeanUtils.copyProperties((Object)vo, (Object)entity);
        entity.setCreateBy(userRedis.getId());
        entity.setReleaseTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        entity.setTaskStatus(Constant.worktaskEnum.dcl.getValue());
        this.tsWorkTaskDao.insertSelective(entity);
        List imgList = vo.getImgList();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)imgList)) {
            for (TsPictureEntity tsPictureEntity1 : imgList) {
                tsPictureEntity1.setBusinessId(entity.getId());
                tsPictureEntity1.setImgType(Constant.imgType.tjrw.getValue());
                this.filePathUtil.getChangePicturePath(tsPictureEntity1);
                this.tsPictureDao.insertSelective(tsPictureEntity1);
            }
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson<TsWorkTaskVo> getWorkTaskList(TsWorkTaskVo vo, String page, String rows) {
        AjaxJson ajaxJson = new AjaxJson();
        UserRedis userRedis = UserUtils.getUser();
        if (userRedis == null) {
            ajaxJson.setErrMsg("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
            return ajaxJson;
        }
        EuPage page1 = new EuPage();
        if (StringUtil.isEmpty((String)page)) {
            page = "1";
        }
        if (StringUtil.isEmpty((String)rows)) {
            rows = "15";
        }
        page1.setPage(page);
        page1.setRows(rows);
        Example picexample = new Example(TsWorkTaskEntity.class);
        Example.Criteria piccriteria = picexample.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)vo.getExecutorBy())) {
            piccriteria.andEqualTo("executorBy", (Object)vo.getExecutorBy());
        } else {
            piccriteria.andEqualTo("createBy", (Object)userRedis.getId());
        }
        picexample.orderBy("createDate").desc();
        List pictureEntities = this.tsWorkTaskDao.selectByExample(picexample);
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> pictureEntities, (Page)page1);
        ajaxJson.setPageInfo(pageInfo);
        return ajaxJson;
    }

    @Override
    public AjaxJson<TsWorkTaskVo> getWorkTaskInfo(TsWorkTaskVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtil.isEmpty((String)vo.getId())) {
            ajaxJson.setErrMsg("id\u5fc5\u4f20");
            return ajaxJson;
        }
        TsWorkTaskEntity entity = (TsWorkTaskEntity)this.tsWorkTaskDao.selectByPrimaryKey(vo.getId());
        TsWorkTaskVo tsWorkTaskVo = new TsWorkTaskVo();
        BeanUtils.copyProperties((Object)entity, (Object)tsWorkTaskVo);
        tsWorkTaskVo.setId(entity.getId() + "");
        Example picexample = new Example(TsPictureEntity.class);
        Example.Criteria piccriteria = picexample.createCriteria();
        piccriteria.andEqualTo("businessId", (Object)vo.getId());
        piccriteria.andEqualTo("imgType", (Object)Constant.imgType.tjrw.getValue());
        List pictureEntities = this.tsPictureDao.selectByExample(picexample);
        Example picexample1 = new Example(TsPictureEntity.class);
        Example.Criteria piccriteria1 = picexample1.createCriteria();
        piccriteria1.andEqualTo("businessId", (Object)vo.getId());
        piccriteria1.andEqualTo("imgType", (Object)Constant.imgType.sprw.getValue());
        List pictureEntities1 = this.tsPictureDao.selectByExample(picexample1);
        tsWorkTaskVo.setImgList(pictureEntities);
        tsWorkTaskVo.setImgApproList(pictureEntities1);
        ajaxJson.setObj((Object)tsWorkTaskVo);
        return ajaxJson;
    }

    @Override
    public AjaxJson commitWorkTask(TsWorkTaskVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtil.isEmpty((String)vo.getId())) {
            ajaxJson.setErrMsg("id\u5fc5\u4f20");
            return ajaxJson;
        }
        if (StringUtil.isEmpty((String)vo.getTaskStatus())) {
            ajaxJson.setErrMsg("\u5b8c\u6210/\u62d2\u7edd\u72b6\u6001\u5fc5\u4f20");
            return ajaxJson;
        }
        TsWorkTaskEntity entity = (TsWorkTaskEntity)this.tsWorkTaskDao.selectByPrimaryKey(vo.getId());
        entity.setTaskStatus(vo.getTaskStatus());
        entity.setRemark(vo.getRemark());
        this.tsWorkTaskDao.updateByPrimaryKeySelective(entity);
        List imgList = vo.getImgList();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)imgList)) {
            for (TsPictureEntity tsPictureEntity1 : imgList) {
                tsPictureEntity1.setBusinessId(entity.getId());
                tsPictureEntity1.setImgType(Constant.imgType.sprw.getValue());
                this.filePathUtil.getChangePicturePath(tsPictureEntity1);
                this.tsPictureDao.insertSelective(tsPictureEntity1);
            }
        }
        return ajaxJson;
    }
}

