/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.order;

import com.biz.eisp.api.feign.MdmApiFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.order.entity.TsOrderEntity;
import com.biz.eisp.order.service.TsOrderService;
import com.biz.eisp.order.vo.TsOrderVo;
import com.biz.eisp.params.Constant;
import com.biz.eisp.product.TmProductInfoVo;
import com.biz.eisp.terminal.TmTerminalVo;
import com.biz.eisp.tools.DictUtil;
import com.biz.eisp.utils.Result;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sfaApi/orderApiController"})
@Api(tags={"\u95e8\u5e97\u8ba2\u5355"})
public class OrderApiController {
    @Autowired
    TsOrderService tsOrderService;
    @Autowired
    MdmApiFeign mdmApiFeign;

    @PostMapping(value={"findOrderList"})
    @ApiOperation(value="\u83b7\u53d6\u8ba2\u5355\u5217\u8868", notes="page\u548crows\u5fc5\u4f20\uff0c\u67e5\u8be2\u6761\u4ef6vo\u4e0d\u5fc5\u4f20", httpMethod="POST")
    public Result<PageInfo<TsOrderEntity>> findOrderList(@RequestBody TsOrderVo vo, String page, String rows) {
        AjaxJson<TsOrderEntity> ajaxJson = this.tsOrderService.findOrderList(vo, page, rows);
        Result<PageInfo<TsOrderEntity>> result = new Result<PageInfo<TsOrderEntity>>();
        result.setSuccess(ajaxJson.isSuccess());
        if (ajaxJson.isSuccess()) {
            result.setCode(Constant.resultCode.code_200.getValue());
        } else {
            result.setCode(Constant.resultCode.code_201.getValue());
        }
        result.setMsg(ajaxJson.getMsg());
        result.setObj(ajaxJson.getPageInfo());
        return result;
    }

    @PostMapping(value={"findTerminalList"})
    @ApiOperation(value="\u83b7\u53d6\u95e8\u5e97\u5217\u8868", notes="\u8fd4\u56de\u503cterminalCode\u548cterminalName\u6709\u7528\uff0c\u5176\u4ed6\u5197\u4f59\u5b57\u6bb5\u4e0d\u7ba1", httpMethod="POST")
    public Result<PageInfo<TmTerminalVo>> findTerminalListByUser(@RequestBody Map<String, Object> param) {
        AjaxJson ajaxJson = this.mdmApiFeign.getTerminalPage(param);
        Result<PageInfo<TmTerminalVo>> result = new Result<PageInfo<TmTerminalVo>>();
        result.setSuccess(ajaxJson.isSuccess());
        result.setMsg(ajaxJson.getMsg());
        result.setObj(ajaxJson.getPageInfo());
        return result;
    }

    @PostMapping(value={"findProductInfoByPage"})
    @ApiOperation(value="\u83b7\u53d6\u4ea7\u54c1", notes="\u4f20\u9012Map<String,Object>\u5f62\u5f0f\uff0ckey\u4e3a\u7b5b\u9009\u6761\u4ef6\uff0cvalue\u4e3a\u503c(\u4f8b\u5982 {\"productInfoName\":\"11\",\"productInfoCode\":\"22\"} )\uff0c\u5982\u679c\u6ca1\u6709\u7b5b\u9009\u6761\u4ef6\uff0c\u5219\u4f20\u7a7aMap,\u4f8b\u5982 {} ,\u4e0d\u80fd\u76f4\u63a5\u4f20null", httpMethod="POST")
    public Result<PageInfo<TmProductInfoVo>> findProductInfoByPage(@RequestBody Map<String, Object> param) {
        AjaxJson ajaxJson = this.mdmApiFeign.findProductInfoByPage(param);
        if (ajaxJson.getPageInfo() != null && CollectionUtil.listNotEmptyNotSizeZero((List)ajaxJson.getPageInfo().getList())) {
            for (TmProductInfoVo tmProductInfoVo : ajaxJson.getPageInfo().getList()) {
                String saleUnit = DictUtil.getDictDataVal((String)"sale_unit", (String)tmProductInfoVo.getSaleUnit());
                String basicUnit = DictUtil.getDictDataVal((String)"basic_unit", (String)tmProductInfoVo.getBasicUnit());
                tmProductInfoVo.setSaleUnit(saleUnit);
                tmProductInfoVo.setBasicUnit(basicUnit);
            }
        }
        Result<PageInfo<TmProductInfoVo>> result = new Result<PageInfo<TmProductInfoVo>>();
        result.setSuccess(ajaxJson.isSuccess());
        result.setMsg(ajaxJson.getMsg());
        result.setObj(ajaxJson.getPageInfo());
        return result;
    }

    @PostMapping(value={"getProductInfoDetail"})
    @ApiOperation(value="\u83b7\u53d6\u4ea7\u54c1\u8be6\u60c5", notes="id\u5fc5\u4f20", httpMethod="POST")
    public Result<TmProductInfoVo> getProductInfoDetail(String id) {
        Result<TmProductInfoVo> result = new Result<TmProductInfoVo>();
        if (StringUtil.isEmpty((String)id)) {
            result.setCode(Constant.resultCode.code_201.getValue());
            result.setMsg("id\u4e0d\u80fd\u4e3a\u7a7a");
            result.setSuccess(false);
        } else {
            AjaxJson ajaxJson = this.mdmApiFeign.getProductInfoDetail(id);
            result.setSuccess(ajaxJson.isSuccess());
            if (ajaxJson.isSuccess()) {
                result.setCode(Constant.resultCode.code_200.getValue());
            } else {
                result.setCode(Constant.resultCode.code_201.getValue());
            }
            result.setMsg(ajaxJson.getMsg());
            if (ajaxJson.getObj() != null) {
                String saleUnit = DictUtil.getDictDataVal((String)"sale_unit", (String)((TmProductInfoVo)ajaxJson.getObj()).getSaleUnit());
                String basicUnit = DictUtil.getDictDataVal((String)"basic_unit", (String)((TmProductInfoVo)ajaxJson.getObj()).getBasicUnit());
                ((TmProductInfoVo)ajaxJson.getObj()).setSaleUnit(saleUnit);
                ((TmProductInfoVo)ajaxJson.getObj()).setBasicUnit(basicUnit);
            }
            result.setObj((TmProductInfoVo)ajaxJson.getObj());
        }
        return result;
    }

    @PostMapping(value={"addOrder"})
    @ApiOperation(value="\u6dfb\u52a0\u8ba2\u5355", notes="itemVos\u4ea7\u54c1\u5217\u8868\u5fc5\u4f20(productCode\u4ea7\u54c1\u7f16\u7801\uff0cproductName\u4ea7\u54c1\u540d\u79f0\uff0cunit\u5355\u4f4d\uff0cnum\u6570\u91cf)\uff0cterminalCode\u95e8\u5e97\u7f16\u7801\u5fc5\u4f20\uff0cterminalName\u95e8\u5e97\u540d\u5b57\u5fc5\u4f20", httpMethod="POST")
    public Result addOrder(@RequestBody TsOrderVo vo) {
        AjaxJson ajaxJson = this.tsOrderService.addOrder(vo);
        Result result = new Result();
        result.setSuccess(ajaxJson.isSuccess());
        result.setMsg(ajaxJson.getMsg());
        return result;
    }

    @PostMapping(value={"findOrderDetail"})
    @ApiOperation(value="\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5", notes="orderSn\u8ba2\u5355\u7f16\u7801\u5fc5\u4f20", httpMethod="POST")
    public Result<TsOrderVo> findOrderDetail(@RequestBody TsOrderVo vo) {
        AjaxJson<TsOrderVo> ajaxJson = this.tsOrderService.findOrderDetail(vo);
        Result<TsOrderVo> result = new Result<TsOrderVo>();
        result.setSuccess(ajaxJson.isSuccess());
        result.setMsg(ajaxJson.getMsg());
        result.setObj((TsOrderVo)ajaxJson.getObj());
        return result;
    }
}

