/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.visitnote;

import com.biz.eisp.api.feign.MdmApiFeign;
import com.biz.eisp.api.feign.TmPositionFeign;
import com.biz.eisp.api.feign.TmUserFeign;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.position.TmPositionVo;
import com.biz.eisp.user.TmUserVo;
import com.biz.eisp.visitnote.entity.VisitGroupEntity;
import com.biz.eisp.visitnote.entity.VisitNoteEntity;
import com.biz.eisp.visitnote.entity.VisitclientRelEntity;
import com.biz.eisp.visitnote.service.VisitGroupServiceI;
import com.biz.eisp.visitnote.service.VisitNoteService;
import com.biz.eisp.visitnote.vo.SFACustomerVo;
import com.biz.eisp.visitnote.vo.VisitNoteVo;
import com.github.pagehelper.PageInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/visitNoteController"})
public class VisitNoteController {
    @Autowired
    private VisitNoteService visitNoteService;
    @Autowired
    private VisitGroupServiceI visitGroupService;
    @Autowired
    private MdmApiFeign mdmApiFeign;
    @Autowired
    private TmUserFeign tmUserFeign;
    @Autowired
    private TmPositionFeign tmPositionFeign;

    @RequestMapping(value={"visitNote"})
    public ModelAndView visitNote(HttpServletRequest request) {
        UserRedis user = UserUtils.getUser();
        String orgCode = user.getOrgCode();
        String userId = user.getId();
        if (StringUtil.isNotEmpty((CharSequence)userId)) {
            request.setAttribute("userId", (Object)userId);
        }
        if (StringUtil.isNotEmpty((CharSequence)orgCode)) {
            request.setAttribute("orgCode", (Object)orgCode);
        }
        return new ModelAndView("com/biz/eisp/sfa/visitnote/visitNoteList");
    }

    @RequestMapping(value={"getChildUserForWeb"})
    @ResponseBody
    public DataGrid getChildUserForWeb(HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        PageInfo pageInfo = null;
        String orgName = OConvertUtils.getString((String)request.getParameter("orgName"));
        String posName = OConvertUtils.getString((String)request.getParameter("posName"));
        String realName = OConvertUtils.getString((String)request.getParameter("fullname"));
        String posId = OConvertUtils.getString((String)request.getParameter("posId"));
        try {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("page", page.getPage());
            param.put("rows", page.getRows());
            param.put("realName", realName);
            param.put("posName", posName);
            param.put("orgName", orgName);
            param.put("posId", posId);
            pageInfo = ApiResultUtil.pageInfoResult((AjaxJson)this.tmUserFeign.getAllUserAndPositionList(param));
            if (CollectionUtil.listNotEmptyNotSizeZero((List)pageInfo.getList())) {
                ArrayList pageInfoList = new ArrayList();
                pageInfo.getList().forEach(item -> {
                    item.setUserId(item.getId());
                    String id = item.getId() + "," + item.getPosId();
                    item.setId(id);
                    pageInfoList.add(item);
                });
                pageInfo.setList(pageInfoList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u83b7\u53d6\u4eba\u5458\u5931\u8d25");
        }
        return new DataGrid(pageInfo);
    }

    @ResponseBody
    @RequestMapping(value={"getCustomerByPosId"})
    public DataGrid getCustomerByPosId(SFACustomerVo sfaCustomerVo, HttpServletRequest request) {
        String userId = OConvertUtils.getString((String)request.getParameter("userId"));
        String user = OConvertUtils.getString((String)request.getParameter("user"));
        String posId = OConvertUtils.getString((String)request.getParameter("posId"));
        String customerName = OConvertUtils.getString((String)request.getParameter("customerName"));
        String customerCode = OConvertUtils.getString((String)request.getParameter("customerCode"));
        EuPage page = new EuPage(request);
        PageInfo pageInfo = null;
        try {
            TmPositionVo pvo;
            if (StringUtil.isNotEmpty((CharSequence)user)) {
                userId = user;
            }
            if (StringUtil.isEmpty((String)userId)) {
                pageInfo = new PageInfo();
                return new DataGrid(pageInfo);
            }
            if (StringUtil.isNotEmpty((CharSequence)userId) && StringUtil.isEmpty((String)posId) && (pvo = (TmPositionVo)ApiResultUtil.objResult((AjaxJson)this.tmPositionFeign.getUserMainPositon("", userId))) != null) {
                posId = pvo.getId();
            }
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("page", page.getPage());
            param.put("rows", page.getRows());
            param.put("customerName", customerName);
            param.put("customerCode", customerCode);
            param.put("posId", posId);
            pageInfo = ApiResultUtil.pageInfoResult((AjaxJson)this.mdmApiFeign.getCustomerByPosIdPage(param));
        }
        catch (Exception e) {
            e.printStackTrace();
            if (StringUtil.isEmpty((String)posId)) {
                throw new BusinessException("\u7528\u6237\u6ca1\u6709\u5206\u914d\u804c\u4f4d");
            }
            throw new BusinessException("\u83b7\u53d6\u7f51\u70b9\u6570\u636e\u5931\u8d25");
        }
        return new DataGrid(pageInfo);
    }

    @ResponseBody
    @RequestMapping(value={"datagrid"})
    public DataGrid datagrid(VisitNoteEntity visitNote, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        String userId = OConvertUtils.getString((String)request.getParameter("userId"));
        String user = OConvertUtils.getString((String)request.getParameter("user"));
        String visitDate = "";
        String posId = OConvertUtils.getString((String)request.getParameter("posId"));
        PageInfo<VisitNoteVo> pageInfo = null;
        try {
            TmPositionVo pvo;
            if (StringUtil.isNotEmpty((CharSequence)user)) {
                userId = user;
            }
            visitDate = StringUtil.isNotEmpty((CharSequence)visitNote.getVisitDate()) ? visitNote.getVisitDate() : DateUtils.getYYYYMMDD();
            if (StringUtil.isNotEmpty((CharSequence)userId) && StringUtil.isEmpty((String)posId) && (pvo = (TmPositionVo)ApiResultUtil.objResult((AjaxJson)this.tmPositionFeign.getUserMainPositon("", userId))) != null) {
                posId = pvo.getId();
            }
            ArrayList<String> pos = new ArrayList<String>();
            if (StringUtil.isNotEmpty((CharSequence)posId)) {
                pos.add(posId);
            }
            pageInfo = this.visitNoteService.getVisitInfo(null, pos, visitDate, "", (Page)page);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (StringUtil.isEmpty((String)posId)) {
                throw new BusinessException("\u7528\u6237\u6ca1\u6709\u5206\u914d\u804c\u4f4d");
            }
            throw new BusinessException("\u83b7\u53d6\u7ebf\u8def\u6570\u636e\u5931\u8d25");
        }
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String message = "\u8be5\u7ebf\u8def\u8ba1\u5212\u5220\u9664\u6210\u529f";
        Calendar now = Calendar.getInstance();
        Calendar planDate = Calendar.getInstance();
        now.setTime(new Date());
        try {
            for (String id : ids.split(",")) {
                VisitNoteEntity visitNote = (VisitNoteEntity)this.visitNoteService.selectByPrimaryKey(id);
                planDate.setTime(DateUtils.getDateYYYYMD((String)visitNote.getVisitDate()));
                if (planDate.before(now) || planDate.equals(now)) {
                    message = "\u4e0d\u80fd\u5220\u9664\u5f53\u5929\u4ee5\u53ca\u4e4b\u524d\u7684\u7ebf\u8def\u8ba1\u5212";
                    continue;
                }
                visitNote.setStatus(ConstantEnum.StatusEnum.DELETE.getValue());
                this.visitNoteService.updateByPrimaryKeySelective(visitNote);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            message = "\u8be5\u7ebf\u8def\u8ba1\u5212\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(message);
        return j;
    }

    @RequestMapping(value={"doVPAdd"})
    @ResponseBody
    public AjaxJson doVPAdd(VisitNoteEntity visitNote, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String message = "";
        String custIds = OConvertUtils.getString((String)request.getParameter("custIds"));
        String userId = OConvertUtils.getString((String)request.getParameter("userId"));
        String posId = OConvertUtils.getString((String)request.getParameter("posId"));
        String lvUserId = OConvertUtils.getString((String)request.getParameter("lvUserId"));
        if (StringUtil.isEmpty((String)lvUserId)) {
            lvUserId = userId;
        }
        String status = OConvertUtils.getString((String)request.getParameter("auditStatus"));
        String customerTypes = OConvertUtils.getString((String)request.getParameter("customerTypes"));
        String startDate = OConvertUtils.getString((String)request.getParameter("startDate"));
        String endDate = OConvertUtils.getString((String)request.getParameter("endDate"));
        String notWeeks = OConvertUtils.getString((String)request.getParameter("notWeeks"));
        String frquency = OConvertUtils.getString((String)request.getParameter("frquency"));
        String firstDay = OConvertUtils.getString((String)request.getParameter("firstDay"));
        try {
            TmPositionVo posLv = (TmPositionVo)ApiResultUtil.objResult((AjaxJson)this.tmPositionFeign.getUserMainPositon("", lvUserId));
            String lvPosId = posLv != null ? posLv.getId() : "";
            Integer auditStatus = Integer.parseInt(status);
            if (StringUtil.isNotEmpty((CharSequence)posId)) {
                TmUserVo userVo = (TmUserVo)ApiResultUtil.objResult((AjaxJson)this.tmUserFeign.findPositionUser(posId + ""));
                if (userVo != null) {
                    visitNote.setPosId(Integer.valueOf(StringUtils.isNotBlank((CharSequence)userVo.getPosId()) ? Integer.valueOf(userVo.getPosId()) : 0));
                    visitNote.setUserName(userVo.getFullname());
                    visitNote.setPosName(userVo.getPosName());
                    visitNote.setVisitPosId(Integer.valueOf(userVo.getPosId()));
                    visitNote.setVisitUserId(userId);
                }
            } else {
                TmPositionVo pos = (TmPositionVo)ApiResultUtil.objResult((AjaxJson)this.tmPositionFeign.getUserMainPositon("", userId));
                if (pos != null) {
                    visitNote.setPosId(Integer.valueOf(StringUtils.isNotBlank((CharSequence)pos.getId()) ? Integer.valueOf(pos.getId()) : 0));
                    visitNote.setUserName(pos.getFullname());
                    visitNote.setPosName(pos.getPositionName());
                    visitNote.setVisitPosId(Integer.valueOf(pos.getId()));
                    visitNote.setVisitUserId(userId);
                }
            }
            visitNote.setStatus("009");
            String[] custArray = null;
            if (StringUtil.isNotEmpty((CharSequence)custIds)) {
                custArray = custIds.split(",");
            }
            String[] custTypeArray = null;
            if (StringUtil.isNotEmpty((CharSequence)customerTypes)) {
                custTypeArray = customerTypes.split(",");
            }
            String[] frquencyArray = null;
            if (StringUtil.isNotEmpty((CharSequence)frquency)) {
                frquencyArray = frquency.split(",");
            }
            String[] firstDayArray = null;
            if (StringUtil.isNotEmpty((CharSequence)firstDay)) {
                firstDayArray = firstDay.split(",");
            }
            if (StringUtil.isNotEmpty((CharSequence)startDate) && StringUtil.isNotEmpty((CharSequence)endDate)) {
                message = this.visitNoteService.addVPLIneAll(visitNote, custArray, custTypeArray, lvPosId, auditStatus, startDate, endDate, notWeeks, frquencyArray, firstDayArray);
            }
            if (message.equals("\u8be5\u5929\u5df2\u7ecf\u521b\u5efa\u534f\u8bbf\u8ba1\u5212\u65e0\u9700\u518d\u6b21\u6dfb\u52a0")) {
                j.setMsg(message);
                j.setSuccess(false);
            }
            if (!("\u6dfb\u52a0\u534f\u8bbf\u8ba1\u5212\u6210\u529f".equals(message) || "\u6dfb\u52a0\u7ebf\u8def\u6210\u529f,\u5df2\u81ea\u52a8\u8fc7\u6ee4\u91cd\u590d\u7f51\u70b9".equals(message) || "\u6dfb\u52a0\u7ebf\u8def\u6210\u529f".equals(message))) {
                j.setMsg(message);
                j.setSuccess(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            message = "\u6dfb\u52a0\u7ebf\u8def\u8ba1\u5212\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(message);
        return j;
    }

    @RequestMapping(value={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(VisitNoteEntity visitNote, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String message = "";
        String custIds = OConvertUtils.getString((String)request.getParameter("custIds"));
        String userId = OConvertUtils.getString((String)request.getParameter("userId"));
        String posId = OConvertUtils.getString((String)request.getParameter("posId"));
        String lvUserId = OConvertUtils.getString((String)request.getParameter("lvUserId"));
        if (StringUtil.isEmpty((String)lvUserId)) {
            lvUserId = userId;
        }
        String status = OConvertUtils.getString((String)request.getParameter("auditStatus"));
        String customerTypes = OConvertUtils.getString((String)request.getParameter("customerTypes"));
        String startDate = OConvertUtils.getString((String)request.getParameter("startDate"));
        String endDate = OConvertUtils.getString((String)request.getParameter("endDate"));
        String notWeeks = OConvertUtils.getString((String)request.getParameter("notWeeks"));
        try {
            TmPositionVo posLv = (TmPositionVo)ApiResultUtil.objResult((AjaxJson)this.tmPositionFeign.getUserMainPositon("", lvUserId));
            String lvPosId = posLv != null ? posLv.getId() : "";
            Integer auditStatus = Integer.parseInt(status);
            if (StringUtil.isNotEmpty((CharSequence)posId)) {
                TmUserVo userVo = (TmUserVo)ApiResultUtil.objResult((AjaxJson)this.tmUserFeign.findPositionUser(posId + ""));
                if (userVo != null) {
                    visitNote.setPosId(Integer.valueOf(StringUtils.isNotBlank((CharSequence)userVo.getPosId()) ? Integer.valueOf(userVo.getPosId()) : 0));
                    visitNote.setUserName(userVo.getFullname());
                    visitNote.setPosName(userVo.getPosName());
                    visitNote.setVisitPosId(Integer.valueOf(userVo.getPosId()));
                    visitNote.setVisitUserId(userId);
                }
            } else {
                TmPositionVo pos = (TmPositionVo)ApiResultUtil.objResult((AjaxJson)this.tmPositionFeign.getUserMainPositon("", userId));
                if (pos != null) {
                    visitNote.setPosId(Integer.valueOf(StringUtils.isNotBlank((CharSequence)pos.getId()) ? Integer.valueOf(pos.getId()) : 0));
                    visitNote.setUserName(pos.getFullname());
                    visitNote.setPosName(pos.getPositionName());
                    visitNote.setVisitPosId(Integer.valueOf(pos.getId()));
                    visitNote.setVisitUserId(userId);
                }
            }
            visitNote.setStatus("009");
            String[] custArray = null;
            if (StringUtil.isNotEmpty((CharSequence)custIds)) {
                custArray = custIds.split(",");
            }
            String[] custTypeArray = null;
            if (StringUtil.isNotEmpty((CharSequence)customerTypes)) {
                custTypeArray = customerTypes.split(",");
            }
            if ((message = StringUtil.isNotEmpty((CharSequence)startDate) && StringUtil.isNotEmpty((CharSequence)endDate) ? this.visitNoteService.addLIneAll(visitNote, custArray, custTypeArray, lvPosId, auditStatus, startDate, endDate, notWeeks) : this.visitNoteService.addLIne(visitNote, custArray, custTypeArray, lvPosId, auditStatus)).equals("\u8be5\u5929\u5df2\u7ecf\u521b\u5efa\u534f\u8bbf\u8ba1\u5212\u65e0\u9700\u518d\u6b21\u6dfb\u52a0")) {
                j.setMsg(message);
                j.setSuccess(false);
            }
            if (!("\u6dfb\u52a0\u534f\u8bbf\u8ba1\u5212\u6210\u529f".equals(message) || "\u6dfb\u52a0\u7ebf\u8def\u6210\u529f,\u5df2\u81ea\u52a8\u8fc7\u6ee4\u91cd\u590d\u7f51\u70b9".equals(message) || "\u6dfb\u52a0\u7ebf\u8def\u6210\u529f".equals(message))) {
                j.setMsg(message);
                j.setSuccess(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            message = "\u6dfb\u52a0\u7ebf\u8def\u8ba1\u5212\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(message);
        return j;
    }

    @RequestMapping(value={"doVgAdd"})
    @ResponseBody
    public AjaxJson doVgAdd(VisitNoteEntity visitNote, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String message = "";
        String lvUserId = OConvertUtils.getString((String)request.getParameter("lvUserId"));
        String visitGroups = OConvertUtils.getString((String)request.getParameter("visitGroups"));
        String userId = OConvertUtils.getString((String)request.getParameter("userId"));
        String posId = OConvertUtils.getString((String)request.getParameter("posId"));
        String status = OConvertUtils.getString((String)request.getParameter("auditStatus"));
        String startDate = OConvertUtils.getString((String)request.getParameter("startDate"));
        String endDate = OConvertUtils.getString((String)request.getParameter("endDate"));
        String notWeeks = OConvertUtils.getString((String)request.getParameter("notWeeks"));
        if (StringUtil.isEmpty((String)lvUserId)) {
            lvUserId = userId;
        }
        try {
            TmPositionVo posLv = (TmPositionVo)ApiResultUtil.objResult((AjaxJson)this.tmPositionFeign.getUserMainPositon("", lvUserId));
            String lvPosId = posLv != null ? posLv.getId() : "";
            Integer auditStatus = Integer.parseInt(status);
            if (StringUtil.isNotEmpty((CharSequence)posId)) {
                TmUserVo userVo = (TmUserVo)ApiResultUtil.objResult((AjaxJson)this.tmUserFeign.findPositionUser(posId + ""));
                if (userVo != null) {
                    visitNote.setPosId(Integer.valueOf(StringUtils.isNotBlank((CharSequence)userVo.getPosId()) ? Integer.valueOf(userVo.getPosId()) : 0));
                    visitNote.setUserName(userVo.getFullname());
                    visitNote.setPosName(userVo.getPosName());
                    visitNote.setVisitPosId(Integer.valueOf(userVo.getPosId()));
                    visitNote.setVisitUserId(userId);
                }
            } else {
                TmPositionVo pos = (TmPositionVo)ApiResultUtil.objResult((AjaxJson)this.tmPositionFeign.getUserMainPositon("", userId));
                if (pos != null) {
                    visitNote.setPosId(Integer.valueOf(StringUtils.isNotBlank((CharSequence)pos.getId()) ? Integer.valueOf(pos.getId()) : 0));
                    visitNote.setUserName(pos.getFullname());
                    visitNote.setPosName(pos.getPositionName());
                    visitNote.setVisitPosId(Integer.valueOf(pos.getId()));
                    visitNote.setVisitUserId(userId);
                }
            }
            visitNote.setStatus("009");
            String[] visitGroupArray = null;
            if (!StringUtil.isNotEmpty((CharSequence)visitGroups)) {
                j.setMsg("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u7ebf\u8def\u7ec4");
                j.setSuccess(false);
                return j;
            }
            visitGroupArray = visitGroups.split(",");
            message = this.visitNoteService.addGvLIneAll(visitNote, visitGroupArray, lvPosId, auditStatus, startDate, endDate, notWeeks);
            if (message.equals("\u8be5\u5929\u5df2\u7ecf\u521b\u5efa\u534f\u8bbf\u8ba1\u5212\u65e0\u9700\u518d\u6b21\u6dfb\u52a0")) {
                j.setMsg(message);
                j.setSuccess(false);
            }
            if (!("\u6dfb\u52a0\u534f\u8bbf\u8ba1\u5212\u6210\u529f".equals(message) || "\u6dfb\u52a0\u7ebf\u8def\u6210\u529f,\u5df2\u81ea\u52a8\u8fc7\u6ee4\u91cd\u590d\u7f51\u70b9".equals(message) || "\u6dfb\u52a0\u7ebf\u8def\u6210\u529f".equals(message))) {
                j.setMsg(message);
                j.setSuccess(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            message = "\u6dfb\u52a0\u7ebf\u8def\u8ba1\u5212\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(message);
        return j;
    }

    @RequestMapping(value={"getGroupToVisit"})
    @ResponseBody
    public AjaxJson getGroupToVisit(VisitNoteEntity visitNote, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String message = "\u6dfb\u52a0\u7ebf\u8def\u6210\u529f";
        String groupId = request.getParameter("groupId");
        String userId = request.getParameter("userId");
        String posId = request.getParameter("posId");
        String noVlaue = "";
        String custIds = "";
        String customerTypes = "";
        String status = request.getParameter("auditStatus");
        try {
            List list;
            Integer auditStatus = Integer.parseInt(status);
            VisitGroupEntity groupEntity = (VisitGroupEntity)this.visitGroupService.selectByPrimaryKey(groupId);
            if (StringUtil.isNotEmpty((Object)groupEntity) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = groupEntity.getVisitclients()))) {
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        custIds = custIds + ",";
                        customerTypes = customerTypes + ",";
                    }
                    custIds = custIds + ((VisitclientRelEntity)list.get(i)).getClientId();
                    customerTypes = customerTypes + ((VisitclientRelEntity)list.get(i)).getClientType();
                }
            }
            if (StringUtil.isNotEmpty((CharSequence)posId)) {
                TmUserVo userVo = (TmUserVo)ApiResultUtil.objResult((AjaxJson)this.tmUserFeign.findPositionUser(posId));
                if (userVo != null) {
                    visitNote.setUserName(userVo.getFullname());
                    visitNote.setPosName(userVo.getPosName());
                    visitNote.setPosId(Integer.valueOf(StringUtils.isNotBlank((CharSequence)userVo.getPosId()) ? Integer.valueOf(userVo.getPosId()) : 0));
                }
            } else {
                TmPositionVo pos = (TmPositionVo)ApiResultUtil.objResult((AjaxJson)this.tmPositionFeign.getUserMainPositon("", userId));
                if (pos != null) {
                    visitNote.setUserName(pos.getFullname());
                    visitNote.setPosName(pos.getPositionName());
                    visitNote.setPosId(Integer.valueOf(StringUtils.isNotBlank((CharSequence)pos.getId()) ? Integer.valueOf(pos.getId()) : 0));
                }
            }
            visitNote.setStatus("009");
            String[] custArray = null;
            String[] custTypeArray = null;
            if (StringUtil.isNotEmpty((CharSequence)custIds)) {
                custArray = custIds.split(",");
            }
            if (StringUtil.isNotEmpty((CharSequence)customerTypes)) {
                custTypeArray = customerTypes.split(",");
            }
            if (StringUtil.isNotEmpty((Object)custArray)) {
                message = this.visitNoteService.addLIne(visitNote, custArray, custTypeArray, noVlaue, auditStatus);
            } else {
                j.setSuccess(false);
                message = "\u6dfb\u52a0\u7ebf\u8def\u5931\u8d25,\u8be5\u7ebf\u8def\u7ec4\u4e2d\u6ca1\u6709\u7f51\u70b9\u4fe1\u606f";
            }
        }
        catch (Exception e) {
            j.setSuccess(false);
            message = "\u6dfb\u52a0\u7ebf\u8def\u5931\u8d25";
            e.printStackTrace();
        }
        j.setMsg(message);
        return j;
    }

    @RequestMapping(value={"getAlredyPlan"})
    @ResponseBody
    public AjaxJson getAlredyPlan(VisitNoteEntity visitNote, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String startDate = request.getParameter("startDate");
        String endDate = request.getParameter("endDate");
        String posId = visitNote.getPosId() + "";
        String userId = visitNote.getUserId();
        HashMap<String, Object> param = new HashMap<String, Object>();
        try {
            TmPositionVo pos;
            if (StringUtil.isNotEmpty((CharSequence)userId) && StringUtil.isEmpty((String)posId) && (pos = (TmPositionVo)ApiResultUtil.objResult((AjaxJson)this.tmPositionFeign.getUserMainPositon("", userId))) != null) {
                posId = pos.getId();
            }
            param.put("posId", posId);
            param.put("userId", userId);
            param.put("startDate", startDate);
            param.put("endDate", endDate);
            List<String> list = this.visitNoteService.getAlreadyPlan(param);
            if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
                String alreadyDate = "";
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        alreadyDate = alreadyDate + ",";
                    }
                    alreadyDate = alreadyDate + list.get(i);
                }
                j.setObj((Object)alreadyDate);
            } else {
                j.setSuccess(false);
            }
        }
        catch (Exception e) {
            j.setSuccess(false);
            e.printStackTrace();
            throw new BusinessException("\u83b7\u53d6\u5df2\u7ecf\u5236\u5b9a\u8ba1\u5212\u65e5\u671f\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"autoVisit"})
    @ResponseBody
    public AjaxJson autoVisit(VisitNoteEntity visitNote, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String message = "\u81ea\u52a8\u751f\u6210\u5468\u671f\u7ebf\u8def\u8ba1\u5212\u6210\u529f";
        String startDate = request.getParameter("startDate");
        String endDate = request.getParameter("endDate");
        String flag = request.getParameter("flag");
        String userId = visitNote.getUserId();
        Integer posId = visitNote.getPosId();
        try {
            if (StringUtil.isNotEmpty((Object)posId)) {
                TmUserVo userVo = (TmUserVo)ApiResultUtil.objResult((AjaxJson)this.tmUserFeign.findPositionUser(posId + ""));
                if (userVo != null) {
                    visitNote.setUserName(userVo.getFullname());
                    visitNote.setPosName(userVo.getPosName());
                    visitNote.setPosId(Integer.valueOf(StringUtils.isNotBlank((CharSequence)userVo.getPosId()) ? Integer.valueOf(userVo.getPosId()) : 0));
                }
            } else {
                TmPositionVo pos = (TmPositionVo)ApiResultUtil.objResult((AjaxJson)this.tmPositionFeign.getUserMainPositon("", userId));
                if (pos != null) {
                    visitNote.setUserName(pos.getFullname());
                    visitNote.setPosName(pos.getPositionName());
                    visitNote.setPosId(Integer.valueOf(StringUtils.isNotBlank((CharSequence)pos.getId()) ? Integer.valueOf(pos.getId()) : 0));
                }
            }
            this.visitNoteService.autoVisit(visitNote, startDate, endDate, flag);
        }
        catch (Exception e) {
            e.printStackTrace();
            message = "\u81ea\u52a8\u751f\u6210\u5468\u671f\u7ebf\u8def\u8ba1\u5212\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(message);
        return j;
    }

    @RequestMapping(value={"addVisitRemind"})
    @ResponseBody
    public AjaxJson addVisitRemind(VisitNoteEntity visitNote, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String message = "\u6dfb\u52a0\u62dc\u8bbf\u63d0\u9192\u6210\u529f";
        String ids = request.getParameter("ids");
        try {
            this.visitNoteService.addVisitRemind(visitNote, ids);
        }
        catch (Exception e) {
            e.printStackTrace();
            message = "\u6dfb\u52a0\u62dc\u8bbf\u63d0\u9192\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(message);
        return j;
    }

    @RequestMapping(value={"showWithMap"})
    public ModelAndView showWithMap(HttpServletRequest request) {
        String listMap;
        TmPositionVo pos;
        String userId = request.getParameter("userId");
        String user = request.getParameter("user");
        String visitDate = "";
        String posId = request.getParameter("posId");
        if (StringUtil.isNotEmpty((CharSequence)user)) {
            userId = user;
        }
        visitDate = StringUtil.isNotEmpty((CharSequence)request.getParameter("visitTime")) ? request.getParameter("visitTime") : DateUtils.getYYYYMMDD();
        if (StringUtil.isNotEmpty((CharSequence)userId) && StringUtil.isEmpty((String)posId) && (pos = (TmPositionVo)ApiResultUtil.objResult((AjaxJson)this.tmPositionFeign.getUserMainPositon("", userId))) != null) {
            posId = pos.getId();
        }
        if ((listMap = this.visitNoteService.getVisitInfoMap(userId, posId, visitDate)) != null && !"".equals(listMap.trim())) {
            request.setAttribute("sss", (Object)listMap);
        }
        return new ModelAndView("com/biz/eisp/sfa/visitnote/map");
    }

    @RequestMapping(value={"getCalenderDate"})
    @ResponseBody
    public AjaxJson getCalenderDate(String month, String userId, String posId, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String message = "";
        if (StringUtil.isEmpty((String)month)) {
            month = new SimpleDateFormat("yyyy-MM").format(new Date());
        }
        try {
            List<VisitNoteVo> list;
            TmPositionVo pvo;
            if (StringUtil.isNotEmpty((CharSequence)userId) && StringUtil.isEmpty((String)posId) && (pvo = (TmPositionVo)ApiResultUtil.objResult((AjaxJson)this.tmPositionFeign.getUserMainPositon("", userId))) != null) {
                posId = pvo.getId();
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(list = this.visitNoteService.getCalenderDate(month, posId))) {
                j.setObj(list);
            }
        }
        catch (Exception e) {
            j.setSuccess(false);
            message = "\u83b7\u53d6\u6bcf\u6708\u8ba1\u5212\u6570\u91cf\u5931\u8d25";
            e.printStackTrace();
        }
        j.setMsg(message);
        return j;
    }

    @GetMapping(value={"/getVisitInfoMap"})
    @ResponseBody
    public AjaxJson<String> getVisitInfoMap(@RequestParam(value="userId") String userId, @RequestParam(value="posId") String posId, @RequestParam(value="visitDate") String visitDate) {
        AjaxJson ajaxJson = new AjaxJson();
        String listMap = this.visitNoteService.getVisitInfoMap(userId, posId, visitDate);
        ajaxJson.setObj((Object)listMap);
        return ajaxJson;
    }
}

