/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.worktrack.core;

import com.biz.eisp.worktrack.core.HttpClient;
import com.biz.eisp.worktrack.core.NetConstants;
import com.biz.eisp.worktrack.core.TrackHandler;
import com.biz.eisp.worktrack.util.TimeUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class AsyncRequestClient {
    private static AsyncRequestClient instance = null;
    private static BlockingQueue<TaskCallable<String>> waitingQueue = new LinkedBlockingQueue<TaskCallable<String>>();
    private static int pointSize = 200;
    private static long minutesConcurrency = 5000L;
    private static LoadingCache<Long, AtomicInteger> minutesCounter = null;
    private static LoadingCache<Long, AtomicInteger> secondsCounter = null;
    private static ExecutorService executorService = null;
    private static TaskScheduleThread taskScheduleThread = null;
    private static boolean isRunning = false;

    private AsyncRequestClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AsyncRequestClient getInstance() {
        if (null != instance) return instance;
        Class<AsyncRequestClient> clazz = AsyncRequestClient.class;
        synchronized (AsyncRequestClient.class) {
            if (null != instance) return instance;
            instance = new AsyncRequestClient();
            instance.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init() {
        executorService = new ThreadPoolExecutor(NetConstants.CORE_POOL_SIZE, NetConstants.MAX_POOL_SIZE, NetConstants.KEEP_ALIVE_TIME, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        minutesCounter = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Long, AtomicInteger>(){

            public AtomicInteger load(Long arg0) throws Exception {
                return new AtomicInteger(0);
            }
        });
        secondsCounter = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<Long, AtomicInteger>(){

            public AtomicInteger load(Long arg0) throws Exception {
                return new AtomicInteger(0);
            }
        });
    }

    public void setRequestPointSize(int pointSize) {
        AsyncRequestClient.pointSize = pointSize;
    }

    public void setConcurrency(int concurrency) {
        minutesConcurrency = concurrency;
    }

    public void start() {
        if (!isRunning) {
            isRunning = true;
            taskScheduleThread = new TaskScheduleThread();
            taskScheduleThread.start();
        }
    }

    public void stop() {
        isRunning = false;
        if (null != taskScheduleThread) {
            taskScheduleThread.interrupt();
        }
    }

    public void destroy() {
        isRunning = false;
        if (null != taskScheduleThread) {
            taskScheduleThread.interrupt();
        }
    }

    public void submitTask(long requestId, String action, String parameters, String method) {
        TaskRunable taskRunnable = new TaskRunable(requestId, action, parameters, method);
        TaskCallable<String> taskCallable = new TaskCallable<String>(taskRunnable, "SUCCESS");
        try {
            waitingQueue.put(taskCallable);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static void doTask() {
        TaskCallable<String> taskCallable = null;
        while (isRunning) {
            try {
                taskCallable = waitingQueue.take();
            }
            catch (InterruptedException e) {
                continue;
            }
            if (AsyncRequestClient.concurrencyControl()) {
                executorService.submit(taskCallable);
                continue;
            }
            System.err.println("\u8d85\u5e76\u53d1\uff0c\u4f11\u77201s, waitingQueue size : " + waitingQueue.size());
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            executorService.submit(taskCallable);
        }
    }

    private static boolean concurrencyControl() {
        long currentMinutes = TimeUtils.getCurrentTimeOfMinutes();
        long currentSeconds = System.currentTimeMillis() / 1000L;
        int currentMinutesCounts = 0;
        int currentSecondsCounts = 0;
        try {
            currentMinutesCounts = ((AtomicInteger)minutesCounter.get((Object)currentMinutes)).incrementAndGet();
            currentSecondsCounts = ((AtomicInteger)secondsCounter.get((Object)currentSeconds)).incrementAndGet();
        }
        catch (ExecutionException e1) {
            e1.printStackTrace();
            return true;
        }
        System.out.println("currentSecondsCounts * pointSize : " + currentSecondsCounts * pointSize);
        return (long)(currentMinutesCounts * pointSize) <= minutesConcurrency && (long)(currentSecondsCounts * pointSize) <= minutesConcurrency / 60L;
    }

    public static final class TaskScheduleThread
    extends Thread {
        @Override
        public void run() {
            AsyncRequestClient.doTask();
        }
    }

    public static final class TaskCallable<T>
    implements Callable<T> {
        private Runnable task;
        private T result;

        public TaskCallable(Runnable task, T result) {
            this.task = task;
            this.result = result;
        }

        @Override
        public T call() throws Exception {
            this.task.run();
            return this.result;
        }
    }

    public static final class TaskRunable
    implements Runnable {
        private long requestId;
        private String action;
        private String parameters;
        private String method;

        public TaskRunable(long requestId, String action, String parameters, String method) {
            this.requestId = requestId;
            this.action = action;
            this.parameters = parameters;
            this.method = method;
        }

        @Override
        public void run() {
            String result = HttpClient.sendRequest(this.action, this.parameters, this.method);
            TrackHandler.parseResponse(this.requestId, this.action, result);
        }
    }
}

