/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.utils;

import com.biz.eisp.base.utils.ImageUtils;
import com.biz.eisp.base.utils.Setting;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.im4java.core.CompositeCmd;
import org.im4java.core.ConvertCmd;
import org.im4java.core.IM4JavaException;
import org.im4java.core.IMOperation;
import org.im4java.core.Operation;
import org.springframework.util.Assert;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ImageUtils {
    private static Type type;
    private static String graphicsMagickPath;
    private static String imageMagickPath;
    private static final Color BACKGROUND_COLOR;
    private static int DEST_QUALITY;

    private ImageUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zoom(File srcFile, File destFile, int destWidth, int destHeight, int quality) {
        Assert.notNull((Object)srcFile);
        Assert.notNull((Object)destFile);
        Assert.state((destWidth > 0 ? 1 : 0) != 0);
        Assert.state((destHeight > 0 ? 1 : 0) != 0);
        if (quality != 0) {
            DEST_QUALITY = quality;
        }
        if (type == Type.jdk) {
            Graphics graphics2D = null;
            ImageInputStream imageOutputStream = null;
            ImageWriter imageWriter = null;
            try {
                BufferedImage srcBufferedImage = ImageIO.read(srcFile);
                int srcWidth = srcBufferedImage.getWidth();
                int srcHeight = srcBufferedImage.getHeight();
                int width = destWidth;
                int height = destHeight;
                if (srcHeight >= srcWidth) {
                    width = (int)Math.round((double)destHeight * 1.0 / (double)srcHeight * (double)srcWidth);
                } else {
                    height = (int)Math.round((double)destWidth * 1.0 / (double)srcWidth * (double)srcHeight);
                }
                BufferedImage destBufferedImage = new BufferedImage(destWidth, destHeight, 1);
                graphics2D = destBufferedImage.createGraphics();
                ((Graphics2D)graphics2D).setBackground(BACKGROUND_COLOR);
                graphics2D.clearRect(0, 0, destWidth, destHeight);
                graphics2D.drawImage(srcBufferedImage.getScaledInstance(width, height, 4), destWidth / 2 - width / 2, destHeight / 2 - height / 2, null);
                imageOutputStream = ImageIO.createImageOutputStream(destFile);
                imageWriter = ImageIO.getImageWritersByFormatName(FilenameUtils.getExtension((String)destFile.getName())).next();
                imageWriter.setOutput(imageOutputStream);
                ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
                imageWriteParam.setCompressionMode(2);
                imageWriteParam.setCompressionQuality((float)((double)DEST_QUALITY / 100.0));
                imageWriter.write(null, new IIOImage(destBufferedImage, null, null), imageWriteParam);
                imageOutputStream.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (graphics2D != null) {
                    graphics2D.dispose();
                }
                if (imageWriter != null) {
                    imageWriter.dispose();
                }
                if (imageOutputStream != null) {
                    try {
                        imageOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        } else {
            IMOperation operation = new IMOperation();
            operation.thumbnail(Integer.valueOf(destWidth), Integer.valueOf(destHeight));
            operation.gravity("center");
            operation.background(ImageUtils.toHexEncoding((Color)BACKGROUND_COLOR));
            operation.extent(Integer.valueOf(destWidth), Integer.valueOf(destHeight));
            operation.quality(Double.valueOf(DEST_QUALITY));
            operation.addImage(new String[]{srcFile.getPath()});
            operation.addImage(new String[]{destFile.getPath()});
            if (type == Type.graphicsMagick) {
                ConvertCmd convertCmd = new ConvertCmd(true);
                if (graphicsMagickPath != null) {
                    convertCmd.setSearchPath(graphicsMagickPath);
                }
                try {
                    convertCmd.run((Operation)operation, new Object[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (IM4JavaException e) {
                    e.printStackTrace();
                }
            } else {
                ConvertCmd convertCmd = new ConvertCmd(false);
                if (imageMagickPath != null) {
                    convertCmd.setSearchPath(imageMagickPath);
                }
                try {
                    convertCmd.run((Operation)operation, new Object[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (IM4JavaException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addWatermark(File srcFile, File destFile, File watermarkFile, Setting.WatermarkPosition watermarkPosition, int alpha) {
        Assert.notNull((Object)srcFile);
        Assert.notNull((Object)destFile);
        Assert.state((alpha >= 0 ? 1 : 0) != 0);
        Assert.state((alpha <= 100 ? 1 : 0) != 0);
        if (watermarkFile == null || !watermarkFile.exists() || watermarkPosition == null || watermarkPosition == Setting.WatermarkPosition.no) {
            try {
                FileUtils.copyFile((File)srcFile, (File)destFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        if (type == Type.jdk) {
            Graphics graphics2D = null;
            ImageInputStream imageOutputStream = null;
            ImageWriter imageWriter = null;
            try {
                BufferedImage srcBufferedImage = ImageIO.read(srcFile);
                int srcWidth = srcBufferedImage.getWidth();
                int srcHeight = srcBufferedImage.getHeight();
                BufferedImage destBufferedImage = new BufferedImage(srcWidth, srcHeight, 1);
                graphics2D = destBufferedImage.createGraphics();
                ((Graphics2D)graphics2D).setBackground(BACKGROUND_COLOR);
                graphics2D.clearRect(0, 0, srcWidth, srcHeight);
                graphics2D.drawImage(srcBufferedImage, 0, 0, null);
                ((Graphics2D)graphics2D).setComposite(AlphaComposite.getInstance(10, (float)alpha / 100.0f));
                BufferedImage watermarkBufferedImage = ImageIO.read(watermarkFile);
                int watermarkImageWidth = watermarkBufferedImage.getWidth();
                int watermarkImageHeight = watermarkBufferedImage.getHeight();
                int x = srcWidth - watermarkImageWidth;
                int y = srcHeight - watermarkImageHeight;
                if (watermarkPosition == Setting.WatermarkPosition.topLeft) {
                    x = 0;
                    y = 0;
                } else if (watermarkPosition == Setting.WatermarkPosition.topRight) {
                    x = srcWidth - watermarkImageWidth;
                    y = 0;
                } else if (watermarkPosition == Setting.WatermarkPosition.center) {
                    x = (srcWidth - watermarkImageWidth) / 2;
                    y = (srcHeight - watermarkImageHeight) / 2;
                } else if (watermarkPosition == Setting.WatermarkPosition.bottomLeft) {
                    x = 0;
                    y = srcHeight - watermarkImageHeight;
                } else if (watermarkPosition == Setting.WatermarkPosition.bottomRight) {
                    x = srcWidth - watermarkImageWidth;
                    y = srcHeight - watermarkImageHeight;
                }
                graphics2D.drawImage(watermarkBufferedImage, x, y, watermarkImageWidth, watermarkImageHeight, null);
                imageOutputStream = ImageIO.createImageOutputStream(destFile);
                imageWriter = ImageIO.getImageWritersByFormatName(FilenameUtils.getExtension((String)destFile.getName())).next();
                imageWriter.setOutput(imageOutputStream);
                ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
                imageWriteParam.setCompressionMode(2);
                imageWriteParam.setCompressionQuality((float)DEST_QUALITY / 100.0f);
                imageWriter.write(null, new IIOImage(destBufferedImage, null, null), imageWriteParam);
                imageOutputStream.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (graphics2D != null) {
                    graphics2D.dispose();
                }
                if (imageWriter != null) {
                    imageWriter.dispose();
                }
                if (imageOutputStream != null) {
                    try {
                        imageOutputStream.close();
                    }
                    catch (IOException e) {}
                }
            }
        } else {
            String gravity = "SouthEast";
            if (watermarkPosition == Setting.WatermarkPosition.topLeft) {
                gravity = "NorthWest";
            } else if (watermarkPosition == Setting.WatermarkPosition.topRight) {
                gravity = "NorthEast";
            } else if (watermarkPosition == Setting.WatermarkPosition.center) {
                gravity = "Center";
            } else if (watermarkPosition == Setting.WatermarkPosition.bottomLeft) {
                gravity = "SouthWest";
            } else if (watermarkPosition == Setting.WatermarkPosition.bottomRight) {
                gravity = "SouthEast";
            }
            IMOperation operation = new IMOperation();
            operation.gravity(gravity);
            operation.dissolve(Integer.valueOf(alpha));
            operation.quality(Double.valueOf(DEST_QUALITY));
            operation.addImage(new String[]{watermarkFile.getPath()});
            operation.addImage(new String[]{srcFile.getPath()});
            operation.addImage(new String[]{destFile.getPath()});
            if (type == Type.graphicsMagick) {
                CompositeCmd compositeCmd = new CompositeCmd(true);
                if (graphicsMagickPath != null) {
                    compositeCmd.setSearchPath(graphicsMagickPath);
                }
                try {
                    compositeCmd.run((Operation)operation, new Object[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (IM4JavaException e) {
                    e.printStackTrace();
                }
            } else {
                CompositeCmd compositeCmd = new CompositeCmd(false);
                if (imageMagickPath != null) {
                    compositeCmd.setSearchPath(imageMagickPath);
                }
                try {
                    compositeCmd.run((Operation)operation, new Object[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (IM4JavaException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void initialize() {
    }

    private static String toHexEncoding(Color color) {
        StringBuffer stringBuffer = new StringBuffer();
        String R = Integer.toHexString(color.getRed());
        String G = Integer.toHexString(color.getGreen());
        String B = Integer.toHexString(color.getBlue());
        R = R.length() == 1 ? "0" + R : R;
        G = G.length() == 1 ? "0" + G : G;
        B = B.length() == 1 ? "0" + B : B;
        stringBuffer.append("#");
        stringBuffer.append(R);
        stringBuffer.append(G);
        stringBuffer.append(B);
        return stringBuffer.toString();
    }

    public static void main(String[] arg) {
        try {
            System.out.println("====>" + System.getenv());
            System.out.println("====>" + System.getenv("IM4JAVA_TOOLPATH"));
            System.out.println("====>" + System.getenv("JAVA_HOME"));
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    static {
        String[] paths;
        String pathVariable;
        String osName;
        type = Type.auto;
        BACKGROUND_COLOR = Color.white;
        DEST_QUALITY = 88;
        if (StringUtils.isBlank((CharSequence)graphicsMagickPath) && (osName = System.getProperty("os.name").toLowerCase()).indexOf("windows") >= 0 && StringUtils.isNotBlank((CharSequence)(pathVariable = System.getenv("Path")))) {
            for (String path : paths = pathVariable.split(";")) {
                File gmFile = new File(path.trim() + "/gm.exe");
                File gmdisplayFile = new File(path.trim() + "/gmdisplay.exe");
                if (!gmFile.exists() || !gmdisplayFile.exists()) continue;
                graphicsMagickPath = path.trim();
                break;
            }
        }
        if (StringUtils.isBlank((CharSequence)imageMagickPath) && (osName = System.getProperty("os.name").toLowerCase()).indexOf("windows") >= 0 && StringUtils.isNotBlank((CharSequence)(pathVariable = System.getenv("Path")))) {
            for (String path : paths = pathVariable.split(";")) {
                File convertFile = new File(path.trim() + "/convert.exe");
                File compositeFile = new File(path.trim() + "/composite.exe");
                if (!convertFile.exists() || !compositeFile.exists()) continue;
                imageMagickPath = path.trim();
                break;
            }
        }
        if (type.equals((Object)Type.auto)) {
            try {
                ConvertCmd cmd = null;
                cmd = new ConvertCmd(true);
                System.out.println(graphicsMagickPath);
                if (StringUtils.isNotBlank((CharSequence)graphicsMagickPath)) {
                    cmd.setSearchPath(graphicsMagickPath);
                }
                IMOperation operation = new IMOperation();
                operation.version();
                cmd.run((Operation)operation, new Object[0]);
                type = Type.graphicsMagick;
            }
            catch (Throwable e1) {
                try {
                    ConvertCmd cmd = null;
                    cmd = new ConvertCmd(false);
                    if (StringUtils.isNotBlank((CharSequence)imageMagickPath)) {
                        cmd.setSearchPath(imageMagickPath);
                    }
                    IMOperation operation = new IMOperation();
                    operation.version();
                    cmd.run((Operation)operation, new Object[0]);
                    type = Type.imageMagick;
                }
                catch (Throwable e2) {
                    type = Type.jdk;
                    e2.printStackTrace();
                }
            }
        }
    }
}

