/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.log.curd;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.DateUtils;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.log.curd.Loggerable;
import com.biz.eisp.log.curd.ModifyObject;
import com.biz.eisp.log.entity.TmExecuteMethodEntity;
import com.biz.eisp.log.entity.TmLogEntity;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.dict.util.DictUtil;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.persistence.JoinColumn;
import javax.persistence.Table;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.event.spi.AbstractEvent;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.springframework.stereotype.Component;

@Component
public class LoggerListener
implements PostInsertEventListener,
PostUpdateEventListener,
PostDeleteEventListener {
    private static final long serialVersionUID = 1L;

    public boolean requiresPostCommitHanding(EntityPersister entityPersister) {
        return true;
    }

    public void onPostInsert(PostInsertEvent event) {
        Object object = event.getEntity();
        if (object instanceof Loggerable) {
            String businessDesc = ((Loggerable)object).businessDesc();
            String content = ((Loggerable)object).addLogContent();
            if (StringUtil.isEmpty((String)content)) {
                String tableName = this.getTableNameByEntity(object, null, null);
                content = this.getAddLogContent(tableName, object);
            }
            TmLogEntity tmLogEntity = new TmLogEntity();
            tmLogEntity.setContent(content);
            tmLogEntity.setOperationType("INSERT");
            tmLogEntity.setBusinessId(this.getPropertyValue(object, "id"));
            tmLogEntity.setBusinessDesc(businessDesc);
            tmLogEntity.setPositionName(StringUtil.isNotEmpty((Object)ResourceUtil.getCurrPosition()) ? ResourceUtil.getCurrPosition().getPositionName() : "\u624b\u673a\u65b0\u589e");
            if (StringUtil.isNotEmpty((String)content)) {
                this.saveEntity((AbstractEvent)event, tmLogEntity);
            }
        }
    }

    public void onPostUpdate(PostUpdateEvent event) {
        Object object = event.getEntity();
        if (object instanceof Loggerable) {
            String businessDesc = ((Loggerable)object).businessDesc();
            int[] dirtyProperties = event.getDirtyProperties();
            Object[] old = event.getOldState();
            Object[] now = event.getState();
            String[] propertys = event.getPersister().getPropertyNames();
            String content = ((Loggerable)object).updateLogContent(this.getModifyObjectList(object, dirtyProperties, propertys, old, now));
            if (content == null && dirtyProperties != null && dirtyProperties.length > 0) {
                content = "";
                String tableName = this.getTableNameByEntity(object, null, null);
                for (int i = 0; i < dirtyProperties.length; ++i) {
                    Date newDate;
                    Map columnMap;
                    int index = dirtyProperties[i];
                    if ("updateName".equals(propertys[index]) || "createDate".equals(propertys[index]) || "createName".equals(propertys[index]) || "updateDate".equals(propertys[index]) || "createPosId".equals(propertys[index]) || "updatePosId".equals(propertys[index]) || "loginErrTimes".equals(propertys[index])) continue;
                    String propertyDesc = "";
                    String field = propertys[index];
                    Map descMap = (Map)DynamicConfigUtil.allTableConfigColumn.get(tableName);
                    if (descMap != null) {
                        propertyDesc = (String)descMap.get(field);
                    }
                    if (StringUtil.isEmpty((String)propertyDesc) && (columnMap = (Map)DynamicConfigUtil.allTableConfigField.get(tableName)) != null) {
                        String fieldName = this.getColumnNameByPropertyField(object, field);
                        propertyDesc = (String)columnMap.get(fieldName);
                    }
                    if (StringUtil.isEmpty((String)propertyDesc)) {
                        propertyDesc = field;
                    }
                    Object oldVal = null;
                    Object nowVal = null;
                    try {
                        oldVal = old[index];
                        nowVal = now[index];
                        if (StringUtil.isEmpty((Object)oldVal) && StringUtil.isEmpty((Object)nowVal)) {
                        }
                    }
                    catch (Exception e) {}
                    continue;
                    if (oldVal != null) {
                        if (!this.isBaseDataType(oldVal)) {
                            String propertyTableName;
                            String propertyField = this.getColumnNameByPropertyField(object, field);
                            Map fieldMap = (Map)DynamicConfigUtil.allTableConfigField.get(tableName);
                            if (fieldMap != null && !fieldMap.isEmpty()) {
                                propertyDesc = (String)fieldMap.get(propertyField);
                            }
                            if (StringUtil.isNotEmpty((String)(propertyTableName = this.getTableNameByEntity(oldVal, object, field)))) {
                                String nameProperty = this.getSearchColumnName(propertyTableName);
                                oldVal = this.getPropertyValue(oldVal, nameProperty);
                            } else {
                                oldVal = this.getPropertyValue(oldVal, "id");
                            }
                        }
                        if (oldVal instanceof Date) {
                            newDate = (Date)oldVal;
                            oldVal = DateUtils.date2Str((Date)newDate, (SimpleDateFormat)DateUtils.datetimeFormat);
                        }
                    }
                    if (nowVal != null) {
                        if (!this.isBaseDataType(nowVal)) {
                            String propertyTableName = this.getTableNameByEntity(nowVal, object, field);
                            if (StringUtil.isNotEmpty((String)propertyTableName)) {
                                String nameProperty = this.getSearchColumnName(propertyTableName);
                                nowVal = this.getPropertyValue(nowVal, nameProperty);
                            } else {
                                nowVal = this.getPropertyValue(nowVal, "id");
                            }
                        }
                        if (nowVal instanceof Date) {
                            newDate = (Date)nowVal;
                            nowVal = DateUtils.date2Str((Date)newDate, (SimpleDateFormat)DateUtils.datetimeFormat);
                        }
                    }
                    Map dictMap = (Map)DynamicConfigUtil.allTableConfigDictColumn.get(tableName);
                    String propertyDictType = null;
                    if (dictMap != null) {
                        propertyDictType = (String)dictMap.get(field);
                    }
                    if (StringUtil.isNotEmpty(propertyDictType)) {
                        Map map = DictUtil.getDictMap((String)propertyDictType);
                        AtomicReference<String> oldV = new AtomicReference<String>("");
                        if (map != null && map.size() > 0) {
                            Object finalOldVal = oldVal;
                            map.forEach((k, vv) -> {
                                KnlDictDataEntity tt = (KnlDictDataEntity)vv;
                                String v = String.valueOf(finalOldVal);
                                if (v.indexOf(",") != -1) {
                                    for (String str : v.split(",")) {
                                        if (!str.equals(tt.getDictCode())) continue;
                                        oldV.set((String)oldV.get() + " " + tt.getDictValue());
                                    }
                                } else if (v.equals(tt.getDictCode())) {
                                    oldV.set(tt.getDictValue());
                                }
                            });
                        }
                        content = StringUtil.isEmpty((String)oldV.get()) ? content + "\u5b57\u6bb5[<b>" + propertyDesc + "</b>],\u539f:<b>\u4e3a\u7a7a</b>" : content + "\u5b57\u6bb5[<b>" + propertyDesc + "</b>],\u539f:<b>" + oldV + "</b>";
                        AtomicReference<String> newV = new AtomicReference<String>("");
                        if (map != null && map.size() > 0) {
                            Object finalNowVal = nowVal;
                            map.forEach((k, vv) -> {
                                KnlDictDataEntity tt = (KnlDictDataEntity)vv;
                                String v = String.valueOf(finalNowVal);
                                if (v.indexOf(",") != -1) {
                                    for (String str : v.split(",")) {
                                        if (!str.equals(tt.getDictCode())) continue;
                                        newV.set((String)newV.get() + " " + tt.getDictValue());
                                    }
                                } else if (v.equals(tt.getDictCode())) {
                                    newV.set(tt.getDictValue());
                                }
                            });
                        }
                        if (StringUtil.isEmpty((Object)nowVal)) {
                            content = content + ",\u4fee\u6539\u4e3a:<b>\u7a7a</b></br>";
                            continue;
                        }
                        content = content + ",\u4fee\u6539\u4e3a:<b>" + newV + "</b></br>";
                        continue;
                    }
                    if ((oldVal == null || oldVal.toString().length() <= 0) && (nowVal == null || nowVal.toString().length() <= 0)) continue;
                    if (oldVal == null) {
                        oldVal = "\u4e3a\u7a7a";
                    }
                    if (nowVal == null) {
                        nowVal = "\u7a7a";
                    }
                    content = content + "\u5b57\u6bb5[<b>" + propertyDesc + "</b>],\u539f:<b>" + oldVal + ",\u4fee\u6539\u4e3a:<b>" + nowVal + "</b></br>";
                }
            }
            TmLogEntity tmLogEntity = new TmLogEntity();
            tmLogEntity.setContent(content);
            tmLogEntity.setOperationType("UPDATE");
            tmLogEntity.setBusinessId(this.getPropertyValue(object, "id"));
            tmLogEntity.setBusinessDesc(businessDesc);
            tmLogEntity.setPositionName(StringUtil.isNotEmpty((Object)ResourceUtil.getCurrPosition()) ? ResourceUtil.getCurrPosition().getPositionName() : "\u624b\u673a\u65b0\u589e");
            if (StringUtil.isNotEmpty((String)content)) {
                this.saveEntity((AbstractEvent)event, tmLogEntity);
                String saveExecuteMethod = ResourceUtil.getSysConfigProperty((String)"saveExecuteMethod");
                if (StringUtil.isNotBlank((String)saveExecuteMethod) && saveExecuteMethod.equals("Y")) {
                    this.saveExecuteMethodName(event, tmLogEntity.getId());
                }
            }
        }
    }

    private void saveExecuteMethodName(PostUpdateEvent event, String id) {
        Throwable ex = new Throwable();
        StackTraceElement[] stackElements = ex.getStackTrace();
        String msg = "\u8c03\u7528\u65b9\u6cd5\uff1a";
        if (stackElements != null) {
            for (StackTraceElement element : stackElements) {
                msg = msg + element.getFileName() + ";" + element.getMethodName() + "<br>";
            }
        }
        TmExecuteMethodEntity entity = new TmExecuteMethodEntity();
        entity.setBusinessId(id);
        entity.setContent(msg);
        this.saveEntity((AbstractEvent)event, entity);
    }

    public void onPostDelete(PostDeleteEvent event) {
        Object object = event.getEntity();
        if (object instanceof Loggerable) {
            String content = ((Loggerable)object).addLogContent();
            String businessDesc = ((Loggerable)object).businessDesc();
            if (StringUtil.isEmpty((String)content)) {
                String tableName = this.getTableNameByEntity(object, null, null);
                content = this.getAddLogContent(tableName, object);
            }
            TmLogEntity tmLogEntity = new TmLogEntity();
            tmLogEntity.setContent(content);
            tmLogEntity.setOperationType("DELETE");
            tmLogEntity.setBusinessId(this.getPropertyValue(object, "id"));
            tmLogEntity.setBusinessDesc(businessDesc);
            tmLogEntity.setPositionName(StringUtil.isNotEmpty((Object)ResourceUtil.getCurrPosition()) ? ResourceUtil.getCurrPosition().getPositionName() : "\u624b\u673a\u65b0\u589e");
            this.saveEntity((AbstractEvent)event, tmLogEntity);
        }
    }

    private List<ModifyObject> getModifyObjectList(Object object, int[] dirtyProperties, String[] propertys, Object[] oldVals, Object[] newVals) {
        ArrayList<ModifyObject> modifyList = new ArrayList<ModifyObject>();
        if (StringUtil.isNotEmpty((Object)dirtyProperties) && dirtyProperties.length > 0) {
            for (int i = 0; i < dirtyProperties.length; ++i) {
                ModifyObject modifyObject = new ModifyObject();
                int index = dirtyProperties[i];
                String field = propertys[index];
                if ("updateName".equals(propertys[index]) || "createDate".equals(propertys[index]) || "createName".equals(propertys[index]) || "updateDate".equals(propertys[index]) || "createPosId".equals(propertys[index]) || "updatePosId".equals(propertys[index]) || "loginErrTimes".equals(propertys[index])) continue;
                Object oldVal = oldVals[index];
                Object nowVal = newVals[index];
                modifyObject.setFieldName(field);
                modifyObject.setNowVal(nowVal);
                modifyObject.setOldVal(oldVal);
                modifyList.add(modifyObject);
            }
        }
        return modifyList;
    }

    private void saveEntity(AbstractEvent event, TmLogEntity tmLogEntity) {
        SessionFactory sessionFactory = event.getSession().getSessionFactory();
        Session session = sessionFactory.openSession();
        Transaction tx = session.beginTransaction();
        try {
            session.persist((Object)tmLogEntity);
            tx.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            tx.rollback();
        }
        session.close();
    }

    private void saveEntity(AbstractEvent event, TmExecuteMethodEntity tmExecuteMethodEntity) {
        SessionFactory sessionFactory = event.getSession().getSessionFactory();
        Session session = sessionFactory.openSession();
        Transaction tx = session.beginTransaction();
        try {
            session.persist((Object)tmExecuteMethodEntity);
            tx.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            tx.rollback();
        }
        session.close();
    }

    private String getPropertyValue(Object entity, String propertyName) {
        if (entity == null) {
            return null;
        }
        Class<?> clazz = entity.getClass();
        Object value = null;
        boolean flag = Loggerable.class.isAssignableFrom(clazz);
        if (flag) {
            try {
                PropertyDescriptor property = null;
                if (propertyName.equals("id")) {
                    Class<?> c = clazz.getSuperclass();
                    property = new PropertyDescriptor(propertyName, c);
                } else {
                    property = new PropertyDescriptor(propertyName, clazz);
                }
                Method getMethod = property.getReadMethod();
                value = getMethod.invoke(entity, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BusinessException(entity.getClass().getName() + "\u672a\u627e\u5230" + propertyName + "\u5c5e\u6027\u5b57\u6bb5");
            }
        }
        return (String)value;
    }

    private boolean isBaseDataType(Object param) {
        boolean flag = false;
        if (!StringUtil.isNotEmpty((Object)param)) {
            flag = true;
        }
        if (param instanceof Integer || param instanceof String || param instanceof Double || param instanceof Float || param instanceof Long || param instanceof Boolean || param instanceof Date || param instanceof Short || param instanceof BigDecimal) {
            flag = true;
        }
        return flag;
    }

    private String getAddLogContent(String tableName, Object entity) {
        String logContent = "";
        Field[] fields = entity.getClass().getDeclaredFields();
        if (!CollectionUtil.mapNotEmpty((Map)((Map)DynamicConfigUtil.allTableConfigColumn.get(tableName)))) {
            return "\u5b9e\u4f53" + entity.getClass().getSimpleName() + ",\u65b0\u589e\u65e5\u5fd7logContent\u65b9\u6cd5\u8fd4\u56de\u4e3a\u7a7a\u4e14\u4e0d\u5b58\u5728\u4e3b\u6570\u636e\u52a8\u6001\u914d\u7f6e\u8868";
        }
        try {
            for (Field field : fields) {
                String name = field.getName();
                if (StringUtil.equals((String)name, (String)"serialVersionUID") || "updateName".equals(name) || "updateDate".equals(name) || "createName".equals(name) || "createPosId".equals(name) || "updatePosId".equals(name) || "createDate".equals(name)) continue;
                PropertyDescriptor property = new PropertyDescriptor(name, entity.getClass());
                Method getMethod = property.getReadMethod();
                Object value = getMethod.invoke(entity, new Object[0]);
                Object propertyValue = null;
                if (value == null || value instanceof List) continue;
                String propertyDesc = "";
                if (this.isBaseDataType(value)) {
                    Map fieldMap = (Map)DynamicConfigUtil.allTableConfigColumn.get(tableName);
                    propertyDesc = (String)fieldMap.get(name);
                    propertyValue = value;
                    Map dictMap = (Map)DynamicConfigUtil.allTableConfigDictColumn.get(tableName);
                    String propertyDictType = null;
                    if (dictMap != null) {
                        propertyDictType = (String)dictMap.get(name);
                    }
                    if (StringUtil.isNotEmpty(propertyDictType)) {
                        AtomicReference<String> dictValue = new AtomicReference<String>("");
                        Map map = DictUtil.getDictMap((String)propertyDictType);
                        if (map != null && map.size() > 0) {
                            map.forEach((k, vv) -> {
                                KnlDictDataEntity tt = (KnlDictDataEntity)vv;
                                String v = String.valueOf(value);
                                if (v.indexOf(",") != -1) {
                                    for (String str : v.split(",")) {
                                        if (!str.equals(tt.getDictCode())) continue;
                                        dictValue.set((String)dictValue.get() + " " + tt.getDictValue());
                                    }
                                } else if (v.equals(tt.getDictCode())) {
                                    dictValue.set(tt.getDictValue());
                                }
                            });
                        }
                        propertyValue = StringUtil.isNotEmpty((String)dictValue.get()) ? dictValue.get() : propertyValue;
                    }
                } else {
                    Map columnMap = (Map)DynamicConfigUtil.allTableConfigField.get(tableName);
                    String fieldName = this.getColumnNameByPropertyField(entity, field.getName());
                    propertyDesc = (String)columnMap.get(fieldName);
                    Class<?> clazz = property.getPropertyType();
                    boolean hasTableName1 = clazz.isAnnotationPresent(Table.class);
                    if (hasTableName1) {
                        Table table = clazz.getAnnotation(Table.class);
                        String tablename = table.name();
                        String propertyName = this.getSearchColumnName(tablename);
                        propertyValue = this.getPropertyValue(value, propertyName);
                    }
                }
                if (!StringUtil.isNotEmpty((Object)propertyValue) || !StringUtil.isNotEmpty((String)propertyDesc)) continue;
                logContent = logContent + "\u5b57\u6bb5[<b>" + propertyDesc + "</b>]:" + propertyValue + "<br>";
            }
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return logContent;
    }

    private String getTableNameByEntity(Object obj, Object pobj, String field) {
        String tableName = null;
        boolean hasTableName = obj.getClass().isAnnotationPresent(Table.class);
        if (hasTableName) {
            Table table = obj.getClass().getAnnotation(Table.class);
            tableName = table.name().toUpperCase();
        } else {
            try {
                PropertyDescriptor property = new PropertyDescriptor(field, pobj.getClass());
                Class<?> clazz = property.getPropertyType();
                boolean hasTableName1 = clazz.isAnnotationPresent(Table.class);
                if (hasTableName1) {
                    Table table = clazz.getAnnotation(Table.class);
                    tableName = table.name().toUpperCase();
                }
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
        }
        return tableName;
    }

    private String getColumnNameByPropertyField(Object entity, String field) {
        if (entity == null) {
            return null;
        }
        String fieldName = null;
        try {
            Class<?> clazz = entity.getClass();
            PropertyDescriptor property = new PropertyDescriptor(field, clazz);
            Method getMethod = property.getReadMethod();
            boolean hasJoinColumn = getMethod.isAnnotationPresent(JoinColumn.class);
            if (hasJoinColumn) {
                JoinColumn table = getMethod.getAnnotation(JoinColumn.class);
                fieldName = table.name().toUpperCase();
            }
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        return fieldName;
    }

    private String getSearchColumnName(String tableName) {
        if (StringUtil.isNotEmpty((String)tableName)) {
            tableName = tableName.toLowerCase();
        }
        tableName = tableName.substring(3, tableName.length());
        StringBuffer sb = new StringBuffer("Name");
        String propertyName = "";
        propertyName = tableName.indexOf("_") == -1 ? tableName : StringUtil.underlineToCamel((String)tableName);
        return sb.insert(0, propertyName).toString();
    }
}

