/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.config.service.impl;

import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.mdm.config.bean.ExportExcelConfig;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.config.service.DynamicExportFieldService;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="dynamicExportFieldService")
@Transactional
public class DefaultDynamicExportFieldServiceImpl
implements DynamicExportFieldService {
    public ExportExcelConfig getExportExcelConfig(String tableName, String fieldName) {
        ExportExcelConfig exportExcelConfig = null;
        String tableConfigKey = tableName + fieldName;
        TmMdmTableConfigEntity configEntity = (TmMdmTableConfigEntity)DynamicConfigUtil.allTableConfigByField.get(tableConfigKey.toLowerCase());
        if (StringUtil.isNotEmpty((Object)configEntity)) {
            exportExcelConfig = new ExportExcelConfig();
            Integer isExport = configEntity.getImportOut();
            Integer columnOrder = StringUtil.isNotEmpty((String)configEntity.getColumnOrder()) ? Integer.parseInt(configEntity.getColumnOrder()) : 0;
            String exportName = StringUtil.isNotEmpty((String)configEntity.getFieldName()) ? configEntity.getFieldName() : configEntity.getColumnDesc();
            exportExcelConfig.setIsExport(OConvertUtils.getString((Object)isExport));
            exportExcelConfig.setExportName(exportName);
            exportExcelConfig.setExprotOrder(OConvertUtils.getString((Object)columnOrder));
            exportExcelConfig.setDictCode(configEntity.getDictType());
            System.out.println(exportName + ":" + columnOrder);
        } else {
            exportExcelConfig = null;
        }
        return exportExcelConfig;
    }

    public boolean judgeIsExport(ExportExcelConfig exportExcelConfig) {
        if (!StringUtil.isNotEmpty((Object)exportExcelConfig)) {
            return false;
        }
        if (StringUtil.isEmpty((String)exportExcelConfig.getIsExport())) {
            return false;
        }
        return !"0".equals(exportExcelConfig.getIsExport());
    }
}

